#' @title saeHB.gpois : SAE using HB Method under Generalized Poisson Distribution
#'
#' @description Provides function and datasets for area level of Small Area Estimation using Hierarchical Bayesian Method under Generalized Poisson Distribution.
#'
#' @section Author(s):
#' Joice Evangelista Lase, Azka Ubaidillah
#'
#' \strong{Maintaner}: Joice Evangelista Lase \email{221810359@@stis.ac.id}
#'
#' @section Functions:
#' \describe{
#'   \item{\code{\link{GPois}}}{The function produces small area estimator under Generalized Poisson Model Using Hierarchical Bayesian Method with Generalized Poisson distribution based on GP-1 model introduced by Consul (1989).}
#' }
#'
#' @section Reference:
#' \itemize{
#'    \item{Rao, J.N.K & Molina. (2015). Small Area Estimation 2nd Edition. New Jersey: John Wiley and Sons, Inc. <doi:10.1002/9781118735855>.}
#'    \item{Wang, G. (2021). Bayesian regression models for ecological count data in PyMC3. Ecological Informatics, 63, 101301. <doi:10.1016/j.ecoinf.2021.101301>.}
#'    \item{Ntzoufras, I. (2009). Bayesian Modelling Using WinBUGS. New Jersey :  John Wiley & Sons, Inc. <doi:10.1002/9780470434567>.}
#' }
#'
#' @docType package
#' @name saeHB.gpois
#'
#' @import stringr
#' @import coda
#' @import rjags
#' @import stats
#' @import grDevices
#' @import graphics
#'
NULL
