% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sSDR.R
\name{gSIR.comp.d}
\alias{gSIR.comp.d}
\title{Groupwise SIR (gSIR) BIC criterion to estimate dimensions with
eigen-decomposition (binary response)}
\usage{
gSIR.comp.d(X, y, groups, Gamma)
}
\arguments{
\item{X}{A covariate matrix of n observations and p predictors.}

\item{y}{A binary response.}

\item{groups}{A vector with the number of predictors in each group.}

\item{Gamma}{A p x p identity matrix.}
}
\value{
gSIR.comp.d returns a list containning at least the following
components:
"d", the estimated dimension (at most 1) for each predictor group;
"crit", the BIC criterion from each iteration.
}
\description{
Groupwise SIR (gSIR) BIC criterion to estimate dimensions with
eigen-decomposition (binary response)
}
\details{
This function estimates dimension for each predictor group using
eigen-decomposition. Predictors need to be organized in groups within the
"X" matrix, as the same order saved in "groups". We only allow continuous
covariates in the "X" matrix; while categorical covariates can be handled
outside of gSIR, e.g. structured SIR.
}
\examples{
data <- gen.data(n=1000, binary=TRUE) # generate data
dim(data$X) # covariate matrix of 1000 observations and 15 predictors
length(data$y) # univariate response
groups <- c(5, 10) # two predictor groups and their numbers of predictors
Gamma <- diag(sum(groups)) # identity matrix
dim_gSIR<-gSIR.comp.d(data$X,data$y,groups,Gamma)
names(dim_gSIR)
}
\references{
Liu, Y. (2015). Approaches to reduce and integrate data in
structured and high-dimensional regression problems in Genomics. Ph.D.
Dissertation, The Pennsylvania State University, University Park,
Department of Statistics.
}

