% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2-cell.R
\name{s2_cell}
\alias{s2_cell}
\alias{s2_cell_sentinel}
\alias{s2_cell_invalid}
\alias{as_s2_cell}
\alias{as_s2_cell.s2_cell}
\alias{as_s2_cell.character}
\alias{as_s2_cell.s2_geography}
\alias{as_s2_cell.wk_xy}
\alias{new_s2_cell}
\title{Create S2 Cell vectors}
\usage{
s2_cell(x = character())

s2_cell_sentinel()

s2_cell_invalid()

s2_cell_sentinel()

as_s2_cell(x, ...)

\method{as_s2_cell}{s2_cell}(x, ...)

\method{as_s2_cell}{character}(x, ...)

\method{as_s2_cell}{s2_geography}(x, ...)

\method{as_s2_cell}{wk_xy}(x, ...)

new_s2_cell(x)
}
\arguments{
\item{x}{The canonical S2 cell identifier as a character vector.}

\item{...}{Passed to methods}
}
\value{
An object of class s2_cell
}
\description{
The S2 cell indexing system forms the basis for spatial indexing
in the S2 library. On their own, S2 cells can represent points
or areas. As a union, a vector of S2 cells can approximate a
line or polygon. These functions allow direct access to the
S2 cell indexing system and are designed to have minimal overhead
such that looping and recursion have acceptable performance
when used within R code.
}
\details{
Under the hood, S2 cell vectors are represented in R as vectors
of type \code{\link[=double]{double()}}. This works because S2 cell identifiers are
64 bits wide, as are \code{double}s on all systems where R runs (The
same trick is used by the bit64 package to represent signed
64-bit integers). As a happy accident, \code{NA_real_} is not a valid
or meaningful cell identifier, so missing value support in the
way R users might expect is preserved. It is worth noting that
the underlying value of \code{s2_cell_sentinel()} would normally be
considered \code{NA}; however, as it is meaningful and useful when
programming with S2 cells, custom \code{is.na()} and comparison methods
are implemented such that \code{s2_cell_sentinel()} is greater than
all valid S2 cells and not considered missing. Users can and should
implement compiled code that uses the underlying bytes of the
vector, ensuring that the class of any returned object that should
be interpreted in this way is constructed with \code{new_s2_cell()}.
}
\examples{
s2_cell("4b59a0cd83b5de49")
as_s2_cell(s2_lnglat(-64, 45))
as_s2_cell(s2_data_cities("Ottawa"))

}
