% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_content_all.R
\name{get_content_all}
\alias{get_content_all}
\title{Content endpoint (all)}
\usage{
get_content_all(query, timeout = 2, begin_date = NULL, end_date = NULL,
  api_key = Sys.getenv("ZEIT_ONLINE_KEY"))
}
\arguments{
\item{query}{character. Search query term.}

\item{timeout}{integer. Seconds to wait between queries.}

\item{begin_date}{begin_date character. Begin date - Restricts responses to results with publication dates of the date specified or later. In the form YYYYMMDD.}

\item{end_date}{character. End date - Restricts responses to results with publication dates of the date specified or earlier. In the form YYYYMMDD.}

\item{api_key}{api_key character. The personal api code. To request an API key see: \url{http://developer.zeit.de/quickstart/} This parameter is by default set to the R Environment.}
}
\value{
A list including articles and meta information about the query.
}
\description{
Exposes a search in the ZEIT online archive on the content endpoint and returns results for the given query. Performs multiple queries if limit exceeds 1000 rows.
}
\details{
\code{get_content} is the function, which interacts directly with the ZEIT Online API. I only used the content endpoint for this package. There are further endpoints (e.g. /author, /product) not included into this package to further specify the search if needed. The whole list of possible endpoints can be accessed here \url{http://developer.zeit.de/docs/}.
}
\examples{
\dontrun{
get_content(query = "Merkel")
 }

}
\references{
\url{http://developer.zeit.de}
}
\seealso{
\code{\link{get_content}}
}
\author{
Jan Dix <\email{jan.dix@uni-konstanz.de}>
}
