% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.toClassicEvid}
\alias{.toClassicEvid}
\title{This converts NONMEM-style EVIDs to classic RxODE events}
\usage{
.toClassicEvid(cmt = 1L, amt = 0, rate = 0, dur = 0, ii = 0, evid = 0L, ss = 0)
}
\arguments{
\item{cmt}{compartment flag}

\item{amt}{dose amount}

\item{rate}{dose rate}

\item{dur}{dose duration}

\item{ii}{inter-dose interval}

\item{evid}{event id}

\item{ss}{steady state}
}
\value{
classic evids, excluding evids that are added (you need to
add them manually) or simply use etTran.  This is mostly for
testing and really shouldn't be used directly.
}
\description{
This converts NONMEM-style EVIDs to classic RxODE events
}
\examples{
.toClassicEvid(cmt=10, amt=3, evid=1)
.toClassicEvid(cmt=10, amt=3, rate=2, evid=1)
.toClassicEvid(cmt=10, amt=3, rate=-1, evid=1)
.toClassicEvid(cmt=10, amt=3, rate=-2, evid=1)
.toClassicEvid(cmt=10, amt=3, dur=2, evid=1)
.toClassicEvid(cmt=304, amt=3, dur=2, evid=1)
.toClassicEvid(cmt=7, amt=0, rate=2, evid=1, ss=1)
.toClassicEvid(cmt=-10, amt=3, evid=1)
.toClassicEvid(cmt=10, amt=3, evid=5)
.toClassicEvid(cmt=6, amt=3, evid=6)
.toClassicEvid(cmt=6, amt=3, evid=7)
.toClassicEvid(evid=2)
.toClassicEvid(evid=4)
}
\author{
Matthew L. Fidler
}
