% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FWT2_PO.R
\name{FWT2_PO}
\alias{FWT2_PO}
\title{2-d MRA wavelet transform (periodized, orthogonal).}
\usage{
FWT2_PO(x, L, qmf)
}
\arguments{
\item{x}{2-d image (n by n array, n dyadic).}

\item{L}{coarse level.}

\item{qmf}{quadrature mirror filter.}
}
\value{
\code{wc} 2-d wavelet transform.
}
\description{
A two-dimensional Wavelet Transform is computed for the array x.
\code{qmf} filter may be obtained from \code{\link{MakeONFilter}}.
To reconstruct, use \code{\link{IWT2_PO}}.
}
\examples{
qmf <- MakeONFilter('Daubechies', 10)
L <- 3
x <- matrix(rnorm(128^2),ncol=128)
wc <- FWT2_PO(x, L, qmf)
}
\seealso{
\code{\link{IWT2_PO}}, \code{\link{MakeONFilter}}.
}
