% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wave_match.R
\name{wave_match}
\alias{wave_match}
\title{Adjust the wavelength solution of a spectrum}
\usage{
wave_match(wvl1, flx1, targetwvl)
}
\arguments{
\item{wvl1}{vector of wavelengths for the spectrum to be interpolated}

\item{flx1}{vector of normalized flux for the spectrum to be interpolated}

\item{targetwvl}{vector of wavelengths to interpolate to.}
}
\value{
A vector of normalized flux for the spectrum at the targetwvl wavelengths. Only flux for targetwvl wavelengths that are contained by the wvl1 wavelengths are returned.
}
\description{
This function takes the wavelength and flux vectors of a normalized spectrum
and uses cubic-spline interpolation to adjust the flux vector to match a new
wavelength solution.
}
\examples{
x = seq(0,10)
y = 5*sin(x + 2)
newx = seq(0.5, 9.5)
newy = wave_match(x, y, newx)
plot(x, y)
points(newx, newy, col=2, pch=19)
}
