% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_draws.R
\name{pool_draws}
\alias{pool_draws}
\alias{pool_draws.data.frame}
\alias{pool_draws.grouped_df}
\title{Pool Draws}
\usage{
pool_draws(data, by = NULL)

\method{pool_draws}{data.frame}(data, by = NULL)

\method{pool_draws}{grouped_df}(data, by = NULL)
}
\arguments{
\item{data}{A data frame with one or
more rvecs. Can be
\href{https://dplyr.tidyverse.org/reference/group_data.html}{grouped}.}

\item{by}{The variables distingishing
units after combining. Used if
\code{data} is not
\href{https://dplyr.tidyverse.org/reference/group_data.html}{grouped}.}
}
\value{
A data frame.
}
\description{
Combine draws within each
combination of grouping or 'by' variables
in a data frame.
}
\details{
Each combination of grouping or 'by'
variables must have the same
number of rows.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

df <-  tibble(
  a = c(1, 1, 2, 2),
  x = rvec(list(1:2, 3:4, 5:6, 7:8))
)
df
df |> pool_draws(by = a)
df |> group_by(a) |> pool_draws()
df |> pool_draws()

df_big <- tibble(
  a = c(1, 1, 2, 2, 1, 1, 2, 2),
  b = c(1, 1, 1, 1, 2, 2, 2, 2),
  x = rvec(list(1:2, 3:4, 5:6, 7:8,
                9:10, 11:12, 13:14, 15:16)),
  y = rvec(list(1:3, 4:6, 7:9, 10:12,
                13:15, 16:18, 19:21, 22:24))
)
df_big |> pool_draws(by = c(a, b))
df_big |> group_by(a, b) |> pool_draws()
df_big |> pool_draws(by = a)
}
\seealso{
\itemize{
\item \code{\link[=collapse_to_rvec]{collapse_to_rvec()}} Convert from 'draws-and-value'
fromat to rvec format
\item \code{\link[=expand_from_rvec]{expand_from_rvec()}} Convert from rvec format to
'draws-and-value' format
}
}
