% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_worker.R
\name{start_worker}
\alias{start_worker}
\title{Start a worker}
\usage{
start_worker(network_id, worker_id = NULL, remote = TRUE, ...)
}
\arguments{
\item{network_id}{(\code{character(1)})\cr
Identifier of the rush network.
Controller and workers must have the same instance id.
Keys in Redis are prefixed with the instance id.}

\item{worker_id}{(\code{character(1)})\cr
Identifier of the worker.
Keys in redis specific to the worker are prefixed with the worker id.}

\item{remote}{(\code{logical(1)})\cr
Whether the worker is on a remote machine.}

\item{...}{(\code{any})\cr
Arguments passed to \link[redux:redis_config]{redux::redis_config}.}
}
\value{
\code{NULL}
}
\description{
Starts a worker.
The function loads the globals and packages, initializes the \link{RushWorker} instance and invokes the worker loop.
This function is called by \verb{$start_local_workers()} or by the user after creating the worker script with \verb{$create_worker_script()}.
Use with caution.
The global environment is changed.
}
\note{
The function initializes the connection to the Redis data base.
It loads the packages and copies the globals to the global environment of the worker.
The function initialize the \link{RushWorker} instance and starts the worker loop.
}
\examples{
# This example is not executed since Redis must be installed
\dontrun{
  rush::start_worker(
   network_id = 'test-rush',
   remote = TRUE,
   url = 'redis://127.0.0.1:6379',
   scheme = 'redis',
   host = '127.0.0.1',
   port = '6379')
}
}
