% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C5_rules_C5.0.R
\name{details_C5_rules_C5.0}
\alias{details_C5_rules_C5.0}
\title{C5.0 rule-based classification models}
\description{
\code{\link[C50:C5.0]{C50::C5.0()}} fits model that derives feature rules from a tree for
prediction. A single tree or boosted ensemble can be used. \code{\link[=c5_fit]{c5_fit()}}
is a wrapper around this function.
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This model has 2 tuning parameters:
\itemize{
\item \code{trees}: # Trees (type: integer, default: 1L)
\item \code{min_n}: NA (type: NA, default: 2L)
}

Note that C5.0 has a tool for \emph{early stopping} during boosting where
less iterations of boosting are performed than the number requested.
\code{C5_rules()} turns this feature off (although it can be re-enabled using
\code{\link[C50:C5.0Control]{C50::C5.0Control()}}).
}

\subsection{Translation from parsnip to the underlying model call (regression)}{\if{html}{\out{<div class="r">}}\preformatted{C5_rules(
  trees = integer(1),
  min_n = integer(1)
) \%>\%
  set_engine("C5.0") \%>\%
  set_mode("classification") \%>\%
  translate()
}\if{html}{\out{</div>}}\preformatted{## C5.0 Model Specification (classification)
## 
## Main Arguments:
##   trees = integer(1)
##   min_n = integer(1)
## 
## Computational engine: C5.0 
## 
## Model fit template:
## rules::c5_fit(x = missing_arg(), y = missing_arg(), weights = missing_arg(), 
##     trials = integer(1), minCases = integer(1))
}
}

\subsection{Preprocessing requirements}{

This engine does not require any special encoding of the predictors.
Categorical predictors can be partitioned into groups of factor levels
(e.g. \verb{\{a, c\}} vs \verb{\{b, d\}}) when splitting at a node. Dummy variables
are not required for this model.
}

\subsection{References}{
\itemize{
\item Quinlan R (1992). “Learning with Continuous Classes.” Proceedings of
the 5th Australian Joint Conference On Artificial Intelligence,
pp. 343-348.
\item Quinlan R (1993).“Combining Instance-Based and Model-Based
Learning.” Proceedings of the Tenth International Conference on
Machine Learning, pp. 236-243.
\item Kuhn M and Johnson K (2013). \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
