% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{rules}
\alias{rules}
\title{Create a list of rules}
\usage{
rules(..., .args = list(), .prefix = "._.")
}
\arguments{
\item{...}{A list of functions (as in \link[dplyr:funs]{funs}).}

\item{.args}{A named list of additional arguments to be added to all function
calls (as in \link[dplyr:funs]{funs}).}

\item{.prefix}{Prefix to be added to function names.}
}
\description{
\code{rules()} is a wrapper for \code{dplyr}'s \link[dplyr:funs]{funs} which provides a
different naming scheme.
}
\details{
\code{rules()} behaves exactly as \code{funs()} with only difference being the
names of the output. The following naming scheme is applied:
\itemize{
\item Absent names are replaced with the 'rule..\{ind\}' where \{ind\} is the
index of function position in the \code{...} .
\item \code{.prefix} is added at the beginning of all names. The default is \code{._.} . It
is picked for its symbolism (it is the Morse code of letter 'R') and rare
occurrence in names. In those rare cases it can be manually changed but
this will not be tracked further.
}
}
\examples{
rules_1 <- rules(mean, sd, .args = list(na.rm = TRUE))
rules_1_ref <- dplyr::funs('._.rule..1' = mean, '._.rule..2' = sd,
                           .args = list(na.rm = TRUE))
identical(rules_1, rules_1_ref)

rules_2 <- rules(mean, sd = sd, "var")
rules_2_ref <- dplyr::funs(
  '._.rule..1' = mean,
  '._.sd' = sd,
  '._.rule..3' = "var"
)
identical(rules_2, rules_2_ref)

rules_3 <- rules(mean, .prefix = "__")
rules_3_ref <- dplyr::funs('__rule..1' = mean)
identical(rules_3, rules_3_ref)

}
