% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{class}
\name{CramerLundberg-class}
\alias{CramerLundberg-class}
\title{A formal S4 class CramerLundberg}
\description{
A formal S4 class representation of classical Cramer-Lundberg model.
}
\details{
The model is defined as follows:
\deqn{X(t) = u + ct - \sum_{i=1}^{N(t)} Y_i,}
where \eqn{u} is the initial capital (\code{initial_capital}), \eqn{c} is the
premium rate (\code{premium_rate}), \eqn{N(t)} is the Poisson process with
intensity \eqn{\lambda} (\code{claim_poisson_arrival_rate}), \eqn{Y_i} are
iid claim sizes (\code{claim_size_generator} and \code{claim_size_parameters}
).

Objects of class can be created only by using the constructor
\code{\link{CramerLundberg}}.
}
\section{Slots}{

\describe{
\item{\code{initial_capital}}{a length one numeric non-negative vector specifying an
initial capital.}

\item{\code{premium_rate}}{a length one numeric non-negative vector specifying a
premium rate.}

\item{\code{claim_poisson_arrival_rate}}{a length one numeric positive vector
specifying the rate of the Poisson process of claims' arrivals.}

\item{\code{claim_size_generator}}{a function indicating the random generator of
claims' sizes.}

\item{\code{claim_size_parameters}}{a named list containing parameters for the
random generator of claims' sizes.}
}}

\references{
Albrecher H., Asmussen A. \emph{Ruin Probabilities}. World Scientific, 2010.
}
\seealso{
\code{\link{CramerLundberg}}
}
