% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{next_cursor}
\alias{cursor_next}
\alias{next_cursor}
\alias{next_page}
\title{next_cursor}
\usage{
next_cursor(ids)
}
\arguments{
\item{ids}{Data frame of Twitter IDs generated via
\code{\link{get_followers}} or \code{\link{get_friends}}.}
}
\value{
Character string of next cursor value used to retrieved
  the next page of results. This should be used to resume data
  collection efforts that were interrupted by API rate limits.
  Modify previous data request function by entering the returned
  value from \code{next_cursor} for the \code{page} argument.
}
\description{
Returns next cursor value from ids object. Return
  object used to retrieve next page of results from API request.
}
\examples{
\dontrun{
# Retrieve user ids of accounts following POTUS
f1 <- get_followers("potus", n = 75000)
page <- next_cursor(f1)

# max. number of ids returned by one token is 75,000 every 15
# minutes, so you'll need to wait a bit before collecting the
# next batch of ids
sys.Sleep(15*60) # Suspend execution of R expressions for 15 mins

# Use the page value returned from \\code{next_cursor} to continue
# where you left off.
f2 <- get_followers("potus", n = 75000, page = page)
}

}
\seealso{
Other ids: \code{\link{get_followers}},
  \code{\link{get_friends}}
}

