% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statuses.R
\name{lookup_statuses}
\alias{lookup_statuses}
\title{lookup_tweets}
\usage{
lookup_statuses(statuses, token = NULL, parse = TRUE)
}
\arguments{
\item{statuses}{User id or screen name of target user.}

\item{token}{OAuth token (1.0 or 2.0). By default
\code{token = NULL} fetches a non-exhausted token from
an environment variable @describeIn tokens.}

\item{parse}{Logical, indicating whether or not to parse
return object into data frame(s)}
}
\value{
json response object (max is 18000 per token)
}
\description{
Returns Twitter user data_frame object for
  specified user_ids or screen_names.
}
\examples{
\dontrun{
# lookup vector of 1 or more user_id or screen_name
statuses <- c("potus", "hillaryclinton", "realdonaldtrump",
  "fivethirtyeight", "cnn", "espn", "twitter")

twt_df <- lookup_statuses(statuses)
twt_df

# view tweet data for these statuses via tweets_data()
tweets_data(twt_df)
}

}
\seealso{
\url{https://dev.twitter.com/overview/documentation}

Other tweets: \code{\link{get_favorites}},
  \code{\link{get_timeline}}, \code{\link{search_tweets}},
  \code{\link{stream_tweets}}, \code{\link{tweets_data}}
}

