% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{basic_table}
\alias{basic_table}
\title{Layout with 1 column and zero rows}
\usage{
basic_table(
  title = "",
  subtitles = character(),
  main_footer = character(),
  prov_footer = character(),
  header_section_div = NA_character_,
  show_colcounts = FALSE,
  colcount_format = "(N=xx)",
  inset = 0L
)
}
\arguments{
\item{title}{character(1). Main title (\code{\link[=main_title]{main_title()}}) is a single string.
Ignored for subtables.}

\item{subtitles}{character. Subtitles (\code{\link[=subtitles]{subtitles()}}) can be vector of strings, where
every element is printed in a separate line. Ignored for subtables.}

\item{main_footer}{character. Main global (non-referential) footer materials
(\code{\link[=main_footer]{main_footer()}}). If it is a vector of strings, they will be printed on separate
lines.}

\item{prov_footer}{character. Provenance-related global footer materials
(\code{\link[=prov_footer]{prov_footer()}}). It can be also a vector of strings, printed on different lines.
Generally should not be modified by hand.}

\item{header_section_div}{character(1). String which will be used to divide the header
from the table. See \code{\link[=header_section_div]{header_section_div()}} for getter and setter of these.
Please consider changing last element of \code{\link[=section_div]{section_div()}} when concatenating
tables that need a divider between them.}

\item{show_colcounts}{logical(1). Should column counts be displayed in the
resulting table when this layout is applied to data}

\item{colcount_format}{character(1). Format for use when displaying the
column counts. Must be 1d, or 2d where one component is a percent. See
details.}

\item{inset}{numeric(1). Number of spaces to inset the table header, table
body, referential footnotes, and main_footer, as compared to alignment
of title, subtitle, and provenance footer. Defaults to 0 (no inset).}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further
layouting functions, and to \code{build_table}.
}
\description{
Every layout must start with a basic table.
}
\details{
\code{colcount_format} is ignored if \code{show_colcounts} is \code{FALSE} (the default).
When \code{show_colcounts} is \code{TRUE}, and \code{colcount_format} is 2-dimensional with
a percent component, the value component for the percent is always populated
with \code{1} (i.e. 100\%). 1d formats are used to render the counts exactly as they
normally would be, while 2d formats which don't include a percent, and all 3d
formats result in an error. Formats in the form of functions are not supported for
\code{colcount} format. See \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} for
the list of valid format labels to select from.
}
\note{
\itemize{
\item Because percent components in \code{colcount_format} are \emph{always}
populated with the value 1, we can get arguably strange results, such as
that individual arm columns and a combined "all patients" column all
list "100\%" as their percentage, even though the individual arm columns
represent strict subsets of the all patients column.
\item Note that subtitles (\code{\link[=subtitles]{subtitles()}}) and footers (\code{\link[=main_footer]{main_footer()}} and \code{\link[=prov_footer]{prov_footer()}})
that spans more than one line can be supplied as a character vector to maintain
indentation on multiple lines.
}
}
\examples{

lyt <- basic_table() \%>\%
  analyze("AGE", afun = mean)

tbl <- build_table(lyt, DM)
tbl

lyt2 <- basic_table(
  title = "Title of table",
  subtitles = c("a number", "of subtitles"),
  main_footer = "test footer",
  prov_footer = paste(
    "test.R program, executed at",
    Sys.time()
  )
) \%>\%
  split_cols_by("ARM") \%>\%
  analyze("AGE", mean)

tbl2 <- build_table(lyt2, DM)
tbl2

lyt3 <- basic_table(
  show_colcounts = TRUE,
  colcount_format = "xx. (xx.\%)"
) \%>\%
  split_cols_by("ARM")

}
