% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_toString.R
\name{matrix_form,VTableTree-method}
\alias{matrix_form,VTableTree-method}
\title{Transform rtable to a list of matrices which can be used for outputting}
\usage{
\S4method{matrix_form}{VTableTree}(obj, indent_rownames = FALSE)
}
\arguments{
\item{obj}{ANY. The object for the accessor to access or modify}

\item{indent_rownames}{logical(1), if TRUE the column with the row names in the \code{strings} matrix of has indented row
names (strings pre-fixed)}
}
\value{
A list with the following elements:
\describe{
\item{strings}{The content, as it should be printed, of the top-left material, column headers, row labels , and cell values of \code{tt}}
\item{spans}{The column-span information for each print-string in the strings matrix}
\item{aligns}{The text alignment for each print-string in the strings matrix}
\item{display}{Whether each print-string in the strings matrix should be printed or not}.
\item{row_info}{the data.frame generated by \code{summarize_rows(tt)}}
}

With an additional \code{nrow_header} attribute indicating the number of pseudo "rows"  the
column structure defines.
}
\description{
Although rtables are represented as a tree data structure when outputting the table to ASCII or HTML it is useful to
map the rtable to an in between state with the formatted cells in a matrix form.
}
\details{
The strings in the return object are defined as follows: row labels are those determined by \code{summarize_rows} and cell values are determined using \code{get_formatted_cells}. (Column labels are calculated using a non-exported internal funciton.
}
\examples{
library(dplyr)

iris2 <- iris \%>\%
  group_by(Species) \%>\%
  mutate(group = as.factor(rep_len(c("a", "b"), length.out = n()))) \%>\%
  ungroup()

l <- basic_table() \%>\%
  split_cols_by("Species") \%>\%
  split_cols_by("group") \%>\%
  analyze(c("Sepal.Length", "Petal.Width"), afun = list_wrap_x(summary) , format = "xx.xx")

l

tbl <- build_table(l, iris2)

matrix_form(tbl)
}
