% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key-handlers.R
\name{set_synthesize_token}
\alias{set_synthesize_token}
\title{Set Synthesize Bio API Token}
\usage{
set_synthesize_token(use_keyring = FALSE, token = NULL)
}
\arguments{
\item{use_keyring}{Logical, whether to also store the token securely in the system
keyring for future sessions. Defaults to FALSE.}

\item{token}{Character, optional. If provided, uses this token instead of prompting.
This parameter should only be used in non-interactive scripts.}
}
\value{
Invisibly returns TRUE if successful.
}
\description{
Securely prompts for and stores the Synthesize Bio API token in the
environment. This function uses getPass to securely handle the token input without
displaying it in the console. The token is stored in the SYNTHESIZE_API_KEY
environment variable for the current R session.
}
\examples{
# Interactive prompt for token
\dontrun{
set_synthesize_token()

# Provide token directly (less secure, not recommended for interactive use)
set_synthesize_token(token = "your-token-here")

# Store in system keyring for future sessions
set_synthesize_token(use_keyring = TRUE)
}
}
