% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-handlers.R
\name{log_cpm}
\alias{log_cpm}
\title{Log CPM Transformation}
\usage{
log_cpm(expression)
}
\arguments{
\item{expression}{A data.frame containing raw counts expression data.}
}
\value{
A data.frame containing log1p(CPM) transformed data.
}
\description{
Transforms raw counts expression data into log1p(CPM) (Counts Per Million).
This is a common normalization method for gene expression data that accounts for
library size differences and applies a log transformation to reduce the effect of outliers.
}
\examples{
# Create a sample expression matrix with raw counts
raw_counts <- data.frame(
  gene1 = c(100, 200, 300),
  gene2 = c(50, 100, 150),
  gene3 = c(10, 20, 30)
)

# Transform to log CPM
log_cpm_data <- log_cpm(raw_counts)
print(log_cpm_data)
}
