% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cg_floor_actions.R
\name{floor_actions}
\alias{floor_actions}
\alias{cg_floor_actions_recent}
\alias{cg_floor_actions_date}
\title{floor actions methods}
\usage{
cg_floor_actions_recent(congress, chamber, key = NULL, as = "table", ...)

cg_floor_actions_date(chamber, year, month, day, key = NULL, as = "table",
  ...)
}
\arguments{
\item{congress}{(character) The number of the Congress this update
took place during.}

\item{chamber}{(character) The chamber this update took place in. 'house'
or 'senate'.}

\item{key}{your ProPublica API key; pass in or loads from environment variable
stored as \code{PROPUBLICA_API_KEY} in either your .Renviron, or similar file
locatd in your home directory}

\item{as}{(character) IGNORED FOR NOW}

\item{...}{optional curl options passed on to \link[crul:HttpClient]{crul::HttpClient}.
See \code{\link[curl:curl_options]{curl::curl_options()}}}

\item{year}{(integer) year of the form YYYY}

\item{month}{(integer) month of the form MM}

\item{day}{(integer) day of the form DD}
}
\value{
various things for now, since return objects vary quite a bit
among the different votes routes
}
\description{
floor actions methods
}
\examples{
\dontrun{
cg_floor_actions_recent(115, "house")
cg_floor_actions_date("senate", 2017, 5, 2)
}
}
