/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.target;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.vikamine.kernel.Describer;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.subgroup.target.SGTarget;
import org.vikamine.kernel.util.IdentityLongDescriber;

public class NumericTarget
implements SGTarget {
    private NumericAttribute mAttribute;
    private List<Attribute> mAttributeAsList;

    public NumericAttribute getNumericTargetAttribute() {
        return this.mAttribute;
    }

    protected NumericTarget() {
    }

    public NumericTarget(NumericAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("Cannot create target from null-Attribute");
        }
        this.mAttribute = attribute;
    }

    public NumericTarget(Ontology onto, String numericAttributeName) {
        if (onto == null) {
            throw new NullPointerException("Ontology must not be null!");
        }
        Attribute att = onto.getAttribute(numericAttributeName);
        if (att == null) {
            throw new NullPointerException(String.valueOf(numericAttributeName) + " is not a valid attribute ID!");
        }
        if (!att.isNumeric()) {
            throw new IllegalArgumentException(String.valueOf(numericAttributeName) + " is not a numeric attribute!");
        }
        this.mAttribute = (NumericAttribute)att;
    }

    public NumericAttribute getAttribute() {
        return this.mAttribute;
    }

    @Override
    public Collection<Attribute> getAttributes() {
        if (this.mAttributeAsList == null) {
            this.mAttributeAsList = Collections.singletonList(this.mAttribute);
        }
        return this.mAttributeAsList;
    }

    @Override
    public String getDescription() {
        return this.getDescription(new IdentityLongDescriber());
    }

    @Override
    public String getDescription(Describer er) {
        return er.createDescription(this.mAttribute);
    }

    @Override
    public String getId() {
        return "NumericTarget " + this.mAttribute.getId();
    }

    public boolean isDefined(DataRecord record) {
        return !record.isMissing(this.mAttribute);
    }

    public double getValue(DataRecord record) {
        return record.getValue(this.mAttribute);
    }

    public String toString() {
        return "T: " + this.mAttribute;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }
}

