/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.formula.operators;

import java.util.HashSet;
import java.util.Set;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.formula.EvaluationData;
import org.vikamine.kernel.formula.FormulaBooleanElement;
import org.vikamine.kernel.formula.constants.FormulaAttributePrimitive;
import org.vikamine.kernel.formula.constants.FormulaAttributeValuePrimitive;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MatchingAttributeValue
implements FormulaBooleanElement {
    protected FormulaAttributePrimitive arg1 = null;
    protected FormulaAttributeValuePrimitive arg2 = null;

    @Override
    public Element createDOMNode(Document doc) {
        Element elem = doc.createElement("formula");
        elem.setAttribute("symbol", this.getSymbol());
        elem.setAttribute("attributeValue", "true");
        if (this.getArg1() != null) {
            Element arg1Node = this.getArg1().createDOMNode(doc);
            arg1Node.setAttribute("argIndex", "1");
            elem.appendChild(arg1Node);
        }
        if (this.getArg2() != null) {
            Element arg2Node = this.getArg2().createDOMNode(doc);
            arg2Node.setAttribute("argIndex", "2");
            elem.appendChild(arg2Node);
        }
        return elem;
    }

    @Override
    public synchronized Boolean eval(EvaluationData data) {
        if (!this.validArguments()) {
            return null;
        }
        DataRecord instance = data.getInstance();
        return this.getArg2().getValue().isValueContainedInInstance(instance);
    }

    public boolean validArguments() {
        if (this.getArg1() == null || this.getArg2() == null || this.getArg2().getValue() == null) {
            return false;
        }
        return this.getArg2().getValue().getAttribute().equals(this.getArg1().getAttribute());
    }

    public FormulaAttributePrimitive getArg1() {
        if (this.arg1 == null) {
            return new FormulaAttributePrimitive();
        }
        return this.arg1;
    }

    public FormulaAttributeValuePrimitive getArg2() {
        if (this.arg2 == null) {
            return new FormulaAttributeValuePrimitive(null);
        }
        return this.arg2;
    }

    @Override
    public Set getAttributes() {
        HashSet set1 = this.getArg1().getAttributes();
        Set set2 = this.getArg2().getAttributes();
        HashSet result = set1;
        if (!(result instanceof HashSet)) {
            result = new HashSet(set1);
        }
        result.addAll(set2);
        return result;
    }

    public String getSymbol() {
        return "=";
    }

    public void setArg1(FormulaAttributePrimitive arg1) {
        this.arg1 = arg1;
    }

    public void setArg2(FormulaAttributeValuePrimitive arg2) {
        this.arg2 = arg2;
    }

    public String toString() {
        return "(" + (this.getArg1() != null ? this.getArg1().toString() : "") + " " + this.getSymbol() + " " + (this.getArg2() != null ? this.getArg2().toString() : "") + ")";
    }

    public boolean equals(Object other) {
        return this.isEqual(other);
    }

    @Override
    public boolean isEqual(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        MatchingAttributeValue mav = (MatchingAttributeValue)other;
        return this.getArg1().equals(mav.getArg1()) && this.getArg2().equals(mav.getArg2());
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    @Override
    public int computeHashCode() {
        return this.getArg1().hashCode() + this.getArg2().hashCode();
    }
}

