/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.data.discretization.EqualFreqDiscretizer;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelectorGenerator;
import org.vikamine.kernel.subgroup.target.SGTarget;

public class OntologyUtils {
    public static List<SG> buildSGsFromDescription(Collection<SGDescription> descriptions, SGTarget target, DataView pop) {
        ArrayList<SG> result = new ArrayList<SG>();
        for (SGDescription descr : descriptions) {
            SG sg = new SG(pop, target, descr);
            sg.createStatistics();
            result.add(sg);
        }
        return result;
    }

    public static List<SGDescription> createSGDescriptionsFromSelectors(List<SGSelector> selectors) {
        ArrayList<SGDescription> result = new ArrayList<SGDescription>();
        for (SGSelector descr : selectors) {
            result.add(new SGDescription(Collections.singletonList(descr)));
        }
        return result;
    }

    public static List<SG> createSingleFactorSGs(Ontology ontology, SGTarget target, int maxValueCount, boolean includeNumeric) {
        if (ontology != null) {
            return OntologyUtils.buildSGsFromDescription(OntologyUtils.createSingleFactorSGDescriptions(ontology, maxValueCount, includeNumeric), target, ontology.getDataView());
        }
        return Collections.EMPTY_LIST;
    }

    public static List<SG> createSingleFactorSGs(Ontology ontology, SGTarget target, int maxValueCount, boolean includeNumeric, int maxSGCount) {
        if (ontology != null) {
            ArrayList<SG> result = new ArrayList<SG>();
            List<SGDescription> descriptions = OntologyUtils.createSingleFactorSGDescriptions(ontology, maxValueCount, includeNumeric);
            for (SGDescription descr : descriptions) {
                if (target != null && target.getAttributes().contains(descr.getSelectors().get(0).getAttribute())) continue;
                SG sg = new SG(ontology.getDataView(), target, descr);
                sg.createStatistics();
                result.add(sg);
                if (result.size() >= maxSGCount) break;
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public static List<SGDescription> createSingleFactorSGDescriptions(Ontology ontology, int maxValueCount, boolean includeNumeric) {
        ArrayList<SGDescription> result = new ArrayList<SGDescription>();
        if (ontology == null) {
            return result;
        }
        LinkedHashSet<Attribute> allAttributesWithoutID = ontology.getAttributes();
        allAttributesWithoutID.remove(ontology.getIDAttribute());
        for (Attribute att : allAttributesWithoutID) {
            if (att.isNominal()) {
                if (((NominalAttribute)att).getValuesCount() > maxValueCount) continue;
                for (Value v : (NominalAttribute)att) {
                    SGDescription sgDescr = new SGDescription();
                    sgDescr.add(new DefaultSGSelector(att, v));
                    result.add(sgDescr);
                }
                continue;
            }
            if (!att.isNumeric() || !includeNumeric) continue;
            NumericAttribute numAtt = (NumericAttribute)att;
            EqualFreqDiscretizer discMethod = new EqualFreqDiscretizer(ontology.getDataView(), numAtt, 5);
            Collection<SGSelector> selectors = new SGSelectorGenerator.SimpleNumericSelectorGenerator(discMethod).getSelectors(numAtt, ontology.getDataView());
            for (SGSelector sel : selectors) {
                SGDescription sgDescr = new SGDescription();
                sgDescr.add(sel);
                result.add(sgDescr);
            }
        }
        return result;
    }

    public static List<SG> createSingleFactorSGs(Ontology onto, Iterable<Attribute> attributes, SGTarget target, int maxValueCount, boolean includeNumeric) {
        if (onto != null) {
            return OntologyUtils.buildSGsFromDescription(OntologyUtils.createSingleFactorSGDescriptions(onto, attributes, maxValueCount, includeNumeric), target, onto.getDataView());
        }
        return Collections.EMPTY_LIST;
    }

    public static List<SGDescription> createSingleFactorSGDescriptions(Ontology onto, Iterable<Attribute> attributes, int maxValueCount, boolean includeNumeric) {
        if (onto == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<SGDescription> result = new ArrayList<SGDescription>();
        for (Attribute att : attributes) {
            if (att.isNominal()) {
                if (((NominalAttribute)att).getValuesCount() > maxValueCount) continue;
                for (Value v : (NominalAttribute)att) {
                    SGDescription sgDescr = new SGDescription();
                    sgDescr.add(new DefaultSGSelector(att, v));
                    result.add(sgDescr);
                }
                continue;
            }
            if (!att.isNumeric() || !includeNumeric) continue;
            NumericAttribute numAtt = (NumericAttribute)att;
            EqualFreqDiscretizer discMethod = new EqualFreqDiscretizer(onto.getDataView(), numAtt, 5);
            Collection<SGSelector> selectors = new SGSelectorGenerator.SimpleNumericSelectorGenerator(discMethod).getSelectors(numAtt, onto.getDataView());
            for (SGSelector sel : selectors) {
                SGDescription sgDescr = new SGDescription();
                sgDescr.add(sel);
                result.add(sgDescr);
            }
        }
        return result;
    }

    public static List<SGDescription> createSGDescriptionsForAttribute(Ontology onto, Attribute att) {
        ArrayList<SGDescription> result;
        block3: {
            block2: {
                result = new ArrayList<SGDescription>();
                if (!att.isNominal()) break block2;
                for (Value v : (NominalAttribute)att) {
                    SGDescription sgDescr = new SGDescription();
                    sgDescr.add(new DefaultSGSelector(att, v));
                    result.add(sgDescr);
                }
                break block3;
            }
            if (!att.isNumeric()) break block3;
            NumericAttribute numAtt = (NumericAttribute)att;
            EqualFreqDiscretizer discMethod = new EqualFreqDiscretizer(onto.getDataView(), numAtt, 5);
            Collection<SGSelector> selectors = new SGSelectorGenerator.SimpleNumericSelectorGenerator(discMethod).getSelectors(numAtt, onto.getDataView());
            for (SGSelector sel : selectors) {
                SGDescription sgDescr = new SGDescription();
                sgDescr.add(sel);
                result.add(sgDescr);
            }
        }
        return result;
    }
}

