% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_triangle.R
\name{replace_triangle}
\alias{replace_triangle}
\alias{replace_upper_triangle}
\alias{replace_lower_triangle}
\title{Replace Lower and Upper Triangular Part of a Matrix}
\usage{
replace_triangle(x, triangle = c("lower", "upper"), by = "",
  diagonal = FALSE)

replace_upper_triangle(x, by = "", diagonal = FALSE)

replace_lower_triangle(x, by = "", diagonal = FALSE)
}
\arguments{
\item{x}{a (correlation) matrix}

\item{triangle}{the triangle to replace. Allowed values are one of
"upper" and "lower".}

\item{by}{a replacement argument. Appropriate values are either "" or NA. Used to replace
the upper, lower or the diagonal part of the matrix.}

\item{diagonal}{logical. Default is FALSE. If TRUE, the matrix diagonal is
included.}
}
\value{
an object of class \code{cor_mat_tri}, which is a data frame
}
\description{
Replace the lower or the upper triangular part of a
  (correlation) matrix.
}
\section{Functions}{
\itemize{
\item \code{replace_triangle}: replaces the specified triangle by empty or NA.

\item \code{replace_upper_triangle}: replaces the upper triangular part of a matrix.
Returns an object of class \code{lower_tri}.

\item \code{replace_lower_triangle}: replaces the lower triangular part of a matrix.
Returns an object of class \code{lower_tri}
}}

\examples{
# Compute correlation matrix and pull triangles
#::::::::::::::::::::::::::::::::::::::::::
# Correlation matrix
 cor.mat <- mtcars \%>\%
   select(mpg, disp, hp, drat, wt, qsec) \%>\%
   cor_mat()
 cor.mat

 # Replace upper triangle by NA
#::::::::::::::::::::::::::::::::::::::::::
cor.mat \%>\% replace_upper_triangle(by = NA)


# Replace upper triangle by NA and reshape the
# correlation matrix to have unique combinations of variables
#::::::::::::::::::::::::::::::::::::::::::
cor.mat \%>\%
  replace_upper_triangle(by = NA) \%>\%
  cor_gather()
}
\seealso{
\code{\link{pull_triangle}()}
}
