% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stap_termination.R
\name{stap_termination}
\alias{stap_termination}
\alias{stap_termination.stapreg}
\title{Spatial-Temporal Exposure Termination-Maximization Estimates}
\usage{
stap_termination(object, prob = 0.9, exposure_limit = 0.05,
  pars = NULL, regex_pars = NULL, max_value = NULL, ...)

\method{stap_termination}{stapreg}(object, prob = 0.9,
  exposure_limit = 0.05, pars = NULL, regex_pars = NULL,
  max_value = NULL, ...)
}
\arguments{
\item{object}{A fitted model object returned by one of the 
\pkg{rstap} modeling functions. See \code{\link{stapreg-objects}}.}

\item{prob}{A number \eqn{p \in (0,1)}{p (0 < p < 1)} indicating the desired
probability mass to include in the intervals. The default is to report
\eqn{90}\% intervals (\code{prob=0.9}) rather than the traditionally used
\eqn{95}\% (see Details).}

\item{exposure_limit}{A number indicating the desired
amount of exposure for which the function will return an estimate of
 distance/time. 
 Note that the exposure_limit corresponds to spatial exposure and 1-temporal exposure.}

\item{pars}{An optional character vector of parameter names.}

\item{regex_pars}{An optional character vector of \link[=grep]{regular 
expressions} to use for parameter selection. \code{regex_pars} can be used
in place of \code{pars} or in addition to \code{pars}. Currently, all
functions that accept a \code{regex_pars} argument ignore it for models fit
using optimization.}

\item{max_value}{by defuault the max_distance and/or time from the model's original input
will be used to calculate the upper bound of possible terminating 
distances/times - the max_value can be used to specify a new value for this value.}

\item{...}{Currently ignored.}
}
\value{
A matrix with two columns and as many rows as model parameters (or
  the subset of parameters specified by \code{pars} and/or
  \code{regex_pars}). For a given value of \code{prob}, \eqn{p}, the columns
  correspond to the lower and upper \eqn{100p}\% interval limits and have the
  names \eqn{100\alpha/2}\% and \eqn{100(1 - \alpha/2)}\%, where \eqn{\alpha
  = 1-p}. For example, if \code{prob=0.9} is specified (a \eqn{90}\%
  interval), then the column names will be \code{"5\%"} and \code{"95\%"},
  respectively.
}
\description{
Spatial-Temporal Exposure Termination-Maximization Estimates
}
\examples{
\dontrun{
fit_glm <- stap_glm(formula = y ~ sex + sap(Fast_Food),
                   subject_data = homog_subject_data,
                     distance_data = homog_distance_data,
                     family = gaussian(link = 'identity'),
                     subject_ID = 'subj_id',
                     prior = normal(location = 0, scale = 5, autoscale = F),
                     prior_intercept = normal(location = 25, scale = 5, autoscale = F),
                     prior_stap = normal(location = 0, scale = 3, autoscale = F),
                     prior_theta = log_normal(location = 1, scale = 1),
                     prior_aux = cauchy(location = 0,scale = 5),
                     max_distance = max(homog_distance_data$Distance),
                     chains = CHAINS, iter = ITER,
                     refresh = -1,verbose = F)
terminal_points <- stap_termination(fit_glm, prob = .9, exposure_limit = 0.01)
}
\dontrun{
fit_glm <- stap_glm(formula = y ~ sex + sap(Fast_Food),
                   subject_data = homog_subject_data,
                     distance_data = homog_distance_data,
                     family = gaussian(link = 'identity'),
                     subject_ID = 'subj_id',
                     prior = normal(location = 0, scale = 5, autoscale = F),
                     prior_intercept = normal(location = 25, scale = 5, autoscale = F),
                     prior_stap = normal(location = 0, scale = 3, autoscale = F),
                     prior_theta = log_normal(location = 1, scale = 1),
                     prior_aux = cauchy(location = 0,scale = 5),
                     max_distance = max(homog_distance_data$Distance),
                     chains = CHAINS, iter = ITER,
                     refresh = -1,verbose = F)
terminal_vals <- stap_termination(fit_glm, prob = .9, exposure_limit = 0.01)
}

}
