% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-QR.R
\name{QR-argument}
\alias{QR-argument}
\title{The \code{QR} argument}
\description{
Details about the \code{QR} argument to \pkg{rstanarm}'s modeling
functions.
}
\details{
The \code{QR} argument is a logical scalar defaulting to
  \code{FALSE}, but if \code{TRUE} applies a scaled \code{\link{qr}}
  decomposition to the design matrix, \eqn{X = Q^\ast R^\ast}{X = Q* R*}. 
  If \code{autoscale = TRUE} (the default) 
  in the call to the function passed to the \code{prior} argument, then
  \eqn{Q^\ast = Q \sqrt{n-1}}{Q* = Q (n-1)^0.5} and 
  \eqn{R^\ast = \frac{1}{\sqrt{n-1}} R}{R* = (n-1)^(-0.5) R}. When 
  \code{autoscale = FALSE}, \eqn{R} is scaled such that the lower-right
  element of \eqn{R^\ast}{R*} is \eqn{1}.
  
  The coefficients relative to \eqn{Q^\ast}{Q*} are obtained and then 
  premultiplied by the inverse of \eqn{R^{\ast}}{R*} to obtain coefficients 
  relative to the original predictors, \eqn{X}. Thus, when 
  \code{autoscale = FALSE}, the coefficient on the last column of \eqn{X} 
  is the same as the coefficient on the last column of \eqn{Q^\ast}{Q*}.
  
  These transformations do not change the likelihood of the data but are 
  recommended for computational reasons when there are multiple predictors. 
  Importantly, while the columns of \eqn{X} are almost generally correlated, 
  the columns of \eqn{Q^\ast}{Q*} are uncorrelated by design, which often makes 
  sampling from the posterior easier. However, because when \code{QR} is 
  \code{TRUE} the \code{prior} argument applies to the coefficients relative to 
  \eqn{Q^\ast}{Q*} (and those are not very interpretable), setting \code{QR=TRUE} 
  is only recommended if you do not have an informative prior for the regression
  coefficients or if the only informative prior is on the last regression
  coefficient (in which case you should set \code{autoscale = FALSE} when
  specifying such priors). 
  
  For more details see the Stan case study 
  \emph{The QR Decomposition For Regression Models} at 
  \url{http://mc-stan.org/users/documentation/case-studies/qr_regression.html}.
}
\references{
Stan Development Team. (2017). \emph{Stan Modeling Language Users Guide and
Reference Manual.} \url{http://mc-stan.org/documentation/}
}
