% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive_error.R
\name{predictive_error.stanreg}
\alias{predictive_error}
\alias{predictive_error.ppd}
\alias{predictive_error.stanreg}
\title{In-sample or out-of-sample predictive errors}
\usage{
\method{predictive_error}{stanreg}(object, newdata = NULL, draws = NULL,
  re.form = NULL, seed = NULL, offset = NULL, ...)

\method{predictive_error}{ppd}(object, y, ...)
}
\arguments{
\item{object}{Either a fitted model object returned by one of the 
\pkg{rstanarm} modeling functions (a \link[=stanreg-objects]{stanreg 
object}) or, for the \code{"ppd"} method, a matrix of draws from the 
posterior predictive distribution returned by 
\code{\link{posterior_predict}}.}

\item{newdata, draws, seed, offset, re.form}{Optional arguments passed to 
\code{\link{posterior_predict}}. For binomial models, please see the
\strong{Note} section below if \code{newdata} will be specified.}

\item{...}{Currently ignored.}

\item{y}{For the \code{"ppd"} method only, a vector of \eqn{y} values the 
same length as the number of columns in the matrix used as \code{object}. 
The method for stanreg objects takes \code{y} directly from the fitted 
model object.}
}
\value{
A \code{draws} by \code{nrow(newdata)} matrix. If \code{newdata} is 
  not specified then it will be \code{draws} by \code{nobs(object)}.
}
\description{
This is a convenience function for computing \eqn{y - y^{rep}}{y - yrep} 
(in-sample, for observed \eqn{y}) or \eqn{y - \tilde{y}}{y - ytilde} 
(out-of-sample, for new or held-out \eqn{y}). The method for stanreg objects 
calls \code{\link{posterior_predict}} internally, whereas the method for
objects with class \code{"ppd"} accepts the matrix returned by 
\code{posterior_predict} as input and can be used to avoid multiple calls to 
\code{posterior_predict}.
}
\note{
The \strong{Note} section in \code{\link{posterior_predict}} about 
  \code{newdata} for binomial models also applies for
  \code{predictive_error}, with one important difference. For
  \code{posterior_predict} if the left-hand side of the model formula is 
  \code{cbind(successes, failures)} then the particular values of 
  \code{successes} and \code{failures} in \code{newdata} don't matter, only 
  that they add to the desired number of trials. \strong{This is not the case
  for} \code{predictive_error}. For \code{predictive_error} the particular
  value of \code{successes} matters because it is used as \eqn{y} when
  computing the error.
}
\examples{
if (!exists("example_model")) example(example_model)
err1 <- predictive_error(example_model, draws = 50)
hist(err1)

# Using newdata with a binomial model
formula(example_model)
nd <- data.frame(
 size = c(10, 20), 
 incidence = c(5, 10), 
 period = factor(c(1,2)), 
 herd = c(1, 15)
)
err2 <- predictive_error(example_model, newdata = nd, draws = 10, seed = 1234)

# stanreg vs ppd methods
fit <- stan_glm(mpg ~ wt, data = mtcars, iter = 300)
preds <- posterior_predict(fit, seed = 123)
all.equal(
  predictive_error(fit, seed = 123),
  predictive_error(preds, y = fit$y)
)

}
\seealso{
\code{\link[=posterior_predict.stanreg]{posterior_predict}} to draw
  from the posterior predictive distribution without computing predictive
  errors.
}

