% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.matrix.stanreg.R
\name{as.matrix.stanreg}
\alias{as.array.stanreg}
\alias{as.data.frame.stanreg}
\alias{as.matrix.stanreg}
\title{Extract the posterior sample}
\usage{
\method{as.matrix}{stanreg}(x, ..., pars = NULL, regex_pars = NULL)

\method{as.array}{stanreg}(x, ..., pars = NULL, regex_pars = NULL)

\method{as.data.frame}{stanreg}(x, ..., pars = NULL, regex_pars = NULL)
}
\arguments{
\item{x}{A fitted model object returned by one of the
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{...}{Ignored.}

\item{pars}{An optional character vector of parameter names.}

\item{regex_pars}{An optional character vector of \link[=grep]{regular 
expressions} to use for parameter selection. \code{regex_pars} can be used
in place of \code{pars} or in addition to \code{pars}. Currently, all
functions that accept a \code{regex_pars} argument ignore it for models fit
using optimization.}
}
\value{
A matrix, data.frame, or array, the dimensions of which depend on
  \code{pars} and \code{regex_pars}, as well as the model and estimation
  algorithm (see the Description section above).
}
\description{
For models fit using MCMC (\code{algorithm="sampling"}), the posterior sample
---the post-warmup draws from the posterior distribution--- can be extracted 
from a fitted model object as a matrix, data frame, or array. The 
\code{as.matrix} and \code{as.data.frame} methods merge all chains together, 
whereas the \code{as.array} method keeps the chains separate. For models fit 
using optimization (\code{"optimizing"}) or variational inference 
(\code{"meanfield"} or \code{"fullrank"}), there is no posterior sample but 
rather a matrix (or data frame) of 1000 draws from either the asymptotic
multivariate Gaussian sampling distribution of the parameters or the
variational approximation to the posterior distribution.
}
\examples{
\donttest{
if (!exists("example_model")) example(example_model)
# Extract posterior sample after MCMC
draws <- as.matrix(example_model)
print(dim(draws))

# For example, we can see that the median of the draws for the intercept 
# is the same as the point estimate rstanarm uses
print(median(draws[, "(Intercept)"]))
print(example_model$coefficients[["(Intercept)"]])

# The as.array method keeps the chains separate
draws_array <- as.array(example_model)
print(dim(draws_array)) # iterations x chains x parameters

# Extract draws from asymptotic Gaussian sampling distribution 
# after optimization
fit <- stan_glm(mpg ~ wt, data = mtcars, algorithm = "optimizing")
draws <- as.data.frame(fit)
print(colnames(draws))
print(nrow(draws)) # 1000 draws are taken

# Extract draws from variational approximation to the posterior distribution
fit2 <- update(fit, algorithm = "meanfield")
draws <- as.data.frame(fit2, pars = "wt")
print(colnames(draws))
print(nrow(draws)) # 1000 draws are taken
}

}
\seealso{
\code{\link{stanreg-methods}}
}

