% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecg.R
\name{detect_rpeaks}
\alias{detect_rpeaks}
\title{Detects R peaks in raw ECG signal.}
\usage{
detect_rpeaks(signal, sRate, lowcut = 0, highcut = 15,
  filter_order = 1, integration_window = 15, refractory = 200)
}
\arguments{
\item{signal}{Numerical vector of ECG signal.}

\item{sRate}{ECG signal sample rate.}

\item{lowcut}{Butterworth bandpass filter low cut value.}

\item{highcut}{Butterworth bandpass filter high cut value.}

\item{filter_order}{Butterworth bandpass filter order value.}

\item{integration_window}{Convolution window size.}

\item{refractory}{Minimal space between peaks in milliseconds.}
}
\value{
A vector of each detected R peaks in seconds from the start.
}
\description{
Implements the first part of the Pan & Tompkins algorithms to detect R peaks from a raw ECG signal. Inspiration from https://zenodo.org/record/826614.
}
\examples{
data("example_ecg_200hz")
detect_rpeaks(example_ecg_200hz, 200)
}
\references{
Pan, Jiapu, and Willis J. Tompkins. "A real-time QRS detection algorithm." IEEE Trans. Biomed. Eng 32, no. 3 (1985): 230-236.
}
