## ----setup, include = FALSE-------------------------------------------------------------------------------------------------------------------------
options(width = 150)
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.align = "center", fig.height = 6, fig.width = 6,
  out.width = "66.66%"
)

## ----packages---------------------------------------------------------------------------------------------------------------------------------------
library(rsimsum)
library(ggplot2)

## ----data-1-----------------------------------------------------------------------------------------------------------------------------------------
data("relhaz", package = "rsimsum")

## ----inspect-1--------------------------------------------------------------------------------------------------------------------------------------
str(relhaz)
head(relhaz, n = 15)

## ----summarise-1------------------------------------------------------------------------------------------------------------------------------------
s1 <- simsum(data = relhaz, estvarname = "theta", se = "se", true = -0.50, methodvar = "model", by = c("n", "baseline"), x = TRUE)
s1

## ----summary-summarise-1----------------------------------------------------------------------------------------------------------------------------
summary(s1)

## ----pattern-1--------------------------------------------------------------------------------------------------------------------------------------
pattern(s1)

## ----lolly-bias-1-----------------------------------------------------------------------------------------------------------------------------------
lolly(s1, sstat = "bias", by = c("n", "baseline"))

## ----lolly-coverage-1-------------------------------------------------------------------------------------------------------------------------------
lolly(s1, sstat = "cover", by = c("n", "baseline"))

## ----zip-1------------------------------------------------------------------------------------------------------------------------------------------
zip(s1)

## ----heat-bias-1------------------------------------------------------------------------------------------------------------------------------------
heat(s1, sstat = "bias", y = "baseline")

## ----heat-bias-coloured-1---------------------------------------------------------------------------------------------------------------------------
heat(s1, sstat = "bias", y = "baseline", gpars = list(target.colour = "green", low.colour = "yellow", high.colour = "purple"))

## ----heat-bias-text-1-------------------------------------------------------------------------------------------------------------------------------
heat(s1, sstat = "bias", y = "baseline", text = TRUE)

## ----data-2-----------------------------------------------------------------------------------------------------------------------------------------
data("frailty", package = "rsimsum")

## ----inspect-2--------------------------------------------------------------------------------------------------------------------------------------
str(frailty)
head(frailty, n = 15)

## ----estimands-2------------------------------------------------------------------------------------------------------------------------------------
unique(frailty[["par"]])

## ----summarise-2------------------------------------------------------------------------------------------------------------------------------------
s2 <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50, fv = 0.75), estvarname = "b", se = "se", methodvar = "model", by = "fv_dist", x = TRUE)
s2

## ----summary-summarise-2----------------------------------------------------------------------------------------------------------------------------
summary(s2)

## ----pattern-single-2-------------------------------------------------------------------------------------------------------------------------------
pattern(s2, par = "trt")

## ----pattern-multiple-2-----------------------------------------------------------------------------------------------------------------------------
pattern(s2)

## ----lolly-bias-2-----------------------------------------------------------------------------------------------------------------------------------
lolly(s2, sstat = "bias", par = "trt", by = "fv_dist")

## ----lolly-coverage-2-------------------------------------------------------------------------------------------------------------------------------
lolly(s2, sstat = "cover", par = "fv", by = "fv_dist")

## ----zip-2------------------------------------------------------------------------------------------------------------------------------------------
zip(s2, par = "fv")

## ----heat-cover-2-----------------------------------------------------------------------------------------------------------------------------------
heat(s2, par = "fv", sstat = "cover", y = "fv_dist")

## ----heat-cover-text-2------------------------------------------------------------------------------------------------------------------------------
heat(s2, par = "fv", sstat = "cover", y = "fv_dist", text = TRUE)

## ----add-geom---------------------------------------------------------------------------------------------------------------------------------------
pattern(s1) +
  geom_smooth()

## ----add-theme--------------------------------------------------------------------------------------------------------------------------------------
heat(s1, sstat = "bias", y = "baseline") +
  theme_bw()

## ----add-scale--------------------------------------------------------------------------------------------------------------------------------------
heat(s1, sstat = "bias", y = "baseline") +
  scale_fill_gradientn(colours = rainbow(n = 3))

