/* automatically generated by rust-bindgen */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align> {
    storage: Storage,
    align: [Align; 0],
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const __MINGW64_VERSION_MAJOR: u32 = 10;
pub const __MINGW64_VERSION_MINOR: u32 = 0;
pub const __MINGW64_VERSION_BUGFIX: u32 = 0;
pub const __MINGW64_VERSION_RC: u32 = 0;
pub const __MINGW64_VERSION_STATE: &'static [u8; 6usize] = b"alpha\0";
pub const __MINGW32_MAJOR_VERSION: u32 = 3;
pub const __MINGW32_MINOR_VERSION: u32 = 11;
pub const _M_AMD64: u32 = 100;
pub const _M_X64: u32 = 100;
pub const __: u32 = 1;
pub const __MINGW_USE_UNDERSCORE_PREFIX: u32 = 0;
pub const __MINGW_HAVE_ANSI_C99_PRINTF: u32 = 1;
pub const __MINGW_HAVE_WIDE_C99_PRINTF: u32 = 1;
pub const __MINGW_HAVE_ANSI_C99_SCANF: u32 = 1;
pub const __MINGW_HAVE_WIDE_C99_SCANF: u32 = 1;
pub const __MINGW_SEC_WARN_STR : & 'static [u8 ; 92usize] = b"This function or variable may be unsafe, use _CRT_SECURE_NO_WARNINGS to disable deprecation\0" ;
pub const __MINGW_MSVC2005_DEPREC_STR : & 'static [u8 ; 117usize] = b"This POSIX function is deprecated beginning in Visual C++ 2005, use _CRT_NONSTDC_NO_DEPRECATE to disable deprecation\0" ;
pub const __MINGW_FORTIFY_LEVEL: u32 = 0;
pub const __MINGW_FORTIFY_VA_ARG: u32 = 0;
pub const _CRT_SECURE_CPP_OVERLOAD_SECURE_NAMES: u32 = 0;
pub const _CRT_SECURE_CPP_OVERLOAD_SECURE_NAMES_MEMORY: u32 = 0;
pub const _CRT_SECURE_CPP_OVERLOAD_STANDARD_NAMES: u32 = 0;
pub const _CRT_SECURE_CPP_OVERLOAD_STANDARD_NAMES_COUNT: u32 = 0;
pub const _CRT_SECURE_CPP_OVERLOAD_STANDARD_NAMES_MEMORY: u32 = 0;
pub const __USE_CRTIMP: u32 = 1;
pub const USE___UUIDOF: u32 = 0;
pub const __CRT__NO_INLINE: u32 = 1;
pub const __MSVCRT_VERSION__: u32 = 1792;
pub const _WIN32_WINNT: u32 = 1537;
pub const MINGW_HAS_SECURE_API: u32 = 1;
pub const __STDC_SECURE_LIB__: u32 = 200411;
pub const __GOT_SECURE_LIB__: u32 = 200411;
pub const MINGW_HAS_DDK_H: u32 = 1;
pub const _CRT_PACKING: u32 = 8;
pub const _SECURECRT_FILL_BUFFER_PATTERN: u32 = 253;
pub const _ARGMAX: u32 = 100;
pub const __USE_MINGW_ANSI_STDIO: u32 = 1;
pub const _CRT_INTERNAL_PRINTF_LEGACY_VSPRINTF_NULL_TERMINATION: u32 = 1;
pub const _CRT_INTERNAL_PRINTF_STANDARD_SNPRINTF_BEHAVIOR: u32 = 2;
pub const _CRT_INTERNAL_PRINTF_LEGACY_WIDE_SPECIFIERS: u32 = 4;
pub const _CRT_INTERNAL_PRINTF_LEGACY_MSVCRT_COMPATIBILITY: u32 = 8;
pub const _CRT_INTERNAL_PRINTF_LEGACY_THREE_DIGIT_EXPONENTS: u32 = 16;
pub const _CRT_INTERNAL_SCANF_SECURECRT: u32 = 1;
pub const _CRT_INTERNAL_SCANF_LEGACY_WIDE_SPECIFIERS: u32 = 2;
pub const _CRT_INTERNAL_SCANF_LEGACY_MSVCRT_COMPATIBILITY: u32 = 4;
pub const _CRT_INTERNAL_LOCAL_PRINTF_OPTIONS: u32 = 4;
pub const _CRT_INTERNAL_LOCAL_SCANF_OPTIONS: u32 = 2;
pub const BUFSIZ: u32 = 512;
pub const _NSTREAM_: u32 = 512;
pub const _IOB_ENTRIES: u32 = 20;
pub const EOF: i32 = -1;
pub const _P_tmpdir: &'static [u8; 2usize] = b"\\\0";
pub const _wP_tmpdir: &'static [u8; 2usize] = b"\\\0";
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const SEEK_SET: u32 = 0;
pub const STDIN_FILENO: u32 = 0;
pub const STDOUT_FILENO: u32 = 1;
pub const STDERR_FILENO: u32 = 2;
pub const FILENAME_MAX: u32 = 260;
pub const FOPEN_MAX: u32 = 20;
pub const _SYS_OPEN: u32 = 20;
pub const TMP_MAX: u32 = 32767;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 64;
pub const _IONBF: u32 = 4;
pub const _IOREAD: u32 = 1;
pub const _IOWRT: u32 = 2;
pub const _IOMYBUF: u32 = 8;
pub const _IOEOF: u32 = 16;
pub const _IOERR: u32 = 32;
pub const _IOSTRG: u32 = 64;
pub const _IORW: u32 = 128;
pub const _TWO_DIGIT_EXPONENT: u32 = 1;
pub const P_tmpdir: &'static [u8; 2usize] = b"\\\0";
pub const SYS_OPEN: u32 = 20;
pub const _P_WAIT: u32 = 0;
pub const _P_NOWAIT: u32 = 1;
pub const _OLD_P_OVERLAY: u32 = 2;
pub const _P_NOWAITO: u32 = 3;
pub const _P_DETACH: u32 = 4;
pub const _P_OVERLAY: u32 = 2;
pub const _WAIT_CHILD: u32 = 0;
pub const _WAIT_GRANDCHILD: u32 = 1;
pub const TMP_MAX_S: u32 = 32767;
pub const PATH_MAX: u32 = 260;
pub const CHAR_BIT: u32 = 8;
pub const SCHAR_MIN: i32 = -128;
pub const SCHAR_MAX: u32 = 127;
pub const UCHAR_MAX: u32 = 255;
pub const CHAR_MIN: i32 = -128;
pub const CHAR_MAX: u32 = 127;
pub const MB_LEN_MAX: u32 = 5;
pub const SHRT_MIN: i32 = -32768;
pub const SHRT_MAX: u32 = 32767;
pub const USHRT_MAX: u32 = 65535;
pub const INT_MIN: i32 = -2147483648;
pub const INT_MAX: u32 = 2147483647;
pub const UINT_MAX: u32 = 4294967295;
pub const LONG_MIN: i32 = -2147483648;
pub const LONG_MAX: u32 = 2147483647;
pub const ULONG_MAX: u32 = 4294967295;
pub const LLONG_MAX: u64 = 9223372036854775807;
pub const LLONG_MIN: i64 = -9223372036854775808;
pub const ULLONG_MAX: i32 = -1;
pub const _I8_MIN: i32 = -128;
pub const _I8_MAX: u32 = 127;
pub const _UI8_MAX: u32 = 255;
pub const _I16_MIN: i32 = -32768;
pub const _I16_MAX: u32 = 32767;
pub const _UI16_MAX: u32 = 65535;
pub const _I32_MIN: i32 = -2147483648;
pub const _I32_MAX: u32 = 2147483647;
pub const _UI32_MAX: u32 = 4294967295;
pub const LONG_LONG_MAX: u64 = 9223372036854775807;
pub const LONG_LONG_MIN: i64 = -9223372036854775808;
pub const ULONG_LONG_MAX: i32 = -1;
pub const _I64_MIN: i64 = -9223372036854775808;
pub const _I64_MAX: u64 = 9223372036854775807;
pub const _UI64_MAX: i32 = -1;
pub const SIZE_MAX: i32 = -1;
pub const SSIZE_MAX: u64 = 9223372036854775807;
pub const _DOMAIN: u32 = 1;
pub const _SING: u32 = 2;
pub const _OVERFLOW: u32 = 3;
pub const _UNDERFLOW: u32 = 4;
pub const _TLOSS: u32 = 5;
pub const _PLOSS: u32 = 6;
pub const DOMAIN: u32 = 1;
pub const SING: u32 = 2;
pub const OVERFLOW: u32 = 3;
pub const UNDERFLOW: u32 = 4;
pub const TLOSS: u32 = 5;
pub const PLOSS: u32 = 6;
pub const M_E: f64 = 2.718281828459045;
pub const M_LOG2E: f64 = 1.4426950408889634;
pub const M_LOG10E: f64 = 0.4342944819032518;
pub const M_LN2: f64 = 0.6931471805599453;
pub const M_LN10: f64 = 2.302585092994046;
pub const M_PI: f64 = 3.141592653589793;
pub const M_PI_2: f64 = 1.5707963267948966;
pub const M_PI_4: f64 = 0.7853981633974483;
pub const M_1_PI: f64 = 0.3183098861837907;
pub const M_2_PI: f64 = 0.6366197723675814;
pub const M_2_SQRTPI: f64 = 1.1283791670955126;
pub const M_SQRT2: f64 = 1.4142135623730951;
pub const M_SQRT1_2: f64 = 0.7071067811865476;
pub const __MINGW_FPCLASS_DEFINED: u32 = 1;
pub const _FPCLASS_SNAN: u32 = 1;
pub const _FPCLASS_QNAN: u32 = 2;
pub const _FPCLASS_NINF: u32 = 4;
pub const _FPCLASS_NN: u32 = 8;
pub const _FPCLASS_ND: u32 = 16;
pub const _FPCLASS_NZ: u32 = 32;
pub const _FPCLASS_PZ: u32 = 64;
pub const _FPCLASS_PD: u32 = 128;
pub const _FPCLASS_PN: u32 = 256;
pub const _FPCLASS_PINF: u32 = 512;
pub const EDOM: u32 = 33;
pub const ERANGE: u32 = 34;
pub const FP_SNAN: u32 = 1;
pub const FP_QNAN: u32 = 2;
pub const FP_NINF: u32 = 4;
pub const FP_PINF: u32 = 512;
pub const FP_NDENORM: u32 = 16;
pub const FP_PDENORM: u32 = 128;
pub const FP_NZERO: u32 = 32;
pub const FP_PZERO: u32 = 64;
pub const FP_NNORM: u32 = 8;
pub const FP_PNORM: u32 = 256;
pub const SINGLESXP: u32 = 302;
pub const R_LEN_T_MAX: u32 = 2147483647;
pub const HAVE_F77_UNDERSCORE: u32 = 1;
pub const IEEE_754: u32 = 1;
pub const SUPPORT_UTF8: u32 = 1;
pub const SUPPORT_MBCS: u32 = 1;
pub const ENABLE_NLS: u32 = 1;
pub const SIZEOF_SIZE_T: u32 = 8;
pub const HAVE_UINTPTR_T: u32 = 1;
pub const R_XLEN_T_MAX: u64 = 4503599627370496;
pub const R_SHORT_LEN_MAX: u32 = 2147483647;
pub const R_INTERNALS_UUID: &'static [u8; 37usize] = b"2fdf6c18-697a-4ba7-b8ef-11c0d92f1327\0";
pub const NILSXP: u32 = 0;
pub const SYMSXP: u32 = 1;
pub const LISTSXP: u32 = 2;
pub const CLOSXP: u32 = 3;
pub const ENVSXP: u32 = 4;
pub const PROMSXP: u32 = 5;
pub const LANGSXP: u32 = 6;
pub const SPECIALSXP: u32 = 7;
pub const BUILTINSXP: u32 = 8;
pub const CHARSXP: u32 = 9;
pub const LGLSXP: u32 = 10;
pub const INTSXP: u32 = 13;
pub const REALSXP: u32 = 14;
pub const CPLXSXP: u32 = 15;
pub const STRSXP: u32 = 16;
pub const DOTSXP: u32 = 17;
pub const ANYSXP: u32 = 18;
pub const VECSXP: u32 = 19;
pub const EXPRSXP: u32 = 20;
pub const BCODESXP: u32 = 21;
pub const EXTPTRSXP: u32 = 22;
pub const WEAKREFSXP: u32 = 23;
pub const RAWSXP: u32 = 24;
pub const S4SXP: u32 = 25;
pub const NEWSXP: u32 = 30;
pub const FREESXP: u32 = 31;
pub const FUNSXP: u32 = 99;
pub const TYPE_BITS: u32 = 5;
pub const MAX_NUM_SEXPTYPE: u32 = 32;
pub const NAMEDMAX: u32 = 7;
pub const R_XDR_DOUBLE_SIZE: u32 = 8;
pub const R_XDR_INTEGER_SIZE: u32 = 4;
pub const R_CODESET_MAX: u32 = 63;
pub const R_VERSION: u32 = 262149;
pub const R_NICK: &'static [u8; 16usize] = b"Shake and Throw\0";
pub const R_MAJOR: &'static [u8; 2usize] = b"4\0";
pub const R_MINOR: &'static [u8; 4usize] = b"0.5\0";
pub const R_STATUS: &'static [u8; 1usize] = b"\0";
pub const R_YEAR: &'static [u8; 5usize] = b"2021\0";
pub const R_MONTH: &'static [u8; 3usize] = b"03\0";
pub const R_DAY: &'static [u8; 3usize] = b"31\0";
pub const R_SVN_REVISION: u32 = 80133;
pub const R_GE_version: u32 = 12;
pub const MAX_GRAPHICS_SYSTEMS: u32 = 24;
pub const R_USE_PROTOTYPES: u32 = 1;
pub const leftButton: u32 = 1;
pub const middleButton: u32 = 2;
pub const rightButton: u32 = 4;
pub const LTY_BLANK: i32 = -1;
pub const LTY_SOLID: u32 = 0;
pub const LTY_DASHED: u32 = 68;
pub const LTY_DOTTED: u32 = 49;
pub const LTY_DOTDASH: u32 = 13361;
pub const LTY_LONGDASH: u32 = 55;
pub const LTY_TWODASH: u32 = 9762;
pub const DEG2RAD: f64 = 0.017453292519943295;
pub type size_t = ::std::os::raw::c_ulonglong;
pub type wchar_t = ::std::os::raw::c_ushort;
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
#[test]
fn bindgen_test_layout_max_align_t() {
    assert_eq!(
        ::std::mem::size_of::<max_align_t>(),
        32usize,
        concat!("Size of: ", stringify!(max_align_t))
    );
    assert_eq!(
        ::std::mem::align_of::<max_align_t>(),
        16usize,
        concat!("Alignment of ", stringify!(max_align_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<max_align_t>())).__clang_max_align_nonce1 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<max_align_t>())).__clang_max_align_nonce2 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce2)
        )
    );
}
#[doc = " <div rustbindgen replaces=\"R_xlen_t\"></div>"]
pub type R_xlen_t = isize;
pub type __gnuc_va_list = __builtin_va_list;
pub type va_list = __gnuc_va_list;
extern "C" {
    pub fn __debugbreak();
}
extern "C" {
    pub fn __mingw_get_crt_info() -> *const ::std::os::raw::c_char;
}
pub type ssize_t = ::std::os::raw::c_longlong;
pub type rsize_t = size_t;
pub type wint_t = ::std::os::raw::c_ushort;
pub type wctype_t = ::std::os::raw::c_ushort;
pub type errno_t = ::std::os::raw::c_int;
pub type __time32_t = ::std::os::raw::c_long;
pub type __time64_t = ::std::os::raw::c_longlong;
pub type time_t = __time64_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct threadmbcinfostruct {
    _unused: [u8; 0],
}
pub type pthreadlocinfo = *mut threadlocaleinfostruct;
pub type pthreadmbcinfo = *mut threadmbcinfostruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __lc_time_data {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct localeinfo_struct {
    pub locinfo: pthreadlocinfo,
    pub mbcinfo: pthreadmbcinfo,
}
#[test]
fn bindgen_test_layout_localeinfo_struct() {
    assert_eq!(
        ::std::mem::size_of::<localeinfo_struct>(),
        16usize,
        concat!("Size of: ", stringify!(localeinfo_struct))
    );
    assert_eq!(
        ::std::mem::align_of::<localeinfo_struct>(),
        8usize,
        concat!("Alignment of ", stringify!(localeinfo_struct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<localeinfo_struct>())).locinfo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(localeinfo_struct),
            "::",
            stringify!(locinfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<localeinfo_struct>())).mbcinfo as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(localeinfo_struct),
            "::",
            stringify!(mbcinfo)
        )
    );
}
pub type _locale_tstruct = localeinfo_struct;
pub type _locale_t = *mut localeinfo_struct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct tagLC_ID {
    pub wLanguage: ::std::os::raw::c_ushort,
    pub wCountry: ::std::os::raw::c_ushort,
    pub wCodePage: ::std::os::raw::c_ushort,
}
#[test]
fn bindgen_test_layout_tagLC_ID() {
    assert_eq!(
        ::std::mem::size_of::<tagLC_ID>(),
        6usize,
        concat!("Size of: ", stringify!(tagLC_ID))
    );
    assert_eq!(
        ::std::mem::align_of::<tagLC_ID>(),
        2usize,
        concat!("Alignment of ", stringify!(tagLC_ID))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tagLC_ID>())).wLanguage as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(tagLC_ID),
            "::",
            stringify!(wLanguage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tagLC_ID>())).wCountry as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(tagLC_ID),
            "::",
            stringify!(wCountry)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<tagLC_ID>())).wCodePage as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(tagLC_ID),
            "::",
            stringify!(wCodePage)
        )
    );
}
pub type LC_ID = tagLC_ID;
pub type LPLC_ID = *mut tagLC_ID;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct threadlocaleinfostruct {
    pub refcount: ::std::os::raw::c_int,
    pub lc_codepage: ::std::os::raw::c_uint,
    pub lc_collate_cp: ::std::os::raw::c_uint,
    pub lc_handle: [::std::os::raw::c_ulong; 6usize],
    pub lc_id: [LC_ID; 6usize],
    pub lc_category: [threadlocaleinfostruct__bindgen_ty_1; 6usize],
    pub lc_clike: ::std::os::raw::c_int,
    pub mb_cur_max: ::std::os::raw::c_int,
    pub lconv_intl_refcount: *mut ::std::os::raw::c_int,
    pub lconv_num_refcount: *mut ::std::os::raw::c_int,
    pub lconv_mon_refcount: *mut ::std::os::raw::c_int,
    pub lconv: *mut lconv,
    pub ctype1_refcount: *mut ::std::os::raw::c_int,
    pub ctype1: *mut ::std::os::raw::c_ushort,
    pub pctype: *const ::std::os::raw::c_ushort,
    pub pclmap: *const ::std::os::raw::c_uchar,
    pub pcumap: *const ::std::os::raw::c_uchar,
    pub lc_time_curr: *mut __lc_time_data,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct threadlocaleinfostruct__bindgen_ty_1 {
    pub locale: *mut ::std::os::raw::c_char,
    pub wlocale: *mut wchar_t,
    pub refcount: *mut ::std::os::raw::c_int,
    pub wrefcount: *mut ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_threadlocaleinfostruct__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<threadlocaleinfostruct__bindgen_ty_1>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(threadlocaleinfostruct__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<threadlocaleinfostruct__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(threadlocaleinfostruct__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<threadlocaleinfostruct__bindgen_ty_1>())).locale as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct__bindgen_ty_1),
            "::",
            stringify!(locale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<threadlocaleinfostruct__bindgen_ty_1>())).wlocale as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct__bindgen_ty_1),
            "::",
            stringify!(wlocale)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<threadlocaleinfostruct__bindgen_ty_1>())).refcount as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct__bindgen_ty_1),
            "::",
            stringify!(refcount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<threadlocaleinfostruct__bindgen_ty_1>())).wrefcount as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct__bindgen_ty_1),
            "::",
            stringify!(wrefcount)
        )
    );
}
#[test]
fn bindgen_test_layout_threadlocaleinfostruct() {
    assert_eq!(
        ::std::mem::size_of::<threadlocaleinfostruct>(),
        352usize,
        concat!("Size of: ", stringify!(threadlocaleinfostruct))
    );
    assert_eq!(
        ::std::mem::align_of::<threadlocaleinfostruct>(),
        8usize,
        concat!("Alignment of ", stringify!(threadlocaleinfostruct))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<threadlocaleinfostruct>())).refcount as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(refcount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<threadlocaleinfostruct>())).lc_codepage as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(lc_codepage)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<threadlocaleinfostruct>())).lc_collate_cp as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(lc_collate_cp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<threadlocaleinfostruct>())).lc_handle as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(lc_handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<threadlocaleinfostruct>())).lc_id as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(lc_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<threadlocaleinfostruct>())).lc_category as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(lc_category)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<threadlocaleinfostruct>())).lc_clike as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(lc_clike)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<threadlocaleinfostruct>())).mb_cur_max as *const _ as usize
        },
        268usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(mb_cur_max)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<threadlocaleinfostruct>())).lconv_intl_refcount as *const _
                as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(lconv_intl_refcount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<threadlocaleinfostruct>())).lconv_num_refcount as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(lconv_num_refcount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<threadlocaleinfostruct>())).lconv_mon_refcount as *const _
                as usize
        },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(lconv_mon_refcount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<threadlocaleinfostruct>())).lconv as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(lconv)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<threadlocaleinfostruct>())).ctype1_refcount as *const _ as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(ctype1_refcount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<threadlocaleinfostruct>())).ctype1 as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(ctype1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<threadlocaleinfostruct>())).pctype as *const _ as usize },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(pctype)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<threadlocaleinfostruct>())).pclmap as *const _ as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(pclmap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<threadlocaleinfostruct>())).pcumap as *const _ as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(pcumap)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<threadlocaleinfostruct>())).lc_time_curr as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(threadlocaleinfostruct),
            "::",
            stringify!(lc_time_curr)
        )
    );
}
pub type threadlocinfo = threadlocaleinfostruct;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _iobuf {
    pub _ptr: *mut ::std::os::raw::c_char,
    pub _cnt: ::std::os::raw::c_int,
    pub _base: *mut ::std::os::raw::c_char,
    pub _flag: ::std::os::raw::c_int,
    pub _file: ::std::os::raw::c_int,
    pub _charbuf: ::std::os::raw::c_int,
    pub _bufsiz: ::std::os::raw::c_int,
    pub _tmpfname: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__iobuf() {
    assert_eq!(
        ::std::mem::size_of::<_iobuf>(),
        48usize,
        concat!("Size of: ", stringify!(_iobuf))
    );
    assert_eq!(
        ::std::mem::align_of::<_iobuf>(),
        8usize,
        concat!("Alignment of ", stringify!(_iobuf))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iobuf>()))._ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_iobuf),
            "::",
            stringify!(_ptr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iobuf>()))._cnt as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_iobuf),
            "::",
            stringify!(_cnt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iobuf>()))._base as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_iobuf),
            "::",
            stringify!(_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iobuf>()))._flag as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_iobuf),
            "::",
            stringify!(_flag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iobuf>()))._file as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_iobuf),
            "::",
            stringify!(_file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iobuf>()))._charbuf as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_iobuf),
            "::",
            stringify!(_charbuf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iobuf>()))._bufsiz as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(_iobuf),
            "::",
            stringify!(_bufsiz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iobuf>()))._tmpfname as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_iobuf),
            "::",
            stringify!(_tmpfname)
        )
    );
}
pub type FILE = _iobuf;
pub type _off_t = ::std::os::raw::c_long;
pub type off32_t = ::std::os::raw::c_long;
pub type _off64_t = ::std::os::raw::c_longlong;
pub type off64_t = ::std::os::raw::c_longlong;
pub type off_t = off32_t;
extern "C" {
    pub fn __acrt_iob_func(index: ::std::os::raw::c_uint) -> *mut FILE;
}
extern "C" {
    pub fn __iob_func() -> *mut FILE;
}
pub type fpos_t = ::std::os::raw::c_longlong;
extern "C" {
    pub fn __mingw_sscanf(
        _Src: *const ::std::os::raw::c_char,
        _Format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_vsscanf(
        _Str: *const ::std::os::raw::c_char,
        Format: *const ::std::os::raw::c_char,
        argp: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_scanf(_Format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_vscanf(
        Format: *const ::std::os::raw::c_char,
        argp: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_fscanf(
        _File: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_vfscanf(
        fp: *mut FILE,
        Format: *const ::std::os::raw::c_char,
        argp: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_vsnprintf(
        _DstBuf: *mut ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_snprintf(
        s: *mut ::std::os::raw::c_char,
        n: size_t,
        format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_printf(arg1: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_vprintf(
        arg1: *const ::std::os::raw::c_char,
        arg2: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_fprintf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_vfprintf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_sprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_vsprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_asprintf(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_vasprintf(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_sscanf(
        _Src: *const ::std::os::raw::c_char,
        _Format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_scanf(_Format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_fscanf(
        _File: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_printf(arg1: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_vprintf(
        arg1: *const ::std::os::raw::c_char,
        arg2: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_fprintf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_vfprintf(
        arg1: *mut FILE,
        arg2: *const ::std::os::raw::c_char,
        arg3: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_sprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_vsprintf(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _filbuf(_File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _flsbuf(_Ch: ::std::os::raw::c_int, _File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fsopen(
        _Filename: *const ::std::os::raw::c_char,
        _Mode: *const ::std::os::raw::c_char,
        _ShFlag: ::std::os::raw::c_int,
    ) -> *mut FILE;
}
extern "C" {
    pub fn clearerr(_File: *mut FILE);
}
extern "C" {
    pub fn fclose(_File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fcloseall() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fdopen(
        _FileHandle: ::std::os::raw::c_int,
        _Mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn feof(_File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror(_File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush(_File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc(_File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fgetchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetpos(_File: *mut FILE, _Pos: *mut fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetpos64(_File: *mut FILE, _Pos: *mut fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgets(
        _Buf: *mut ::std::os::raw::c_char,
        _MaxCount: ::std::os::raw::c_int,
        _File: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn _fileno(_File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _tempnam(
        _DirName: *const ::std::os::raw::c_char,
        _FilePrefix: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn _flushall() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fopen(
        _Filename: *const ::std::os::raw::c_char,
        _Mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fopen64(
        filename: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fputc(_Ch: ::std::os::raw::c_int, _File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fputchar(_Ch: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputs(_Str: *const ::std::os::raw::c_char, _File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread(
        _DstBuf: *mut ::std::os::raw::c_void,
        _ElementSize: ::std::os::raw::c_ulonglong,
        _Count: ::std::os::raw::c_ulonglong,
        _File: *mut FILE,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn freopen(
        _Filename: *const ::std::os::raw::c_char,
        _Mode: *const ::std::os::raw::c_char,
        _File: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fsetpos(_File: *mut FILE, _Pos: *const fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetpos64(_File: *mut FILE, _Pos: *const fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fseek(
        _File: *mut FILE,
        _Offset: ::std::os::raw::c_long,
        _Origin: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftell(_File: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn _fseeki64(
        _File: *mut FILE,
        _Offset: ::std::os::raw::c_longlong,
        _Origin: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _ftelli64(_File: *mut FILE) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn fseeko64(
        stream: *mut FILE,
        offset: _off64_t,
        whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fseeko(
        stream: *mut FILE,
        offset: _off_t,
        whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftello(stream: *mut FILE) -> _off_t;
}
extern "C" {
    pub fn ftello64(stream: *mut FILE) -> _off64_t;
}
extern "C" {
    pub fn fwrite(
        _Str: *const ::std::os::raw::c_void,
        _Size: ::std::os::raw::c_ulonglong,
        _Count: ::std::os::raw::c_ulonglong,
        _File: *mut FILE,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn getc(_File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _getmaxstdio() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn gets(_Buffer: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn _getw(_File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perror(_ErrMsg: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn _pclose(_File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _popen(
        _Command: *const ::std::os::raw::c_char,
        _Mode: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn putc(_Ch: ::std::os::raw::c_int, _File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar(_Ch: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn puts(_Str: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _putw(_Word: ::std::os::raw::c_int, _File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn remove(_Filename: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rename(
        _OldFilename: *const ::std::os::raw::c_char,
        _NewFilename: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _unlink(_Filename: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unlink(_Filename: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rewind(_File: *mut FILE);
}
extern "C" {
    pub fn _rmtmp() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuf(_File: *mut FILE, _Buffer: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn _setmaxstdio(_Max: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _set_output_format(_Format: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn _get_output_format() -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn setvbuf(
        _File: *mut FILE,
        _Buf: *mut ::std::os::raw::c_char,
        _Mode: ::std::os::raw::c_int,
        _Size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _scprintf(_Format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snscanf(
        _Src: *const ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vscprintf(
        _Format: *const ::std::os::raw::c_char,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
extern "C" {
    pub fn tmpnam(_Buffer: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ungetc(_Ch: ::std::os::raw::c_int, _File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snprintf(
        _Dest: *mut ::std::os::raw::c_char,
        _Count: size_t,
        _Format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vsnprintf(
        _Dest: *mut ::std::os::raw::c_char,
        _Count: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Args: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _set_printf_count_output(_Value: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _get_printf_count_output() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_swscanf(
        _Src: *const wchar_t,
        _Format: *const wchar_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_vswscanf(
        _Str: *const wchar_t,
        Format: *const wchar_t,
        argp: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_wscanf(_Format: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_vwscanf(Format: *const wchar_t, argp: va_list) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_fwscanf(_File: *mut FILE, _Format: *const wchar_t, ...)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_vfwscanf(
        fp: *mut FILE,
        Format: *const wchar_t,
        argp: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_fwprintf(
        _File: *mut FILE,
        _Format: *const wchar_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_wprintf(_Format: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_vfwprintf(
        _File: *mut FILE,
        _Format: *const wchar_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_vwprintf(_Format: *const wchar_t, _ArgList: va_list) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_snwprintf(
        s: *mut wchar_t,
        n: size_t,
        format: *const wchar_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_vsnwprintf(
        arg1: *mut wchar_t,
        arg2: size_t,
        arg3: *const wchar_t,
        arg4: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_swprintf(arg1: *mut wchar_t, arg2: *const wchar_t, ...)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_vswprintf(
        arg1: *mut wchar_t,
        arg2: *const wchar_t,
        arg3: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_swscanf(
        _Src: *const wchar_t,
        _Format: *const wchar_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_wscanf(_Format: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_fwscanf(_File: *mut FILE, _Format: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_fwprintf(_File: *mut FILE, _Format: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_wprintf(_Format: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_vfwprintf(
        _File: *mut FILE,
        _Format: *const wchar_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_vwprintf(_Format: *const wchar_t, _ArgList: va_list) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_swprintf(arg1: *mut wchar_t, arg2: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __ms_vswprintf(
        arg1: *mut wchar_t,
        arg2: *const wchar_t,
        arg3: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wfsopen(
        _Filename: *const wchar_t,
        _Mode: *const wchar_t,
        _ShFlag: ::std::os::raw::c_int,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fgetwc(_File: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn _fgetwchar() -> wint_t;
}
extern "C" {
    pub fn fputwc(_Ch: wchar_t, _File: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn _fputwchar(_Ch: wchar_t) -> wint_t;
}
extern "C" {
    pub fn getwc(_File: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn getwchar() -> wint_t;
}
extern "C" {
    pub fn putwc(_Ch: wchar_t, _File: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn putwchar(_Ch: wchar_t) -> wint_t;
}
extern "C" {
    pub fn ungetwc(_Ch: wint_t, _File: *mut FILE) -> wint_t;
}
extern "C" {
    pub fn fgetws(
        _Dst: *mut wchar_t,
        _SizeInWords: ::std::os::raw::c_int,
        _File: *mut FILE,
    ) -> *mut wchar_t;
}
extern "C" {
    pub fn fputws(_Str: *const wchar_t, _File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _getws(_String: *mut wchar_t) -> *mut wchar_t;
}
extern "C" {
    pub fn _putws(_Str: *const wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _scwprintf(_Format: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _swprintf_c(
        _DstBuf: *mut wchar_t,
        _SizeInWords: size_t,
        _Format: *const wchar_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vswprintf_c(
        _DstBuf: *mut wchar_t,
        _SizeInWords: size_t,
        _Format: *const wchar_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snwprintf(
        _Dest: *mut wchar_t,
        _Count: size_t,
        _Format: *const wchar_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vsnwprintf(
        _Dest: *mut wchar_t,
        _Count: size_t,
        _Format: *const wchar_t,
        _Args: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vscwprintf(_Format: *const wchar_t, _ArgList: va_list) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _swprintf(_Dest: *mut wchar_t, _Format: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vswprintf(
        _Dest: *mut wchar_t,
        _Format: *const wchar_t,
        _Args: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wtempnam(_Directory: *const wchar_t, _FilePrefix: *const wchar_t) -> *mut wchar_t;
}
extern "C" {
    pub fn _snwscanf(
        _Src: *const wchar_t,
        _MaxCount: size_t,
        _Format: *const wchar_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wfdopen(_FileHandle: ::std::os::raw::c_int, _Mode: *const wchar_t) -> *mut FILE;
}
extern "C" {
    pub fn _wfopen(_Filename: *const wchar_t, _Mode: *const wchar_t) -> *mut FILE;
}
extern "C" {
    pub fn _wfreopen(
        _Filename: *const wchar_t,
        _Mode: *const wchar_t,
        _OldFile: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn _wperror(_ErrMsg: *const wchar_t);
}
extern "C" {
    pub fn _wpopen(_Command: *const wchar_t, _Mode: *const wchar_t) -> *mut FILE;
}
extern "C" {
    pub fn _wremove(_Filename: *const wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wtmpnam(_Buffer: *mut wchar_t) -> *mut wchar_t;
}
extern "C" {
    pub fn _lock_file(_File: *mut FILE);
}
extern "C" {
    pub fn _unlock_file(_File: *mut FILE);
}
extern "C" {
    pub fn tempnam(
        _Directory: *const ::std::os::raw::c_char,
        _FilePrefix: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fcloseall() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fdopen(
        _FileHandle: ::std::os::raw::c_int,
        _Format: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fgetchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fileno(_File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn flushall() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputchar(_Ch: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getw(_File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putw(_Ch: ::std::os::raw::c_int, _File: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rmtmp() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_str_wide_utf8(
        wptr: *const wchar_t,
        mbptr: *mut *mut ::std::os::raw::c_char,
        buflen: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_str_utf8_wide(
        mbptr: *const ::std::os::raw::c_char,
        wptr: *mut *mut wchar_t,
        buflen: *mut size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __mingw_str_free(ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn _wspawnl(
        _Mode: ::std::os::raw::c_int,
        _Filename: *const wchar_t,
        _ArgList: *const wchar_t,
        ...
    ) -> isize;
}
extern "C" {
    pub fn _wspawnle(
        _Mode: ::std::os::raw::c_int,
        _Filename: *const wchar_t,
        _ArgList: *const wchar_t,
        ...
    ) -> isize;
}
extern "C" {
    pub fn _wspawnlp(
        _Mode: ::std::os::raw::c_int,
        _Filename: *const wchar_t,
        _ArgList: *const wchar_t,
        ...
    ) -> isize;
}
extern "C" {
    pub fn _wspawnlpe(
        _Mode: ::std::os::raw::c_int,
        _Filename: *const wchar_t,
        _ArgList: *const wchar_t,
        ...
    ) -> isize;
}
extern "C" {
    pub fn _wspawnv(
        _Mode: ::std::os::raw::c_int,
        _Filename: *const wchar_t,
        _ArgList: *const *const wchar_t,
    ) -> isize;
}
extern "C" {
    pub fn _wspawnve(
        _Mode: ::std::os::raw::c_int,
        _Filename: *const wchar_t,
        _ArgList: *const *const wchar_t,
        _Env: *const *const wchar_t,
    ) -> isize;
}
extern "C" {
    pub fn _wspawnvp(
        _Mode: ::std::os::raw::c_int,
        _Filename: *const wchar_t,
        _ArgList: *const *const wchar_t,
    ) -> isize;
}
extern "C" {
    pub fn _wspawnvpe(
        _Mode: ::std::os::raw::c_int,
        _Filename: *const wchar_t,
        _ArgList: *const *const wchar_t,
        _Env: *const *const wchar_t,
    ) -> isize;
}
extern "C" {
    pub fn _spawnv(
        _Mode: ::std::os::raw::c_int,
        _Filename: *const ::std::os::raw::c_char,
        _ArgList: *const *const ::std::os::raw::c_char,
    ) -> isize;
}
extern "C" {
    pub fn _spawnve(
        _Mode: ::std::os::raw::c_int,
        _Filename: *const ::std::os::raw::c_char,
        _ArgList: *const *const ::std::os::raw::c_char,
        _Env: *const *const ::std::os::raw::c_char,
    ) -> isize;
}
extern "C" {
    pub fn _spawnvp(
        _Mode: ::std::os::raw::c_int,
        _Filename: *const ::std::os::raw::c_char,
        _ArgList: *const *const ::std::os::raw::c_char,
    ) -> isize;
}
extern "C" {
    pub fn _spawnvpe(
        _Mode: ::std::os::raw::c_int,
        _Filename: *const ::std::os::raw::c_char,
        _ArgList: *const *const ::std::os::raw::c_char,
        _Env: *const *const ::std::os::raw::c_char,
    ) -> isize;
}
extern "C" {
    pub fn clearerr_s(_File: *mut FILE) -> errno_t;
}
extern "C" {
    pub fn fread_s(
        _DstBuf: *mut ::std::os::raw::c_void,
        _DstSize: size_t,
        _ElementSize: size_t,
        _Count: size_t,
        _File: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fprintf_s(
        _File: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fscanf_s_l(
        _File: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fscanf_s(
        _File: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn printf_s(_Format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _scanf_l(
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _scanf_s_l(
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scanf_s(_Format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snprintf_c(
        _DstBuf: *mut ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vsnprintf_c(
        _DstBuf: *mut ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fscanf_l(
        _File: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _sscanf_l(
        _Src: *const ::std::os::raw::c_char,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _sscanf_s_l(
        _Src: *const ::std::os::raw::c_char,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sscanf_s(
        _Src: *const ::std::os::raw::c_char,
        _Format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snscanf_s(
        _Src: *const ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snscanf_l(
        _Src: *const ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snscanf_s_l(
        _Src: *const ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfprintf_s(
        _File: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vprintf_s(
        _Format: *const ::std::os::raw::c_char,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsnprintf_s(
        _DstBuf: *mut ::std::os::raw::c_char,
        _DstSize: size_t,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vsnprintf_s(
        _DstBuf: *mut ::std::os::raw::c_char,
        _DstSize: size_t,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsprintf_s(
        _DstBuf: *mut ::std::os::raw::c_char,
        _Size: size_t,
        _Format: *const ::std::os::raw::c_char,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sprintf_s(
        _DstBuf: *mut ::std::os::raw::c_char,
        _DstSize: size_t,
        _Format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snprintf_s(
        _DstBuf: *mut ::std::os::raw::c_char,
        _DstSize: size_t,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fprintf_p(
        _File: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _printf_p(_Format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _sprintf_p(
        _Dst: *mut ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vfprintf_p(
        _File: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vprintf_p(
        _Format: *const ::std::os::raw::c_char,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vsprintf_p(
        _Dst: *mut ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _scprintf_p(_Format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vscprintf_p(
        _Format: *const ::std::os::raw::c_char,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _printf_l(
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _printf_p_l(
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vprintf_l(
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vprintf_p_l(
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fprintf_l(
        _File: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fprintf_p_l(
        _File: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vfprintf_l(
        _File: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vfprintf_p_l(
        _File: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _sprintf_l(
        _DstBuf: *mut ::std::os::raw::c_char,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _sprintf_p_l(
        _DstBuf: *mut ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vsprintf_l(
        _DstBuf: *mut ::std::os::raw::c_char,
        _Format: *const ::std::os::raw::c_char,
        arg1: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vsprintf_p_l(
        _DstBuf: *mut ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _scprintf_l(
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _scprintf_p_l(
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vscprintf_l(
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vscprintf_p_l(
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _printf_s_l(
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vprintf_s_l(
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fprintf_s_l(
        _File: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vfprintf_s_l(
        _File: *mut FILE,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _sprintf_s_l(
        _DstBuf: *mut ::std::os::raw::c_char,
        _DstSize: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vsprintf_s_l(
        _DstBuf: *mut ::std::os::raw::c_char,
        _DstSize: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snprintf_s_l(
        _DstBuf: *mut ::std::os::raw::c_char,
        _DstSize: size_t,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vsnprintf_s_l(
        _DstBuf: *mut ::std::os::raw::c_char,
        _DstSize: size_t,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snprintf_l(
        _DstBuf: *mut ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snprintf_c_l(
        _DstBuf: *mut ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vsnprintf_l(
        _DstBuf: *mut ::std::os::raw::c_char,
        _MaxCount: size_t,
        _Format: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vsnprintf_c_l(
        _DstBuf: *mut ::std::os::raw::c_char,
        _MaxCount: size_t,
        arg1: *const ::std::os::raw::c_char,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fopen_s(
        _File: *mut *mut FILE,
        _Filename: *const ::std::os::raw::c_char,
        _Mode: *const ::std::os::raw::c_char,
    ) -> errno_t;
}
extern "C" {
    pub fn freopen_s(
        _File: *mut *mut FILE,
        _Filename: *const ::std::os::raw::c_char,
        _Mode: *const ::std::os::raw::c_char,
        _Stream: *mut FILE,
    ) -> errno_t;
}
extern "C" {
    pub fn gets_s(arg1: *mut ::std::os::raw::c_char, arg2: rsize_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tmpnam_s(arg1: *mut ::std::os::raw::c_char, arg2: rsize_t) -> errno_t;
}
extern "C" {
    pub fn _getws_s(_Str: *mut wchar_t, _SizeInWords: size_t) -> *mut wchar_t;
}
extern "C" {
    pub fn fwprintf_s(_File: *mut FILE, _Format: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wprintf_s(_Format: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfwprintf_s(
        _File: *mut FILE,
        _Format: *const wchar_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vwprintf_s(_Format: *const wchar_t, _ArgList: va_list) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vswprintf_s(
        _Dst: *mut wchar_t,
        _SizeInWords: size_t,
        _Format: *const wchar_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn swprintf_s(
        _Dst: *mut wchar_t,
        _SizeInWords: size_t,
        _Format: *const wchar_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vsnwprintf_s(
        _DstBuf: *mut wchar_t,
        _DstSizeInWords: size_t,
        _MaxCount: size_t,
        _Format: *const wchar_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snwprintf_s(
        _DstBuf: *mut wchar_t,
        _DstSizeInWords: size_t,
        _MaxCount: size_t,
        _Format: *const wchar_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wprintf_s_l(_Format: *const wchar_t, _Locale: _locale_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vwprintf_s_l(
        _Format: *const wchar_t,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fwprintf_s_l(
        _File: *mut FILE,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vfwprintf_s_l(
        _File: *mut FILE,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _swprintf_s_l(
        _DstBuf: *mut wchar_t,
        _DstSize: size_t,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vswprintf_s_l(
        _DstBuf: *mut wchar_t,
        _DstSize: size_t,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snwprintf_s_l(
        _DstBuf: *mut wchar_t,
        _DstSize: size_t,
        _MaxCount: size_t,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vsnwprintf_s_l(
        _DstBuf: *mut wchar_t,
        _DstSize: size_t,
        _MaxCount: size_t,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fwscanf_s_l(
        _File: *mut FILE,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fwscanf_s(_File: *mut FILE, _Format: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _swscanf_s_l(
        _Src: *const wchar_t,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn swscanf_s(_Src: *const wchar_t, _Format: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snwscanf_s(
        _Src: *const wchar_t,
        _MaxCount: size_t,
        _Format: *const wchar_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snwscanf_s_l(
        _Src: *const wchar_t,
        _MaxCount: size_t,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wscanf_s_l(_Format: *const wchar_t, _Locale: _locale_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wscanf_s(_Format: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wfopen_s(
        _File: *mut *mut FILE,
        _Filename: *const wchar_t,
        _Mode: *const wchar_t,
    ) -> errno_t;
}
extern "C" {
    pub fn _wfreopen_s(
        _File: *mut *mut FILE,
        _Filename: *const wchar_t,
        _Mode: *const wchar_t,
        _OldFile: *mut FILE,
    ) -> errno_t;
}
extern "C" {
    pub fn _wtmpnam_s(_DstBuf: *mut wchar_t, _SizeInWords: size_t) -> errno_t;
}
extern "C" {
    pub fn _fwprintf_p(_File: *mut FILE, _Format: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wprintf_p(_Format: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vfwprintf_p(
        _File: *mut FILE,
        _Format: *const wchar_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vwprintf_p(_Format: *const wchar_t, _ArgList: va_list) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _swprintf_p(
        _DstBuf: *mut wchar_t,
        _MaxCount: size_t,
        _Format: *const wchar_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vswprintf_p(
        _DstBuf: *mut wchar_t,
        _MaxCount: size_t,
        _Format: *const wchar_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _scwprintf_p(_Format: *const wchar_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vscwprintf_p(_Format: *const wchar_t, _ArgList: va_list) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wprintf_l(_Format: *const wchar_t, _Locale: _locale_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wprintf_p_l(_Format: *const wchar_t, _Locale: _locale_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vwprintf_l(
        _Format: *const wchar_t,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vwprintf_p_l(
        _Format: *const wchar_t,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fwprintf_l(
        _File: *mut FILE,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fwprintf_p_l(
        _File: *mut FILE,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vfwprintf_l(
        _File: *mut FILE,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vfwprintf_p_l(
        _File: *mut FILE,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _swprintf_c_l(
        _DstBuf: *mut wchar_t,
        _MaxCount: size_t,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _swprintf_p_l(
        _DstBuf: *mut wchar_t,
        _MaxCount: size_t,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vswprintf_c_l(
        _DstBuf: *mut wchar_t,
        _MaxCount: size_t,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vswprintf_p_l(
        _DstBuf: *mut wchar_t,
        _MaxCount: size_t,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _scwprintf_l(_Format: *const wchar_t, _Locale: _locale_t, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _scwprintf_p_l(
        _Format: *const wchar_t,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vscwprintf_p_l(
        _Format: *const wchar_t,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snwprintf_l(
        _DstBuf: *mut wchar_t,
        _MaxCount: size_t,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vsnwprintf_l(
        _DstBuf: *mut wchar_t,
        _MaxCount: size_t,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __swprintf_l(
        _Dest: *mut wchar_t,
        _Format: *const wchar_t,
        _Plocinfo: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __vswprintf_l(
        _Dest: *mut wchar_t,
        _Format: *const wchar_t,
        _Plocinfo: _locale_t,
        _Args: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _vscwprintf_l(
        _Format: *const wchar_t,
        _Locale: _locale_t,
        _ArgList: va_list,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fwscanf_l(
        _File: *mut FILE,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _swscanf_l(
        _Src: *const wchar_t,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _snwscanf_l(
        _Src: *const wchar_t,
        _MaxCount: size_t,
        _Format: *const wchar_t,
        _Locale: _locale_t,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _wscanf_l(_Format: *const wchar_t, _Locale: _locale_t, ...) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mingw_dbl_type_t {
    pub x: f64,
    pub val: ::std::os::raw::c_ulonglong,
    pub lh: __mingw_dbl_type_t__bindgen_ty_1,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __mingw_dbl_type_t__bindgen_ty_1 {
    pub low: ::std::os::raw::c_uint,
    pub high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___mingw_dbl_type_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__mingw_dbl_type_t__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(__mingw_dbl_type_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__mingw_dbl_type_t__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__mingw_dbl_type_t__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__mingw_dbl_type_t__bindgen_ty_1>())).low as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mingw_dbl_type_t__bindgen_ty_1),
            "::",
            stringify!(low)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__mingw_dbl_type_t__bindgen_ty_1>())).high as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__mingw_dbl_type_t__bindgen_ty_1),
            "::",
            stringify!(high)
        )
    );
}
#[test]
fn bindgen_test_layout___mingw_dbl_type_t() {
    assert_eq!(
        ::std::mem::size_of::<__mingw_dbl_type_t>(),
        8usize,
        concat!("Size of: ", stringify!(__mingw_dbl_type_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mingw_dbl_type_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__mingw_dbl_type_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mingw_dbl_type_t>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mingw_dbl_type_t),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mingw_dbl_type_t>())).val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mingw_dbl_type_t),
            "::",
            stringify!(val)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mingw_dbl_type_t>())).lh as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mingw_dbl_type_t),
            "::",
            stringify!(lh)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mingw_flt_type_t {
    pub x: f32,
    pub val: ::std::os::raw::c_uint,
    _bindgen_union_align: u32,
}
#[test]
fn bindgen_test_layout___mingw_flt_type_t() {
    assert_eq!(
        ::std::mem::size_of::<__mingw_flt_type_t>(),
        4usize,
        concat!("Size of: ", stringify!(__mingw_flt_type_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mingw_flt_type_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__mingw_flt_type_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mingw_flt_type_t>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mingw_flt_type_t),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mingw_flt_type_t>())).val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mingw_flt_type_t),
            "::",
            stringify!(val)
        )
    );
}
#[repr(C, packed(8))]
#[derive(Copy, Clone)]
pub union __mingw_ldbl_type_t {
    pub x: u128,
    pub lh: __mingw_ldbl_type_t__bindgen_ty_1,
    _bindgen_union_align: [u64; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __mingw_ldbl_type_t__bindgen_ty_1 {
    pub low: ::std::os::raw::c_uint,
    pub high: ::std::os::raw::c_uint,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize], u32>,
}
#[test]
fn bindgen_test_layout___mingw_ldbl_type_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__mingw_ldbl_type_t__bindgen_ty_1>(),
        16usize,
        concat!("Size of: ", stringify!(__mingw_ldbl_type_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__mingw_ldbl_type_t__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__mingw_ldbl_type_t__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__mingw_ldbl_type_t__bindgen_ty_1>())).low as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mingw_ldbl_type_t__bindgen_ty_1),
            "::",
            stringify!(low)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__mingw_ldbl_type_t__bindgen_ty_1>())).high as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__mingw_ldbl_type_t__bindgen_ty_1),
            "::",
            stringify!(high)
        )
    );
}
impl __mingw_ldbl_type_t__bindgen_ty_1 {
    #[inline]
    pub fn sign_exponent(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_sign_exponent(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn res1(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_res1(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn res0(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 32u8) as u32) }
    }
    #[inline]
    pub fn set_res0(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 32u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sign_exponent: ::std::os::raw::c_int,
        res1: ::std::os::raw::c_int,
        res0: ::std::os::raw::c_int,
    ) -> __BindgenBitfieldUnit<[u8; 8usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let sign_exponent: u32 = unsafe { ::std::mem::transmute(sign_exponent) };
            sign_exponent as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let res1: u32 = unsafe { ::std::mem::transmute(res1) };
            res1 as u64
        });
        __bindgen_bitfield_unit.set(32usize, 32u8, {
            let res0: u32 = unsafe { ::std::mem::transmute(res0) };
            res0 as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout___mingw_ldbl_type_t() {
    assert_eq!(
        ::std::mem::size_of::<__mingw_ldbl_type_t>(),
        16usize,
        concat!("Size of: ", stringify!(__mingw_ldbl_type_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mingw_ldbl_type_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__mingw_ldbl_type_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mingw_ldbl_type_t>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mingw_ldbl_type_t),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mingw_ldbl_type_t>())).lh as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mingw_ldbl_type_t),
            "::",
            stringify!(lh)
        )
    );
}
extern "C" {
    pub static mut __imp__HUGE: *mut f64;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _exception {
    pub type_: ::std::os::raw::c_int,
    pub name: *const ::std::os::raw::c_char,
    pub arg1: f64,
    pub arg2: f64,
    pub retval: f64,
}
#[test]
fn bindgen_test_layout__exception() {
    assert_eq!(
        ::std::mem::size_of::<_exception>(),
        40usize,
        concat!("Size of: ", stringify!(_exception))
    );
    assert_eq!(
        ::std::mem::align_of::<_exception>(),
        8usize,
        concat!("Alignment of ", stringify!(_exception))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_exception>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_exception),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_exception>())).name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_exception),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_exception>())).arg1 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_exception),
            "::",
            stringify!(arg1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_exception>())).arg2 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_exception),
            "::",
            stringify!(arg2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_exception>())).retval as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_exception),
            "::",
            stringify!(retval)
        )
    );
}
extern "C" {
    pub fn __mingw_raise_matherr(
        typ: ::std::os::raw::c_int,
        name: *const ::std::os::raw::c_char,
        a1: f64,
        a2: f64,
        rslt: f64,
    );
}
extern "C" {
    pub fn __mingw_setusermatherr(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut _exception) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn __setusermatherr(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut _exception) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn sin(_X: f64) -> f64;
}
extern "C" {
    pub fn cos(_X: f64) -> f64;
}
extern "C" {
    pub fn tan(_X: f64) -> f64;
}
extern "C" {
    pub fn sinh(_X: f64) -> f64;
}
extern "C" {
    pub fn cosh(_X: f64) -> f64;
}
extern "C" {
    pub fn tanh(_X: f64) -> f64;
}
extern "C" {
    pub fn asin(_X: f64) -> f64;
}
extern "C" {
    pub fn acos(_X: f64) -> f64;
}
extern "C" {
    pub fn atan(_X: f64) -> f64;
}
extern "C" {
    pub fn atan2(_Y: f64, _X: f64) -> f64;
}
extern "C" {
    pub fn exp(_X: f64) -> f64;
}
extern "C" {
    pub fn log(_X: f64) -> f64;
}
extern "C" {
    pub fn log10(_X: f64) -> f64;
}
extern "C" {
    pub fn pow(_X: f64, _Y: f64) -> f64;
}
extern "C" {
    pub fn sqrt(_X: f64) -> f64;
}
extern "C" {
    pub fn ceil(_X: f64) -> f64;
}
extern "C" {
    pub fn floor(_X: f64) -> f64;
}
extern "C" {
    pub fn fabsf(x: f32) -> f32;
}
extern "C" {
    pub fn fabsl(arg1: u128) -> u128;
}
extern "C" {
    pub fn fabs(_X: f64) -> f64;
}
extern "C" {
    pub fn ldexp(_X: f64, _Y: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn frexp(_X: f64, _Y: *mut ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn modf(_X: f64, _Y: *mut f64) -> f64;
}
extern "C" {
    pub fn fmod(_X: f64, _Y: f64) -> f64;
}
extern "C" {
    pub fn sincos(__x: f64, p_sin: *mut f64, p_cos: *mut f64);
}
extern "C" {
    pub fn sincosl(__x: u128, p_sin: *mut u128, p_cos: *mut u128);
}
extern "C" {
    pub fn sincosf(__x: f32, p_sin: *mut f32, p_cos: *mut f32);
}
extern "C" {
    pub fn abs(_X: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn labs(_X: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn atof(_String: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn _atof_l(_String: *const ::std::os::raw::c_char, _Locale: _locale_t) -> f64;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _complex {
    pub x: f64,
    pub y: f64,
}
#[test]
fn bindgen_test_layout__complex() {
    assert_eq!(
        ::std::mem::size_of::<_complex>(),
        16usize,
        concat!("Size of: ", stringify!(_complex))
    );
    assert_eq!(
        ::std::mem::align_of::<_complex>(),
        8usize,
        concat!("Alignment of ", stringify!(_complex))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_complex>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_complex),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_complex>())).y as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_complex),
            "::",
            stringify!(y)
        )
    );
}
extern "C" {
    pub fn _cabs(_ComplexA: _complex) -> f64;
}
extern "C" {
    pub fn _hypot(_X: f64, _Y: f64) -> f64;
}
extern "C" {
    pub fn _j0(_X: f64) -> f64;
}
extern "C" {
    pub fn _j1(_X: f64) -> f64;
}
extern "C" {
    pub fn _jn(_X: ::std::os::raw::c_int, _Y: f64) -> f64;
}
extern "C" {
    pub fn _y0(_X: f64) -> f64;
}
extern "C" {
    pub fn _y1(_X: f64) -> f64;
}
extern "C" {
    pub fn _yn(_X: ::std::os::raw::c_int, _Y: f64) -> f64;
}
extern "C" {
    pub fn _matherr(arg1: *mut _exception) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _chgsign(_X: f64) -> f64;
}
extern "C" {
    pub fn _copysign(_Number: f64, _Sign: f64) -> f64;
}
extern "C" {
    pub fn _logb(arg1: f64) -> f64;
}
extern "C" {
    pub fn _nextafter(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn _scalb(arg1: f64, arg2: ::std::os::raw::c_long) -> f64;
}
extern "C" {
    pub fn _finite(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fpclass(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _isnan(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn j0(arg1: f64) -> f64;
}
extern "C" {
    pub fn j1(arg1: f64) -> f64;
}
extern "C" {
    pub fn jn(arg1: ::std::os::raw::c_int, arg2: f64) -> f64;
}
extern "C" {
    pub fn y0(arg1: f64) -> f64;
}
extern "C" {
    pub fn y1(arg1: f64) -> f64;
}
extern "C" {
    pub fn yn(arg1: ::std::os::raw::c_int, arg2: f64) -> f64;
}
extern "C" {
    pub fn chgsign(arg1: f64) -> f64;
}
extern "C" {
    pub fn finite(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fpclass(arg1: f64) -> ::std::os::raw::c_int;
}
pub type float_t = f32;
pub type double_t = f64;
extern "C" {
    pub fn __fpclassifyl(arg1: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __fpclassifyf(arg1: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __fpclassify(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __isnan(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __isnanf(arg1: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __isnanl(arg1: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __signbit(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __signbitf(arg1: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __signbitl(arg1: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sinf(_X: f32) -> f32;
}
extern "C" {
    pub fn sinl(arg1: u128) -> u128;
}
extern "C" {
    pub fn cosf(_X: f32) -> f32;
}
extern "C" {
    pub fn cosl(arg1: u128) -> u128;
}
extern "C" {
    pub fn tanf(_X: f32) -> f32;
}
extern "C" {
    pub fn tanl(arg1: u128) -> u128;
}
extern "C" {
    pub fn asinf(_X: f32) -> f32;
}
extern "C" {
    pub fn asinl(arg1: u128) -> u128;
}
extern "C" {
    pub fn acosf(arg1: f32) -> f32;
}
extern "C" {
    pub fn acosl(arg1: u128) -> u128;
}
extern "C" {
    pub fn atanf(arg1: f32) -> f32;
}
extern "C" {
    pub fn atanl(arg1: u128) -> u128;
}
extern "C" {
    pub fn atan2f(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn atan2l(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn sinhf(_X: f32) -> f32;
}
extern "C" {
    pub fn sinhl(arg1: u128) -> u128;
}
extern "C" {
    pub fn coshf(_X: f32) -> f32;
}
extern "C" {
    pub fn coshl(arg1: u128) -> u128;
}
extern "C" {
    pub fn tanhf(_X: f32) -> f32;
}
extern "C" {
    pub fn tanhl(arg1: u128) -> u128;
}
extern "C" {
    pub fn acosh(arg1: f64) -> f64;
}
extern "C" {
    pub fn acoshf(arg1: f32) -> f32;
}
extern "C" {
    pub fn acoshl(arg1: u128) -> u128;
}
extern "C" {
    pub fn asinh(arg1: f64) -> f64;
}
extern "C" {
    pub fn asinhf(arg1: f32) -> f32;
}
extern "C" {
    pub fn asinhl(arg1: u128) -> u128;
}
extern "C" {
    pub fn atanh(arg1: f64) -> f64;
}
extern "C" {
    pub fn atanhf(arg1: f32) -> f32;
}
extern "C" {
    pub fn atanhl(arg1: u128) -> u128;
}
extern "C" {
    pub fn expf(_X: f32) -> f32;
}
extern "C" {
    pub fn expl(arg1: u128) -> u128;
}
extern "C" {
    pub fn exp2(arg1: f64) -> f64;
}
extern "C" {
    pub fn exp2f(arg1: f32) -> f32;
}
extern "C" {
    pub fn exp2l(arg1: u128) -> u128;
}
extern "C" {
    pub fn expm1(arg1: f64) -> f64;
}
extern "C" {
    pub fn expm1f(arg1: f32) -> f32;
}
extern "C" {
    pub fn expm1l(arg1: u128) -> u128;
}
extern "C" {
    pub fn frexpf(_X: f32, _Y: *mut ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn frexpl(arg1: u128, arg2: *mut ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn ilogb(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ilogbf(arg1: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ilogbl(arg1: u128) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ldexpf(_X: f32, _Y: ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn ldexpl(arg1: u128, arg2: ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn logf(arg1: f32) -> f32;
}
extern "C" {
    pub fn logl(arg1: u128) -> u128;
}
extern "C" {
    pub fn log10f(arg1: f32) -> f32;
}
extern "C" {
    pub fn log10l(arg1: u128) -> u128;
}
extern "C" {
    pub fn log1p(arg1: f64) -> f64;
}
extern "C" {
    pub fn log1pf(arg1: f32) -> f32;
}
extern "C" {
    pub fn log1pl(arg1: u128) -> u128;
}
extern "C" {
    pub fn log2(arg1: f64) -> f64;
}
extern "C" {
    pub fn log2f(arg1: f32) -> f32;
}
extern "C" {
    pub fn log2l(arg1: u128) -> u128;
}
extern "C" {
    pub fn logb(arg1: f64) -> f64;
}
extern "C" {
    pub fn logbf(arg1: f32) -> f32;
}
extern "C" {
    pub fn logbl(arg1: u128) -> u128;
}
extern "C" {
    pub fn modff(arg1: f32, arg2: *mut f32) -> f32;
}
extern "C" {
    pub fn modfl(arg1: u128, arg2: *mut u128) -> u128;
}
extern "C" {
    pub fn scalbn(arg1: f64, arg2: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn scalbnf(arg1: f32, arg2: ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn scalbnl(arg1: u128, arg2: ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn scalbln(arg1: f64, arg2: ::std::os::raw::c_long) -> f64;
}
extern "C" {
    pub fn scalblnf(arg1: f32, arg2: ::std::os::raw::c_long) -> f32;
}
extern "C" {
    pub fn scalblnl(arg1: u128, arg2: ::std::os::raw::c_long) -> u128;
}
extern "C" {
    pub fn cbrt(arg1: f64) -> f64;
}
extern "C" {
    pub fn cbrtf(arg1: f32) -> f32;
}
extern "C" {
    pub fn cbrtl(arg1: u128) -> u128;
}
extern "C" {
    pub fn hypot(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn hypotf(x: f32, y: f32) -> f32;
}
extern "C" {
    pub fn hypotl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn powf(_X: f32, _Y: f32) -> f32;
}
extern "C" {
    pub fn powl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn sqrtf(arg1: f32) -> f32;
}
extern "C" {
    pub fn sqrtl(arg1: u128) -> u128;
}
extern "C" {
    pub fn erf(arg1: f64) -> f64;
}
extern "C" {
    pub fn erff(arg1: f32) -> f32;
}
extern "C" {
    pub fn erfl(arg1: u128) -> u128;
}
extern "C" {
    pub fn erfc(arg1: f64) -> f64;
}
extern "C" {
    pub fn erfcf(arg1: f32) -> f32;
}
extern "C" {
    pub fn erfcl(arg1: u128) -> u128;
}
extern "C" {
    pub fn lgamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn lgammaf(arg1: f32) -> f32;
}
extern "C" {
    pub fn lgammal(arg1: u128) -> u128;
}
extern "C" {
    pub static mut signgam: ::std::os::raw::c_int;
}
extern "C" {
    pub fn tgamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn tgammaf(arg1: f32) -> f32;
}
extern "C" {
    pub fn tgammal(arg1: u128) -> u128;
}
extern "C" {
    pub fn ceilf(arg1: f32) -> f32;
}
extern "C" {
    pub fn ceill(arg1: u128) -> u128;
}
extern "C" {
    pub fn floorf(arg1: f32) -> f32;
}
extern "C" {
    pub fn floorl(arg1: u128) -> u128;
}
extern "C" {
    pub fn nearbyint(arg1: f64) -> f64;
}
extern "C" {
    pub fn nearbyintf(arg1: f32) -> f32;
}
extern "C" {
    pub fn nearbyintl(arg1: u128) -> u128;
}
extern "C" {
    pub fn rint(arg1: f64) -> f64;
}
extern "C" {
    pub fn rintf(arg1: f32) -> f32;
}
extern "C" {
    pub fn rintl(arg1: u128) -> u128;
}
extern "C" {
    pub fn lrint(arg1: f64) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn lrintf(arg1: f32) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn lrintl(arg1: u128) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llrint(arg1: f64) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn llrintf(arg1: f32) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn llrintl(arg1: u128) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn round(arg1: f64) -> f64;
}
extern "C" {
    pub fn roundf(arg1: f32) -> f32;
}
extern "C" {
    pub fn roundl(arg1: u128) -> u128;
}
extern "C" {
    pub fn lround(arg1: f64) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn lroundf(arg1: f32) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn lroundl(arg1: u128) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn llround(arg1: f64) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn llroundf(arg1: f32) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn llroundl(arg1: u128) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn trunc(arg1: f64) -> f64;
}
extern "C" {
    pub fn truncf(arg1: f32) -> f32;
}
extern "C" {
    pub fn truncl(arg1: u128) -> u128;
}
extern "C" {
    pub fn fmodf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn fmodl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn remainder(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn remainderf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn remainderl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn remquo(arg1: f64, arg2: f64, arg3: *mut ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn remquof(arg1: f32, arg2: f32, arg3: *mut ::std::os::raw::c_int) -> f32;
}
extern "C" {
    pub fn remquol(arg1: u128, arg2: u128, arg3: *mut ::std::os::raw::c_int) -> u128;
}
extern "C" {
    pub fn copysign(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn copysignf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn copysignl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn nan(tagp: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn nanf(tagp: *const ::std::os::raw::c_char) -> f32;
}
extern "C" {
    pub fn nanl(tagp: *const ::std::os::raw::c_char) -> u128;
}
extern "C" {
    pub fn nextafter(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn nextafterf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn nextafterl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn nexttoward(arg1: f64, arg2: u128) -> f64;
}
extern "C" {
    pub fn nexttowardf(arg1: f32, arg2: u128) -> f32;
}
extern "C" {
    pub fn nexttowardl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn fdim(x: f64, y: f64) -> f64;
}
extern "C" {
    pub fn fdimf(x: f32, y: f32) -> f32;
}
extern "C" {
    pub fn fdiml(x: u128, y: u128) -> u128;
}
extern "C" {
    pub fn fmax(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn fmaxf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn fmaxl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn fmin(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn fminf(arg1: f32, arg2: f32) -> f32;
}
extern "C" {
    pub fn fminl(arg1: u128, arg2: u128) -> u128;
}
extern "C" {
    pub fn fma(arg1: f64, arg2: f64, arg3: f64) -> f64;
}
extern "C" {
    pub fn fmaf(arg1: f32, arg2: f32, arg3: f32) -> f32;
}
extern "C" {
    pub fn fmal(arg1: u128, arg2: u128, arg3: u128) -> u128;
}
extern "C" {
    pub fn _copysignf(_Number: f32, _Sign: f32) -> f32;
}
extern "C" {
    pub fn _chgsignf(_X: f32) -> f32;
}
extern "C" {
    pub fn _logbf(_X: f32) -> f32;
}
extern "C" {
    pub fn _nextafterf(_X: f32, _Y: f32) -> f32;
}
extern "C" {
    pub fn _finitef(_X: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _isnanf(_X: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _fpclassf(_X: f32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _chgsignl(arg1: u128) -> u128;
}
extern "C" {
    pub static mut R_NaN: f64;
}
extern "C" {
    pub static mut R_PosInf: f64;
}
extern "C" {
    pub static mut R_NegInf: f64;
}
extern "C" {
    pub static mut R_NaReal: f64;
}
extern "C" {
    pub static mut R_NaInt: ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_IsNA(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_IsNaN(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_finite(arg1: f64) -> ::std::os::raw::c_int;
}
pub const Rboolean_FALSE: Rboolean = 0;
pub const Rboolean_TRUE: Rboolean = 1;
pub type Rboolean = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Rcomplex {
    pub r: f64,
    pub i: f64,
}
#[test]
fn bindgen_test_layout_Rcomplex() {
    assert_eq!(
        ::std::mem::size_of::<Rcomplex>(),
        16usize,
        concat!("Size of: ", stringify!(Rcomplex))
    );
    assert_eq!(
        ::std::mem::align_of::<Rcomplex>(),
        8usize,
        concat!("Alignment of ", stringify!(Rcomplex))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Rcomplex>())).r as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Rcomplex),
            "::",
            stringify!(r)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Rcomplex>())).i as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Rcomplex),
            "::",
            stringify!(i)
        )
    );
}
extern "C" {
    pub fn Rf_error(arg1: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn UNIMPLEMENTED(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn WrongArgCount(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn Rf_warning(arg1: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn R_ShowMessage(s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn vmaxget() -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn vmaxset(arg1: *const ::std::os::raw::c_void);
}
extern "C" {
    pub fn R_gc();
}
extern "C" {
    pub fn R_gc_running() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_alloc(arg1: size_t, arg2: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_allocLD(nelem: size_t) -> *mut u128;
}
extern "C" {
    pub fn S_alloc(
        arg1: ::std::os::raw::c_long,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn S_realloc(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
        arg3: ::std::os::raw::c_long,
        arg4: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_malloc_gc(arg1: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn R_calloc_gc(arg1: size_t, arg2: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn R_realloc_gc(
        arg1: *mut ::std::os::raw::c_void,
        arg2: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn R_isort(arg1: *mut ::std::os::raw::c_int, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn R_rsort(arg1: *mut f64, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn R_csort(arg1: *mut Rcomplex, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn rsort_with_index(
        arg1: *mut f64,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn Rf_revsort(
        arg1: *mut f64,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn Rf_iPsort(
        arg1: *mut ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn Rf_rPsort(arg1: *mut f64, arg2: ::std::os::raw::c_int, arg3: ::std::os::raw::c_int);
}
extern "C" {
    pub fn Rf_cPsort(arg1: *mut Rcomplex, arg2: ::std::os::raw::c_int, arg3: ::std::os::raw::c_int);
}
extern "C" {
    pub fn R_qsort(v: *mut f64, i: size_t, j: size_t);
}
extern "C" {
    pub fn R_qsort_I(
        v: *mut f64,
        II: *mut ::std::os::raw::c_int,
        i: ::std::os::raw::c_int,
        j: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn R_qsort_int(iv: *mut ::std::os::raw::c_int, i: size_t, j: size_t);
}
extern "C" {
    pub fn R_qsort_int_I(
        iv: *mut ::std::os::raw::c_int,
        II: *mut ::std::os::raw::c_int,
        i: ::std::os::raw::c_int,
        j: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn R_ExpandFileName(arg1: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_setIVector(
        arg1: *mut ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn Rf_setRVector(arg1: *mut f64, arg2: ::std::os::raw::c_int, arg3: f64);
}
extern "C" {
    pub fn Rf_StringFalse(arg1: *const ::std::os::raw::c_char) -> Rboolean;
}
extern "C" {
    pub fn Rf_StringTrue(arg1: *const ::std::os::raw::c_char) -> Rboolean;
}
extern "C" {
    pub fn Rf_isBlankString(arg1: *const ::std::os::raw::c_char) -> Rboolean;
}
extern "C" {
    pub fn R_atof(str: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn R_strtod(c: *const ::std::os::raw::c_char, end: *mut *mut ::std::os::raw::c_char)
        -> f64;
}
extern "C" {
    pub fn R_tmpnam(
        prefix: *const ::std::os::raw::c_char,
        tempdir: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_tmpnam2(
        prefix: *const ::std::os::raw::c_char,
        tempdir: *const ::std::os::raw::c_char,
        fileext: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_free_tmpnam(name: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn R_CheckUserInterrupt();
}
extern "C" {
    pub fn R_CheckStack();
}
extern "C" {
    pub fn R_CheckStack2(arg1: size_t);
}
extern "C" {
    pub fn findInterval(
        xt: *mut f64,
        n: ::std::os::raw::c_int,
        x: f64,
        rightmost_closed: Rboolean,
        all_inside: Rboolean,
        ilo: ::std::os::raw::c_int,
        mflag: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn findInterval2(
        xt: *mut f64,
        n: ::std::os::raw::c_int,
        x: f64,
        rightmost_closed: Rboolean,
        all_inside: Rboolean,
        left_open: Rboolean,
        ilo: ::std::os::raw::c_int,
        mflag: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn find_interv_vec(
        xt: *mut f64,
        n: *mut ::std::os::raw::c_int,
        x: *mut f64,
        nx: *mut ::std::os::raw::c_int,
        rightmost_closed: *mut ::std::os::raw::c_int,
        all_inside: *mut ::std::os::raw::c_int,
        indx: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn R_max_col(
        matrix: *mut f64,
        nr: *mut ::std::os::raw::c_int,
        nc: *mut ::std::os::raw::c_int,
        maxes: *mut ::std::os::raw::c_int,
        ties_meth: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn Rprintf(arg1: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn REprintf(arg1: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn Rvprintf(arg1: *const ::std::os::raw::c_char, arg2: va_list);
}
extern "C" {
    pub fn REvprintf(arg1: *const ::std::os::raw::c_char, arg2: va_list);
}
pub type DL_FUNC = ::std::option::Option<unsafe extern "C" fn() -> *mut ::std::os::raw::c_void>;
pub type R_NativePrimitiveArgType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_CMethodDef {
    pub name: *const ::std::os::raw::c_char,
    pub fun: DL_FUNC,
    pub numArgs: ::std::os::raw::c_int,
    pub types: *mut R_NativePrimitiveArgType,
}
#[test]
fn bindgen_test_layout_R_CMethodDef() {
    assert_eq!(
        ::std::mem::size_of::<R_CMethodDef>(),
        32usize,
        concat!("Size of: ", stringify!(R_CMethodDef))
    );
    assert_eq!(
        ::std::mem::align_of::<R_CMethodDef>(),
        8usize,
        concat!("Alignment of ", stringify!(R_CMethodDef))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_CMethodDef>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(R_CMethodDef),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_CMethodDef>())).fun as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(R_CMethodDef),
            "::",
            stringify!(fun)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_CMethodDef>())).numArgs as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(R_CMethodDef),
            "::",
            stringify!(numArgs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_CMethodDef>())).types as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(R_CMethodDef),
            "::",
            stringify!(types)
        )
    );
}
pub type R_FortranMethodDef = R_CMethodDef;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_CallMethodDef {
    pub name: *const ::std::os::raw::c_char,
    pub fun: DL_FUNC,
    pub numArgs: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_R_CallMethodDef() {
    assert_eq!(
        ::std::mem::size_of::<R_CallMethodDef>(),
        24usize,
        concat!("Size of: ", stringify!(R_CallMethodDef))
    );
    assert_eq!(
        ::std::mem::align_of::<R_CallMethodDef>(),
        8usize,
        concat!("Alignment of ", stringify!(R_CallMethodDef))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_CallMethodDef>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(R_CallMethodDef),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_CallMethodDef>())).fun as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(R_CallMethodDef),
            "::",
            stringify!(fun)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_CallMethodDef>())).numArgs as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(R_CallMethodDef),
            "::",
            stringify!(numArgs)
        )
    );
}
pub type R_ExternalMethodDef = R_CallMethodDef;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _DllInfo {
    _unused: [u8; 0],
}
pub type DllInfo = _DllInfo;
extern "C" {
    pub fn R_registerRoutines(
        info: *mut DllInfo,
        croutines: *const R_CMethodDef,
        callRoutines: *const R_CallMethodDef,
        fortranRoutines: *const R_FortranMethodDef,
        externalRoutines: *const R_ExternalMethodDef,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_useDynamicSymbols(info: *mut DllInfo, value: Rboolean) -> Rboolean;
}
extern "C" {
    pub fn R_forceSymbols(info: *mut DllInfo, value: Rboolean) -> Rboolean;
}
extern "C" {
    pub fn R_getDllInfo(name: *const ::std::os::raw::c_char) -> *mut DllInfo;
}
extern "C" {
    pub fn R_getEmbeddingDllInfo() -> *mut DllInfo;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Rf_RegisteredNativeSymbol {
    _unused: [u8; 0],
}
pub type R_RegisteredNativeSymbol = Rf_RegisteredNativeSymbol;
pub const NativeSymbolType_R_ANY_SYM: NativeSymbolType = 0;
pub const NativeSymbolType_R_C_SYM: NativeSymbolType = 1;
pub const NativeSymbolType_R_CALL_SYM: NativeSymbolType = 2;
pub const NativeSymbolType_R_FORTRAN_SYM: NativeSymbolType = 3;
pub const NativeSymbolType_R_EXTERNAL_SYM: NativeSymbolType = 4;
pub type NativeSymbolType = u32;
extern "C" {
    pub fn R_FindSymbol(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        symbol: *mut R_RegisteredNativeSymbol,
    ) -> DL_FUNC;
}
extern "C" {
    pub fn R_RegisterCCallable(
        package: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        fptr: DL_FUNC,
    );
}
extern "C" {
    pub fn R_GetCCallable(
        package: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
    ) -> DL_FUNC;
}
pub type Rbyte = ::std::os::raw::c_uchar;
pub type R_len_t = ::std::os::raw::c_int;
pub type SEXPTYPE = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SEXPREC {
    _unused: [u8; 0],
}
pub type SEXP = *mut SEXPREC;
extern "C" {
    pub fn R_CHAR(x: SEXP) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_isNull(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isSymbol(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isLogical(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isReal(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isComplex(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isExpression(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isEnvironment(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isString(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isObject(s: SEXP) -> Rboolean;
}
pub const SORTED_DECR_NA_1ST: _bindgen_ty_1 = -2;
pub const SORTED_DECR: _bindgen_ty_1 = -1;
pub const UNKNOWN_SORTEDNESS: _bindgen_ty_1 = -2147483648;
pub const SORTED_INCR: _bindgen_ty_1 = 1;
pub const SORTED_INCR_NA_1ST: _bindgen_ty_1 = 2;
pub const KNOWN_UNSORTED: _bindgen_ty_1 = 0;
pub type _bindgen_ty_1 = i32;
extern "C" {
    pub fn ATTRIB(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn OBJECT(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn MARK(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn TYPEOF(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn NAMED(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn REFCNT(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn TRACKREFS(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_OBJECT(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_TYPEOF(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_NAMED(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_ATTRIB(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn DUPLICATE_ATTRIB(to: SEXP, from: SEXP);
}
extern "C" {
    pub fn SHALLOW_DUPLICATE_ATTRIB(to: SEXP, from: SEXP);
}
extern "C" {
    pub fn ENSURE_NAMEDMAX(x: SEXP);
}
extern "C" {
    pub fn ENSURE_NAMED(x: SEXP);
}
extern "C" {
    pub fn SETTER_CLEAR_NAMED(x: SEXP);
}
extern "C" {
    pub fn RAISE_NAMED(x: SEXP, n: ::std::os::raw::c_int);
}
extern "C" {
    pub fn DECREMENT_REFCNT(x: SEXP);
}
extern "C" {
    pub fn INCREMENT_REFCNT(x: SEXP);
}
extern "C" {
    pub fn DISABLE_REFCNT(x: SEXP);
}
extern "C" {
    pub fn ENABLE_REFCNT(x: SEXP);
}
extern "C" {
    pub fn MARK_NOT_MUTABLE(x: SEXP);
}
extern "C" {
    pub fn ASSIGNMENT_PENDING(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_ASSIGNMENT_PENDING(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn IS_ASSIGNMENT_CALL(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn MARK_ASSIGNMENT_CALL(x: SEXP);
}
extern "C" {
    pub fn IS_S4_OBJECT(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_S4_OBJECT(x: SEXP);
}
extern "C" {
    pub fn UNSET_S4_OBJECT(x: SEXP);
}
extern "C" {
    pub fn NOJIT(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn MAYBEJIT(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_NOJIT(x: SEXP);
}
extern "C" {
    pub fn SET_MAYBEJIT(x: SEXP);
}
extern "C" {
    pub fn UNSET_MAYBEJIT(x: SEXP);
}
extern "C" {
    pub fn IS_GROWABLE(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_GROWABLE_BIT(x: SEXP);
}
extern "C" {
    pub fn LENGTH(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn XLENGTH(x: SEXP) -> R_xlen_t;
}
extern "C" {
    pub fn TRUELENGTH(x: SEXP) -> R_xlen_t;
}
extern "C" {
    pub fn SETLENGTH(x: SEXP, v: R_xlen_t);
}
extern "C" {
    pub fn SET_TRUELENGTH(x: SEXP, v: R_xlen_t);
}
extern "C" {
    pub fn IS_LONG_VEC(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn LEVELS(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SETLEVELS(x: SEXP, v: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn LOGICAL(x: SEXP) -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn INTEGER(x: SEXP) -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn RAW(x: SEXP) -> *mut Rbyte;
}
extern "C" {
    pub fn REAL(x: SEXP) -> *mut f64;
}
extern "C" {
    pub fn COMPLEX(x: SEXP) -> *mut Rcomplex;
}
extern "C" {
    pub fn LOGICAL_RO(x: SEXP) -> *const ::std::os::raw::c_int;
}
extern "C" {
    pub fn INTEGER_RO(x: SEXP) -> *const ::std::os::raw::c_int;
}
extern "C" {
    pub fn RAW_RO(x: SEXP) -> *const Rbyte;
}
extern "C" {
    pub fn REAL_RO(x: SEXP) -> *const f64;
}
extern "C" {
    pub fn COMPLEX_RO(x: SEXP) -> *const Rcomplex;
}
extern "C" {
    pub fn VECTOR_ELT(x: SEXP, i: R_xlen_t) -> SEXP;
}
extern "C" {
    pub fn SET_STRING_ELT(x: SEXP, i: R_xlen_t, v: SEXP);
}
extern "C" {
    pub fn SET_VECTOR_ELT(x: SEXP, i: R_xlen_t, v: SEXP) -> SEXP;
}
extern "C" {
    pub fn STRING_PTR(x: SEXP) -> *mut SEXP;
}
extern "C" {
    pub fn STRING_PTR_RO(x: SEXP) -> *const SEXP;
}
extern "C" {
    pub fn VECTOR_PTR(x: SEXP) -> *mut SEXP;
}
extern "C" {
    pub fn STDVEC_DATAPTR(x: SEXP) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn IS_SCALAR(x: SEXP, type_: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ALTREP(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ALTREP_DUPLICATE_EX(x: SEXP, deep: Rboolean) -> SEXP;
}
extern "C" {
    pub fn ALTREP_COERCE(x: SEXP, type_: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn ALTREP_INSPECT(
        arg1: SEXP,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: SEXP,
                arg2: ::std::os::raw::c_int,
                arg3: ::std::os::raw::c_int,
                arg4: ::std::os::raw::c_int,
            ),
        >,
    ) -> Rboolean;
}
extern "C" {
    pub fn ALTREP_SERIALIZED_CLASS(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn ALTREP_SERIALIZED_STATE(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn ALTREP_UNSERIALIZE_EX(
        arg1: SEXP,
        arg2: SEXP,
        arg3: SEXP,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> SEXP;
}
extern "C" {
    pub fn ALTREP_LENGTH(x: SEXP) -> R_xlen_t;
}
extern "C" {
    pub fn ALTREP_TRUELENGTH(x: SEXP) -> R_xlen_t;
}
extern "C" {
    pub fn ALTVEC_DATAPTR(x: SEXP) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn ALTVEC_DATAPTR_RO(x: SEXP) -> *const ::std::os::raw::c_void;
}
extern "C" {
    pub fn ALTVEC_DATAPTR_OR_NULL(x: SEXP) -> *const ::std::os::raw::c_void;
}
extern "C" {
    pub fn ALTVEC_EXTRACT_SUBSET(x: SEXP, indx: SEXP, call: SEXP) -> SEXP;
}
extern "C" {
    pub fn ALTINTEGER_ELT(x: SEXP, i: R_xlen_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ALTINTEGER_SET_ELT(x: SEXP, i: R_xlen_t, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn ALTLOGICAL_ELT(x: SEXP, i: R_xlen_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ALTLOGICAL_SET_ELT(x: SEXP, i: R_xlen_t, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn ALTREAL_ELT(x: SEXP, i: R_xlen_t) -> f64;
}
extern "C" {
    pub fn ALTREAL_SET_ELT(x: SEXP, i: R_xlen_t, v: f64);
}
extern "C" {
    pub fn ALTSTRING_ELT(arg1: SEXP, arg2: R_xlen_t) -> SEXP;
}
extern "C" {
    pub fn ALTSTRING_SET_ELT(arg1: SEXP, arg2: R_xlen_t, arg3: SEXP);
}
extern "C" {
    pub fn ALTCOMPLEX_ELT(x: SEXP, i: R_xlen_t) -> Rcomplex;
}
extern "C" {
    pub fn ALTCOMPLEX_SET_ELT(x: SEXP, i: R_xlen_t, v: Rcomplex);
}
extern "C" {
    pub fn ALTRAW_ELT(x: SEXP, i: R_xlen_t) -> Rbyte;
}
extern "C" {
    pub fn ALTRAW_SET_ELT(x: SEXP, i: R_xlen_t, v: Rbyte);
}
extern "C" {
    pub fn INTEGER_GET_REGION(
        sx: SEXP,
        i: R_xlen_t,
        n: R_xlen_t,
        buf: *mut ::std::os::raw::c_int,
    ) -> R_xlen_t;
}
extern "C" {
    pub fn REAL_GET_REGION(sx: SEXP, i: R_xlen_t, n: R_xlen_t, buf: *mut f64) -> R_xlen_t;
}
extern "C" {
    pub fn LOGICAL_GET_REGION(
        sx: SEXP,
        i: R_xlen_t,
        n: R_xlen_t,
        buf: *mut ::std::os::raw::c_int,
    ) -> R_xlen_t;
}
extern "C" {
    pub fn COMPLEX_GET_REGION(sx: SEXP, i: R_xlen_t, n: R_xlen_t, buf: *mut Rcomplex) -> R_xlen_t;
}
extern "C" {
    pub fn RAW_GET_REGION(sx: SEXP, i: R_xlen_t, n: R_xlen_t, buf: *mut Rbyte) -> R_xlen_t;
}
extern "C" {
    pub fn INTEGER_IS_SORTED(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn INTEGER_NO_NA(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn REAL_IS_SORTED(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn REAL_NO_NA(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn LOGICAL_IS_SORTED(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn LOGICAL_NO_NA(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn STRING_IS_SORTED(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn STRING_NO_NA(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ALTINTEGER_SUM(x: SEXP, narm: Rboolean) -> SEXP;
}
extern "C" {
    pub fn ALTINTEGER_MIN(x: SEXP, narm: Rboolean) -> SEXP;
}
extern "C" {
    pub fn ALTINTEGER_MAX(x: SEXP, narm: Rboolean) -> SEXP;
}
extern "C" {
    pub fn INTEGER_MATCH(
        arg1: SEXP,
        arg2: SEXP,
        arg3: ::std::os::raw::c_int,
        arg4: SEXP,
        arg5: SEXP,
        arg6: Rboolean,
    ) -> SEXP;
}
extern "C" {
    pub fn INTEGER_IS_NA(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn ALTREAL_SUM(x: SEXP, narm: Rboolean) -> SEXP;
}
extern "C" {
    pub fn ALTREAL_MIN(x: SEXP, narm: Rboolean) -> SEXP;
}
extern "C" {
    pub fn ALTREAL_MAX(x: SEXP, narm: Rboolean) -> SEXP;
}
extern "C" {
    pub fn REAL_MATCH(
        arg1: SEXP,
        arg2: SEXP,
        arg3: ::std::os::raw::c_int,
        arg4: SEXP,
        arg5: SEXP,
        arg6: Rboolean,
    ) -> SEXP;
}
extern "C" {
    pub fn REAL_IS_NA(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn ALTLOGICAL_SUM(x: SEXP, narm: Rboolean) -> SEXP;
}
extern "C" {
    pub fn R_compact_intrange(n1: R_xlen_t, n2: R_xlen_t) -> SEXP;
}
extern "C" {
    pub fn R_deferred_coerceToString(v: SEXP, info: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_virtrep_vec(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_tryWrap(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_tryUnwrap(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_BadLongVector(
        arg1: SEXP,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> R_len_t;
}
extern "C" {
    pub fn BNDCELL_TAG(e: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_BNDCELL_TAG(e: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn BNDCELL_DVAL(cell: SEXP) -> f64;
}
extern "C" {
    pub fn BNDCELL_IVAL(cell: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn BNDCELL_LVAL(cell: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_BNDCELL_DVAL(cell: SEXP, v: f64);
}
extern "C" {
    pub fn SET_BNDCELL_IVAL(cell: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_BNDCELL_LVAL(cell: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn INIT_BNDCELL(cell: SEXP, type_: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_BNDCELL(cell: SEXP, val: SEXP);
}
extern "C" {
    pub fn TAG(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CAR0(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CDR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CAAR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CDAR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CADR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CDDR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CDDDR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CADDR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CADDDR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CAD4R(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn MISSING(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_MISSING(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_TAG(x: SEXP, y: SEXP);
}
extern "C" {
    pub fn SETCAR(x: SEXP, y: SEXP) -> SEXP;
}
extern "C" {
    pub fn SETCDR(x: SEXP, y: SEXP) -> SEXP;
}
extern "C" {
    pub fn SETCADR(x: SEXP, y: SEXP) -> SEXP;
}
extern "C" {
    pub fn SETCADDR(x: SEXP, y: SEXP) -> SEXP;
}
extern "C" {
    pub fn SETCADDDR(x: SEXP, y: SEXP) -> SEXP;
}
extern "C" {
    pub fn SETCAD4R(e: SEXP, y: SEXP) -> SEXP;
}
extern "C" {
    pub fn EXTPTR_PTR(arg1: SEXP) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn CONS_NR(a: SEXP, b: SEXP) -> SEXP;
}
extern "C" {
    pub fn FORMALS(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn BODY(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn CLOENV(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn RDEBUG(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn RSTEP(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn RTRACE(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_RDEBUG(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_RSTEP(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_RTRACE(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_FORMALS(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn SET_BODY(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn SET_CLOENV(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn PRINTNAME(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn SYMVALUE(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn INTERNAL(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn DDVAL(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_DDVAL(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_PRINTNAME(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn SET_SYMVALUE(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn SET_INTERNAL(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn FRAME(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn ENCLOS(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn HASHTAB(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn ENVFLAGS(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_ENVFLAGS(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_FRAME(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn SET_ENCLOS(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn SET_HASHTAB(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn PRCODE(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn PRENV(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn PRVALUE(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn PRSEEN(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_PRSEEN(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_PRENV(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn SET_PRVALUE(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn SET_PRCODE(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn HASHASH(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn HASHVALUE(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_HASHASH(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_HASHVALUE(x: SEXP, v: ::std::os::raw::c_int);
}
pub type PROTECT_INDEX = ::std::os::raw::c_int;
extern "C" {
    pub static mut R_GlobalEnv: SEXP;
}
extern "C" {
    pub static mut R_EmptyEnv: SEXP;
}
extern "C" {
    pub static mut R_BaseEnv: SEXP;
}
extern "C" {
    pub static mut R_BaseNamespace: SEXP;
}
extern "C" {
    pub static mut R_NamespaceRegistry: SEXP;
}
extern "C" {
    pub static mut R_Srcref: SEXP;
}
extern "C" {
    pub static mut R_NilValue: SEXP;
}
extern "C" {
    pub static mut R_UnboundValue: SEXP;
}
extern "C" {
    pub static mut R_MissingArg: SEXP;
}
extern "C" {
    pub static mut R_InBCInterpreter: SEXP;
}
extern "C" {
    pub static mut R_CurrentExpression: SEXP;
}
extern "C" {
    pub static mut R_RestartToken: SEXP;
}
extern "C" {
    pub static mut R_AsCharacterSymbol: SEXP;
}
extern "C" {
    pub static mut R_baseSymbol: SEXP;
}
extern "C" {
    pub static mut R_BaseSymbol: SEXP;
}
extern "C" {
    pub static mut R_BraceSymbol: SEXP;
}
extern "C" {
    pub static mut R_Bracket2Symbol: SEXP;
}
extern "C" {
    pub static mut R_BracketSymbol: SEXP;
}
extern "C" {
    pub static mut R_ClassSymbol: SEXP;
}
extern "C" {
    pub static mut R_DeviceSymbol: SEXP;
}
extern "C" {
    pub static mut R_DimNamesSymbol: SEXP;
}
extern "C" {
    pub static mut R_DimSymbol: SEXP;
}
extern "C" {
    pub static mut R_DollarSymbol: SEXP;
}
extern "C" {
    pub static mut R_DotsSymbol: SEXP;
}
extern "C" {
    pub static mut R_DoubleColonSymbol: SEXP;
}
extern "C" {
    pub static mut R_DropSymbol: SEXP;
}
extern "C" {
    pub static mut R_EvalSymbol: SEXP;
}
extern "C" {
    pub static mut R_LastvalueSymbol: SEXP;
}
extern "C" {
    pub static mut R_LevelsSymbol: SEXP;
}
extern "C" {
    pub static mut R_ModeSymbol: SEXP;
}
extern "C" {
    pub static mut R_NaRmSymbol: SEXP;
}
extern "C" {
    pub static mut R_NameSymbol: SEXP;
}
extern "C" {
    pub static mut R_NamesSymbol: SEXP;
}
extern "C" {
    pub static mut R_NamespaceEnvSymbol: SEXP;
}
extern "C" {
    pub static mut R_PackageSymbol: SEXP;
}
extern "C" {
    pub static mut R_PreviousSymbol: SEXP;
}
extern "C" {
    pub static mut R_QuoteSymbol: SEXP;
}
extern "C" {
    pub static mut R_RowNamesSymbol: SEXP;
}
extern "C" {
    pub static mut R_SeedsSymbol: SEXP;
}
extern "C" {
    pub static mut R_SortListSymbol: SEXP;
}
extern "C" {
    pub static mut R_SourceSymbol: SEXP;
}
extern "C" {
    pub static mut R_SpecSymbol: SEXP;
}
extern "C" {
    pub static mut R_TripleColonSymbol: SEXP;
}
extern "C" {
    pub static mut R_TspSymbol: SEXP;
}
extern "C" {
    pub static mut R_dot_defined: SEXP;
}
extern "C" {
    pub static mut R_dot_Method: SEXP;
}
extern "C" {
    pub static mut R_dot_packageName: SEXP;
}
extern "C" {
    pub static mut R_dot_target: SEXP;
}
extern "C" {
    pub static mut R_dot_Generic: SEXP;
}
extern "C" {
    pub static mut R_NaString: SEXP;
}
extern "C" {
    pub static mut R_BlankString: SEXP;
}
extern "C" {
    pub static mut R_BlankScalarString: SEXP;
}
extern "C" {
    pub fn R_GetCurrentSrcref(arg1: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn R_GetSrcFilename(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_asChar(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_coerceVector(arg1: SEXP, arg2: SEXPTYPE) -> SEXP;
}
extern "C" {
    pub fn Rf_PairToVectorList(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_VectorToPairList(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_asCharacterFactor(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_asLogical(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_asLogical2(
        x: SEXP,
        checking: ::std::os::raw::c_int,
        call: SEXP,
        rho: SEXP,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_asInteger(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_asReal(x: SEXP) -> f64;
}
extern "C" {
    pub fn Rf_asComplex(x: SEXP) -> Rcomplex;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_allocator {
    _unused: [u8; 0],
}
pub type R_allocator_t = R_allocator;
pub const warn_type_iSILENT: warn_type = 0;
pub const warn_type_iWARN: warn_type = 1;
pub const warn_type_iERROR: warn_type = 2;
pub type warn_type = u32;
extern "C" {
    pub fn Rf_acopy_string(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_addMissingVarsToNewEnv(arg1: SEXP, arg2: SEXP);
}
extern "C" {
    pub fn Rf_alloc3DArray(
        arg1: SEXPTYPE,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> SEXP;
}
extern "C" {
    pub fn Rf_allocArray(arg1: SEXPTYPE, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_allocFormalsList2(sym1: SEXP, sym2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_allocFormalsList3(sym1: SEXP, sym2: SEXP, sym3: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_allocFormalsList4(sym1: SEXP, sym2: SEXP, sym3: SEXP, sym4: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_allocFormalsList5(sym1: SEXP, sym2: SEXP, sym3: SEXP, sym4: SEXP, sym5: SEXP)
        -> SEXP;
}
extern "C" {
    pub fn Rf_allocFormalsList6(
        sym1: SEXP,
        sym2: SEXP,
        sym3: SEXP,
        sym4: SEXP,
        sym5: SEXP,
        sym6: SEXP,
    ) -> SEXP;
}
extern "C" {
    pub fn Rf_allocMatrix(
        arg1: SEXPTYPE,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> SEXP;
}
extern "C" {
    pub fn Rf_allocList(arg1: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn Rf_allocS4Object() -> SEXP;
}
extern "C" {
    pub fn Rf_allocSExp(arg1: SEXPTYPE) -> SEXP;
}
extern "C" {
    pub fn Rf_allocVector3(arg1: SEXPTYPE, arg2: R_xlen_t, arg3: *mut R_allocator_t) -> SEXP;
}
extern "C" {
    pub fn Rf_any_duplicated(x: SEXP, from_last: Rboolean) -> R_xlen_t;
}
extern "C" {
    pub fn Rf_any_duplicated3(x: SEXP, incomp: SEXP, from_last: Rboolean) -> R_xlen_t;
}
extern "C" {
    pub fn Rf_applyClosure(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP, arg5: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_arraySubscript(
        arg1: ::std::os::raw::c_int,
        arg2: SEXP,
        arg3: SEXP,
        arg4: ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
        arg5: ::std::option::Option<
            unsafe extern "C" fn(arg1: SEXP, arg2: ::std::os::raw::c_int) -> SEXP,
        >,
        arg6: SEXP,
    ) -> SEXP;
}
extern "C" {
    pub fn Rf_classgets(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_cons(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_fixSubset3Args(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: *mut SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_copyMatrix(arg1: SEXP, arg2: SEXP, arg3: Rboolean);
}
extern "C" {
    pub fn Rf_copyListMatrix(arg1: SEXP, arg2: SEXP, arg3: Rboolean);
}
extern "C" {
    pub fn Rf_copyMostAttrib(arg1: SEXP, arg2: SEXP);
}
extern "C" {
    pub fn Rf_copyVector(arg1: SEXP, arg2: SEXP);
}
extern "C" {
    pub fn Rf_countContexts(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_CreateTag(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_defineVar(arg1: SEXP, arg2: SEXP, arg3: SEXP);
}
extern "C" {
    pub fn Rf_dimgets(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_dimnamesgets(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_DropDims(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_duplicate(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_shallow_duplicate(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_duplicate_attr(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_shallow_duplicate_attr(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_lazy_duplicate(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_duplicated(arg1: SEXP, arg2: Rboolean) -> SEXP;
}
extern "C" {
    pub fn R_envHasNoSpecialSymbols(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_eval(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_ExtractSubset(arg1: SEXP, arg2: SEXP, arg3: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_findFun(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_findFun3(arg1: SEXP, arg2: SEXP, arg3: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_findFunctionForBody(arg1: SEXP);
}
extern "C" {
    pub fn Rf_findVar(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_findVarInFrame(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_findVarInFrame3(arg1: SEXP, arg2: SEXP, arg3: Rboolean) -> SEXP;
}
extern "C" {
    pub fn R_removeVarFromFrame(arg1: SEXP, arg2: SEXP);
}
extern "C" {
    pub fn Rf_getAttrib(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_GetArrayDimnames(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_GetColNames(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_GetMatrixDimnames(
        arg1: SEXP,
        arg2: *mut SEXP,
        arg3: *mut SEXP,
        arg4: *mut *const ::std::os::raw::c_char,
        arg5: *mut *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn Rf_GetOption(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_GetOption1(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_FixupDigits(arg1: SEXP, arg2: warn_type) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_FixupWidth(arg1: SEXP, arg2: warn_type) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_GetOptionDigits() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_GetOptionWidth() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_GetRowNames(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_gsetVar(arg1: SEXP, arg2: SEXP, arg3: SEXP);
}
extern "C" {
    pub fn Rf_install(arg1: *const ::std::os::raw::c_char) -> SEXP;
}
extern "C" {
    pub fn Rf_installChar(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_installNoTrChar(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_installTrChar(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_installDDVAL(i: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn Rf_installS3Signature(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> SEXP;
}
extern "C" {
    pub fn Rf_isFree(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isOrdered(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isUnmodifiedSpecSym(sym: SEXP, env: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isUnordered(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isUnsorted(arg1: SEXP, arg2: Rboolean) -> Rboolean;
}
extern "C" {
    pub fn Rf_lengthgets(arg1: SEXP, arg2: R_len_t) -> SEXP;
}
extern "C" {
    pub fn Rf_xlengthgets(arg1: SEXP, arg2: R_xlen_t) -> SEXP;
}
extern "C" {
    pub fn R_lsInternal(arg1: SEXP, arg2: Rboolean) -> SEXP;
}
extern "C" {
    pub fn R_lsInternal3(arg1: SEXP, arg2: Rboolean, arg3: Rboolean) -> SEXP;
}
extern "C" {
    pub fn Rf_match(arg1: SEXP, arg2: SEXP, arg3: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn Rf_matchE(arg1: SEXP, arg2: SEXP, arg3: ::std::os::raw::c_int, arg4: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_namesgets(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_mkChar(arg1: *const ::std::os::raw::c_char) -> SEXP;
}
extern "C" {
    pub fn Rf_mkCharLen(arg1: *const ::std::os::raw::c_char, arg2: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn Rf_NonNullStringMatch(arg1: SEXP, arg2: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_ncols(arg1: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_nrows(arg1: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_nthcdr(arg1: SEXP, arg2: ::std::os::raw::c_int) -> SEXP;
}
pub const nchar_type_Bytes: nchar_type = 0;
pub const nchar_type_Chars: nchar_type = 1;
pub const nchar_type_Width: nchar_type = 2;
pub type nchar_type = u32;
extern "C" {
    pub fn R_nchar(
        string: SEXP,
        type_: nchar_type,
        allowNA: Rboolean,
        keepNA: Rboolean,
        msg_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_pmatch(arg1: SEXP, arg2: SEXP, arg3: Rboolean) -> Rboolean;
}
extern "C" {
    pub fn Rf_psmatch(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: Rboolean,
    ) -> Rboolean;
}
extern "C" {
    pub fn R_ParseEvalString(arg1: *const ::std::os::raw::c_char, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_PrintValue(arg1: SEXP);
}
extern "C" {
    pub fn Rf_printwhere();
}
extern "C" {
    pub fn Rf_readS3VarsFromFrame(
        arg1: SEXP,
        arg2: *mut SEXP,
        arg3: *mut SEXP,
        arg4: *mut SEXP,
        arg5: *mut SEXP,
        arg6: *mut SEXP,
        arg7: *mut SEXP,
    );
}
extern "C" {
    pub fn Rf_setAttrib(arg1: SEXP, arg2: SEXP, arg3: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_setSVector(arg1: *mut SEXP, arg2: ::std::os::raw::c_int, arg3: SEXP);
}
extern "C" {
    pub fn Rf_setVar(arg1: SEXP, arg2: SEXP, arg3: SEXP);
}
extern "C" {
    pub fn Rf_stringSuffix(arg1: SEXP, arg2: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn Rf_str2type(arg1: *const ::std::os::raw::c_char) -> SEXPTYPE;
}
extern "C" {
    pub fn Rf_StringBlank(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_substitute(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_topenv(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_translateChar(arg1: SEXP) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_translateChar0(arg1: SEXP) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_translateCharUTF8(arg1: SEXP) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_type2char(arg1: SEXPTYPE) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_type2rstr(arg1: SEXPTYPE) -> SEXP;
}
extern "C" {
    pub fn Rf_type2str(arg1: SEXPTYPE) -> SEXP;
}
extern "C" {
    pub fn Rf_type2str_nowarn(arg1: SEXPTYPE) -> SEXP;
}
extern "C" {
    pub fn Rf_unprotect_ptr(arg1: SEXP);
}
extern "C" {
    pub fn R_signal_protect_error();
}
extern "C" {
    pub fn R_signal_unprotect_error();
}
extern "C" {
    pub fn R_signal_reprotect_error(i: PROTECT_INDEX);
}
extern "C" {
    pub fn R_tryEval(arg1: SEXP, arg2: SEXP, arg3: *mut ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn R_tryEvalSilent(arg1: SEXP, arg2: SEXP, arg3: *mut ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn R_GetCurrentEnv() -> SEXP;
}
extern "C" {
    pub fn R_curErrorBuf() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_isS4(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_asS4(arg1: SEXP, arg2: Rboolean, arg3: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn Rf_S3Class(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_isBasicClass(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_cycle_detected(s: SEXP, child: SEXP) -> Rboolean;
}
pub const cetype_t_CE_NATIVE: cetype_t = 0;
pub const cetype_t_CE_UTF8: cetype_t = 1;
pub const cetype_t_CE_LATIN1: cetype_t = 2;
pub const cetype_t_CE_BYTES: cetype_t = 3;
pub const cetype_t_CE_SYMBOL: cetype_t = 5;
pub const cetype_t_CE_ANY: cetype_t = 99;
pub type cetype_t = u32;
extern "C" {
    pub fn Rf_getCharCE(arg1: SEXP) -> cetype_t;
}
extern "C" {
    pub fn Rf_mkCharCE(arg1: *const ::std::os::raw::c_char, arg2: cetype_t) -> SEXP;
}
extern "C" {
    pub fn Rf_mkCharLenCE(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: cetype_t,
    ) -> SEXP;
}
extern "C" {
    pub fn Rf_reEnc(
        x: *const ::std::os::raw::c_char,
        ce_in: cetype_t,
        ce_out: cetype_t,
        subst: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_forceAndCall(e: SEXP, n: ::std::os::raw::c_int, rho: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_MakeExternalPtr(p: *mut ::std::os::raw::c_void, tag: SEXP, prot: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_ExternalPtrAddr(s: SEXP) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn R_ExternalPtrTag(s: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_ExternalPtrProtected(s: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_ClearExternalPtr(s: SEXP);
}
extern "C" {
    pub fn R_SetExternalPtrAddr(s: SEXP, p: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn R_SetExternalPtrTag(s: SEXP, tag: SEXP);
}
extern "C" {
    pub fn R_SetExternalPtrProtected(s: SEXP, p: SEXP);
}
extern "C" {
    pub fn R_MakeExternalPtrFn(p: DL_FUNC, tag: SEXP, prot: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_ExternalPtrAddrFn(s: SEXP) -> DL_FUNC;
}
pub type R_CFinalizer_t = ::std::option::Option<unsafe extern "C" fn(arg1: SEXP)>;
extern "C" {
    pub fn R_RegisterFinalizer(s: SEXP, fun: SEXP);
}
extern "C" {
    pub fn R_RegisterCFinalizer(s: SEXP, fun: R_CFinalizer_t);
}
extern "C" {
    pub fn R_RegisterFinalizerEx(s: SEXP, fun: SEXP, onexit: Rboolean);
}
extern "C" {
    pub fn R_RegisterCFinalizerEx(s: SEXP, fun: R_CFinalizer_t, onexit: Rboolean);
}
extern "C" {
    pub fn R_RunPendingFinalizers();
}
extern "C" {
    pub fn R_MakeWeakRef(key: SEXP, val: SEXP, fin: SEXP, onexit: Rboolean) -> SEXP;
}
extern "C" {
    pub fn R_MakeWeakRefC(key: SEXP, val: SEXP, fin: R_CFinalizer_t, onexit: Rboolean) -> SEXP;
}
extern "C" {
    pub fn R_WeakRefKey(w: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_WeakRefValue(w: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_RunWeakRefFinalizer(w: SEXP);
}
extern "C" {
    pub fn R_PromiseExpr(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_ClosureExpr(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_BytecodeExpr(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_initialize_bcode();
}
extern "C" {
    pub fn R_bcEncode(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_bcDecode(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_registerBC(arg1: SEXP, arg2: SEXP);
}
extern "C" {
    pub fn R_checkConstants(arg1: Rboolean) -> Rboolean;
}
extern "C" {
    pub fn R_BCVersionOK(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_init_altrep();
}
extern "C" {
    pub fn R_reinit_altrep_classes(arg1: *mut DllInfo);
}
extern "C" {
    pub fn R_ToplevelExec(
        fun: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
        data: *mut ::std::os::raw::c_void,
    ) -> Rboolean;
}
extern "C" {
    pub fn R_ExecWithCleanup(
        fun: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> SEXP>,
        data: *mut ::std::os::raw::c_void,
        cleanfun: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
        cleandata: *mut ::std::os::raw::c_void,
    ) -> SEXP;
}
extern "C" {
    pub fn R_tryCatch(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg2: *mut ::std::os::raw::c_void,
        arg3: SEXP,
        arg4: ::std::option::Option<
            unsafe extern "C" fn(arg1: SEXP, arg2: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg5: *mut ::std::os::raw::c_void,
        arg6: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
        arg7: *mut ::std::os::raw::c_void,
    ) -> SEXP;
}
extern "C" {
    pub fn R_tryCatchError(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(arg1: SEXP, arg2: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg4: *mut ::std::os::raw::c_void,
    ) -> SEXP;
}
extern "C" {
    pub fn R_withCallingErrorHandler(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(arg1: SEXP, arg2: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg4: *mut ::std::os::raw::c_void,
    ) -> SEXP;
}
extern "C" {
    pub fn R_MakeUnwindCont() -> SEXP;
}
extern "C" {
    pub fn R_ContinueUnwind(cont: SEXP);
}
extern "C" {
    pub fn R_UnwindProtect(
        fun: ::std::option::Option<unsafe extern "C" fn(data: *mut ::std::os::raw::c_void) -> SEXP>,
        data: *mut ::std::os::raw::c_void,
        cleanfun: ::std::option::Option<
            unsafe extern "C" fn(data: *mut ::std::os::raw::c_void, jump: Rboolean),
        >,
        cleandata: *mut ::std::os::raw::c_void,
        cont: SEXP,
    ) -> SEXP;
}
extern "C" {
    pub fn R_RestoreHashCount(rho: SEXP);
}
extern "C" {
    pub fn R_IsPackageEnv(rho: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_PackageEnvName(rho: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_FindPackageEnv(info: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_IsNamespaceEnv(rho: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_NamespaceEnvSpec(rho: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_FindNamespace(info: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_LockEnvironment(env: SEXP, bindings: Rboolean);
}
extern "C" {
    pub fn R_EnvironmentIsLocked(env: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_LockBinding(sym: SEXP, env: SEXP);
}
extern "C" {
    pub fn R_unLockBinding(sym: SEXP, env: SEXP);
}
extern "C" {
    pub fn R_MakeActiveBinding(sym: SEXP, fun: SEXP, env: SEXP);
}
extern "C" {
    pub fn R_BindingIsLocked(sym: SEXP, env: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_BindingIsActive(sym: SEXP, env: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_ActiveBindingFunction(sym: SEXP, env: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_HasFancyBindings(rho: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_errorcall(arg1: SEXP, arg2: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn Rf_warningcall(arg1: SEXP, arg2: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn Rf_warningcall_immediate(arg1: SEXP, arg2: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn R_XDREncodeDouble(d: f64, buf: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn R_XDRDecodeDouble(buf: *mut ::std::os::raw::c_void) -> f64;
}
extern "C" {
    pub fn R_XDREncodeInteger(i: ::std::os::raw::c_int, buf: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn R_XDRDecodeInteger(buf: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
pub type R_pstream_data_t = *mut ::std::os::raw::c_void;
pub const R_pstream_format_t_R_pstream_any_format: R_pstream_format_t = 0;
pub const R_pstream_format_t_R_pstream_ascii_format: R_pstream_format_t = 1;
pub const R_pstream_format_t_R_pstream_binary_format: R_pstream_format_t = 2;
pub const R_pstream_format_t_R_pstream_xdr_format: R_pstream_format_t = 3;
pub const R_pstream_format_t_R_pstream_asciihex_format: R_pstream_format_t = 4;
pub type R_pstream_format_t = u32;
pub type R_outpstream_t = *mut R_outpstream_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_outpstream_st {
    pub data: R_pstream_data_t,
    pub type_: R_pstream_format_t,
    pub version: ::std::os::raw::c_int,
    pub OutChar: ::std::option::Option<
        unsafe extern "C" fn(arg1: R_outpstream_t, arg2: ::std::os::raw::c_int),
    >,
    pub OutBytes: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: R_outpstream_t,
            arg2: *mut ::std::os::raw::c_void,
            arg3: ::std::os::raw::c_int,
        ),
    >,
    pub OutPersistHookFunc:
        ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
    pub OutPersistHookData: SEXP,
}
#[test]
fn bindgen_test_layout_R_outpstream_st() {
    assert_eq!(
        ::std::mem::size_of::<R_outpstream_st>(),
        48usize,
        concat!("Size of: ", stringify!(R_outpstream_st))
    );
    assert_eq!(
        ::std::mem::align_of::<R_outpstream_st>(),
        8usize,
        concat!("Alignment of ", stringify!(R_outpstream_st))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_outpstream_st>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(R_outpstream_st),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_outpstream_st>())).type_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(R_outpstream_st),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_outpstream_st>())).version as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(R_outpstream_st),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_outpstream_st>())).OutChar as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(R_outpstream_st),
            "::",
            stringify!(OutChar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_outpstream_st>())).OutBytes as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(R_outpstream_st),
            "::",
            stringify!(OutBytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<R_outpstream_st>())).OutPersistHookFunc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(R_outpstream_st),
            "::",
            stringify!(OutPersistHookFunc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<R_outpstream_st>())).OutPersistHookData as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(R_outpstream_st),
            "::",
            stringify!(OutPersistHookData)
        )
    );
}
pub type R_inpstream_t = *mut R_inpstream_st;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct R_inpstream_st {
    pub data: R_pstream_data_t,
    pub type_: R_pstream_format_t,
    pub InChar:
        ::std::option::Option<unsafe extern "C" fn(arg1: R_inpstream_t) -> ::std::os::raw::c_int>,
    pub InBytes: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: R_inpstream_t,
            arg2: *mut ::std::os::raw::c_void,
            arg3: ::std::os::raw::c_int,
        ),
    >,
    pub InPersistHookFunc:
        ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
    pub InPersistHookData: SEXP,
    pub native_encoding: [::std::os::raw::c_char; 64usize],
    pub nat2nat_obj: *mut ::std::os::raw::c_void,
    pub nat2utf8_obj: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_R_inpstream_st() {
    assert_eq!(
        ::std::mem::size_of::<R_inpstream_st>(),
        128usize,
        concat!("Size of: ", stringify!(R_inpstream_st))
    );
    assert_eq!(
        ::std::mem::align_of::<R_inpstream_st>(),
        8usize,
        concat!("Alignment of ", stringify!(R_inpstream_st))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_inpstream_st>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_inpstream_st>())).type_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_inpstream_st>())).InChar as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(InChar)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_inpstream_st>())).InBytes as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(InBytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<R_inpstream_st>())).InPersistHookFunc as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(InPersistHookFunc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<R_inpstream_st>())).InPersistHookData as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(InPersistHookData)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_inpstream_st>())).native_encoding as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(native_encoding)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_inpstream_st>())).nat2nat_obj as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(nat2nat_obj)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_inpstream_st>())).nat2utf8_obj as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(nat2utf8_obj)
        )
    );
}
extern "C" {
    pub fn R_InitInPStream(
        stream: R_inpstream_t,
        data: R_pstream_data_t,
        type_: R_pstream_format_t,
        inchar: ::std::option::Option<
            unsafe extern "C" fn(arg1: R_inpstream_t) -> ::std::os::raw::c_int,
        >,
        inbytes: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: R_inpstream_t,
                arg2: *mut ::std::os::raw::c_void,
                arg3: ::std::os::raw::c_int,
            ),
        >,
        phook: ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
        pdata: SEXP,
    );
}
extern "C" {
    pub fn R_InitOutPStream(
        stream: R_outpstream_t,
        data: R_pstream_data_t,
        type_: R_pstream_format_t,
        version: ::std::os::raw::c_int,
        outchar: ::std::option::Option<
            unsafe extern "C" fn(arg1: R_outpstream_t, arg2: ::std::os::raw::c_int),
        >,
        outbytes: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: R_outpstream_t,
                arg2: *mut ::std::os::raw::c_void,
                arg3: ::std::os::raw::c_int,
            ),
        >,
        phook: ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
        pdata: SEXP,
    );
}
extern "C" {
    pub fn R_InitFileInPStream(
        stream: R_inpstream_t,
        fp: *mut FILE,
        type_: R_pstream_format_t,
        phook: ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
        pdata: SEXP,
    );
}
extern "C" {
    pub fn R_InitFileOutPStream(
        stream: R_outpstream_t,
        fp: *mut FILE,
        type_: R_pstream_format_t,
        version: ::std::os::raw::c_int,
        phook: ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
        pdata: SEXP,
    );
}
extern "C" {
    pub fn R_Serialize(s: SEXP, ops: R_outpstream_t);
}
extern "C" {
    pub fn R_Unserialize(ips: R_inpstream_t) -> SEXP;
}
extern "C" {
    pub fn R_SerializeInfo(ips: R_inpstream_t) -> SEXP;
}
extern "C" {
    pub fn R_do_slot(obj: SEXP, name: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_do_slot_assign(obj: SEXP, name: SEXP, value: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_has_slot(obj: SEXP, name: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_S4_extends(klass: SEXP, useTable: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_do_MAKE_CLASS(what: *const ::std::os::raw::c_char) -> SEXP;
}
extern "C" {
    pub fn R_getClassDef(what: *const ::std::os::raw::c_char) -> SEXP;
}
extern "C" {
    pub fn R_getClassDef_R(what: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_has_methods_attached() -> Rboolean;
}
extern "C" {
    pub fn R_isVirtualClass(class_def: SEXP, env: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_extends(class1: SEXP, class2: SEXP, env: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_do_new_object(class_def: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_check_class_and_super(
        x: SEXP,
        valid: *mut *const ::std::os::raw::c_char,
        rho: SEXP,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_check_class_etc(
        x: SEXP,
        valid: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_PreserveObject(arg1: SEXP);
}
extern "C" {
    pub fn R_ReleaseObject(arg1: SEXP);
}
extern "C" {
    pub fn R_NewPreciousMSet(arg1: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn R_PreserveInMSet(x: SEXP, mset: SEXP);
}
extern "C" {
    pub fn R_ReleaseFromMSet(x: SEXP, mset: SEXP);
}
extern "C" {
    pub fn R_ReleaseMSet(mset: SEXP, keepSize: ::std::os::raw::c_int);
}
extern "C" {
    pub fn R_dot_Last();
}
extern "C" {
    pub fn R_RunExitFinalizers();
}
extern "C" {
    pub fn R_system(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_compute_identical(arg1: SEXP, arg2: SEXP, arg3: ::std::os::raw::c_int) -> Rboolean;
}
extern "C" {
    pub fn R_body_no_src(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_orderVector(
        indx: *mut ::std::os::raw::c_int,
        n: ::std::os::raw::c_int,
        arglist: SEXP,
        nalast: Rboolean,
        decreasing: Rboolean,
    );
}
extern "C" {
    pub fn R_orderVector1(
        indx: *mut ::std::os::raw::c_int,
        n: ::std::os::raw::c_int,
        x: SEXP,
        nalast: Rboolean,
        decreasing: Rboolean,
    );
}
extern "C" {
    pub fn Rf_allocVector(arg1: SEXPTYPE, arg2: R_xlen_t) -> SEXP;
}
extern "C" {
    pub fn Rf_conformable(arg1: SEXP, arg2: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_elt(arg1: SEXP, arg2: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn Rf_inherits(arg1: SEXP, arg2: *const ::std::os::raw::c_char) -> Rboolean;
}
extern "C" {
    pub fn Rf_isArray(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isFactor(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isFrame(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isFunction(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isInteger(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isLanguage(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isList(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isMatrix(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isNewList(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isNumber(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isNumeric(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isPairList(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isPrimitive(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isTs(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isUserBinop(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isValidString(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isValidStringF(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isVector(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isVectorAtomic(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isVectorList(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isVectorizable(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_lang1(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_lang2(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_lang3(arg1: SEXP, arg2: SEXP, arg3: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_lang4(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_lang5(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP, arg5: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_lang6(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP, arg5: SEXP, arg6: SEXP)
        -> SEXP;
}
extern "C" {
    pub fn Rf_lastElt(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_lcons(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_length(arg1: SEXP) -> R_len_t;
}
extern "C" {
    pub fn Rf_list1(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_list2(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_list3(arg1: SEXP, arg2: SEXP, arg3: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_list4(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_list5(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP, arg5: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_list6(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP, arg5: SEXP, arg6: SEXP)
        -> SEXP;
}
extern "C" {
    pub fn Rf_listAppend(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_mkNamed(arg1: SEXPTYPE, arg2: *mut *const ::std::os::raw::c_char) -> SEXP;
}
extern "C" {
    pub fn Rf_mkString(arg1: *const ::std::os::raw::c_char) -> SEXP;
}
extern "C" {
    pub fn Rf_nlevels(arg1: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_stringPositionTr(
        arg1: SEXP,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_ScalarComplex(arg1: Rcomplex) -> SEXP;
}
extern "C" {
    pub fn Rf_ScalarInteger(arg1: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn Rf_ScalarLogical(arg1: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn Rf_ScalarRaw(arg1: Rbyte) -> SEXP;
}
extern "C" {
    pub fn Rf_ScalarReal(arg1: f64) -> SEXP;
}
extern "C" {
    pub fn Rf_ScalarString(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_xlength(arg1: SEXP) -> R_xlen_t;
}
extern "C" {
    pub fn XTRUELENGTH(x: SEXP) -> R_xlen_t;
}
extern "C" {
    pub fn LENGTH_EX(
        x: SEXP,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn XLENGTH_EX(x: SEXP) -> R_xlen_t;
}
extern "C" {
    pub fn Rf_protect(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_unprotect(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn R_ProtectWithIndex(arg1: SEXP, arg2: *mut PROTECT_INDEX);
}
extern "C" {
    pub fn R_Reprotect(arg1: SEXP, arg2: PROTECT_INDEX);
}
extern "C" {
    pub fn R_FixupRHS(x: SEXP, y: SEXP) -> SEXP;
}
extern "C" {
    pub fn CAR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn DATAPTR(x: SEXP) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn DATAPTR_RO(x: SEXP) -> *const ::std::os::raw::c_void;
}
extern "C" {
    pub fn DATAPTR_OR_NULL(x: SEXP) -> *const ::std::os::raw::c_void;
}
extern "C" {
    pub fn LOGICAL_OR_NULL(x: SEXP) -> *const ::std::os::raw::c_int;
}
extern "C" {
    pub fn INTEGER_OR_NULL(x: SEXP) -> *const ::std::os::raw::c_int;
}
extern "C" {
    pub fn REAL_OR_NULL(x: SEXP) -> *const f64;
}
extern "C" {
    pub fn COMPLEX_OR_NULL(x: SEXP) -> *const Rcomplex;
}
extern "C" {
    pub fn RAW_OR_NULL(x: SEXP) -> *const Rbyte;
}
extern "C" {
    pub fn INTEGER_ELT(x: SEXP, i: R_xlen_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn REAL_ELT(x: SEXP, i: R_xlen_t) -> f64;
}
extern "C" {
    pub fn LOGICAL_ELT(x: SEXP, i: R_xlen_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn COMPLEX_ELT(x: SEXP, i: R_xlen_t) -> Rcomplex;
}
extern "C" {
    pub fn RAW_ELT(x: SEXP, i: R_xlen_t) -> Rbyte;
}
extern "C" {
    pub fn STRING_ELT(x: SEXP, i: R_xlen_t) -> SEXP;
}
extern "C" {
    pub fn SCALAR_DVAL(x: SEXP) -> f64;
}
extern "C" {
    pub fn SCALAR_LVAL(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SCALAR_IVAL(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_SCALAR_DVAL(x: SEXP, v: f64);
}
extern "C" {
    pub fn SET_SCALAR_LVAL(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_SCALAR_IVAL(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_SCALAR_CVAL(x: SEXP, v: Rcomplex);
}
extern "C" {
    pub fn SET_SCALAR_BVAL(x: SEXP, v: Rbyte);
}
extern "C" {
    pub fn R_altrep_data1(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_altrep_data2(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_set_altrep_data1(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn R_set_altrep_data2(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn ALTREP_CLASS(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn LOGICAL0(x: SEXP) -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn INTEGER0(x: SEXP) -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn REAL0(x: SEXP) -> *mut f64;
}
extern "C" {
    pub fn COMPLEX0(x: SEXP) -> *mut Rcomplex;
}
extern "C" {
    pub fn RAW0(x: SEXP) -> *mut Rbyte;
}
extern "C" {
    pub fn SET_LOGICAL_ELT(x: SEXP, i: R_xlen_t, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_INTEGER_ELT(x: SEXP, i: R_xlen_t, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_REAL_ELT(x: SEXP, i: R_xlen_t, v: f64);
}
extern "C" {
    pub fn R_BadValueInRCode(
        value: SEXP,
        call: SEXP,
        rho: SEXP,
        rawmsg: *const ::std::os::raw::c_char,
        errmsg: *const ::std::os::raw::c_char,
        warnmsg: *const ::std::os::raw::c_char,
        varname: *const ::std::os::raw::c_char,
        warnByDefault: Rboolean,
    );
}
extern "C" {
    pub static mut R_CStackLimit: usize;
}
extern "C" {
    pub fn Rf_initEmbeddedR(
        argc: ::std::os::raw::c_int,
        argv: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_endEmbeddedR(fatal: ::std::os::raw::c_int);
}
extern "C" {
    pub fn Rf_initialize_R(
        ac: ::std::os::raw::c_int,
        av: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setup_Rmainloop();
}
extern "C" {
    pub fn R_ReplDLLinit();
}
extern "C" {
    pub fn R_ReplDLLdo1() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_setStartTime();
}
extern "C" {
    pub fn CleanEd();
}
extern "C" {
    pub fn Rf_KillAllDevices();
}
extern "C" {
    pub static mut R_DirtyImage: ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_CleanTempDir();
}
extern "C" {
    pub static mut R_TempDir: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_SaveGlobalEnv();
}
extern "C" {
    pub fn getDLLVersion() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getRUser() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn get_R_HOME() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn setup_term_ui();
}
extern "C" {
    pub static mut UserBreak: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut AllDevicesKilled: Rboolean;
}
extern "C" {
    pub fn editorcleanall();
}
extern "C" {
    pub fn GA_initapp(
        arg1: ::std::os::raw::c_int,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GA_appcleanup();
}
extern "C" {
    pub fn readconsolecfg();
}
pub const ParseStatus_PARSE_NULL: ParseStatus = 0;
pub const ParseStatus_PARSE_OK: ParseStatus = 1;
pub const ParseStatus_PARSE_INCOMPLETE: ParseStatus = 2;
pub const ParseStatus_PARSE_ERROR: ParseStatus = 3;
pub const ParseStatus_PARSE_EOF: ParseStatus = 4;
pub type ParseStatus = u32;
extern "C" {
    pub fn R_ParseVector(
        arg1: SEXP,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ParseStatus,
        arg4: SEXP,
    ) -> SEXP;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_altrep_class_t {
    pub ptr: SEXP,
}
#[test]
fn bindgen_test_layout_R_altrep_class_t() {
    assert_eq!(
        ::std::mem::size_of::<R_altrep_class_t>(),
        8usize,
        concat!("Size of: ", stringify!(R_altrep_class_t))
    );
    assert_eq!(
        ::std::mem::align_of::<R_altrep_class_t>(),
        8usize,
        concat!("Alignment of ", stringify!(R_altrep_class_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_altrep_class_t>())).ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(R_altrep_class_t),
            "::",
            stringify!(ptr)
        )
    );
}
extern "C" {
    pub fn R_new_altrep(aclass: R_altrep_class_t, data1: SEXP, data2: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_make_altstring_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
}
extern "C" {
    pub fn R_make_altinteger_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
}
extern "C" {
    pub fn R_make_altreal_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
}
extern "C" {
    pub fn R_make_altlogical_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
}
extern "C" {
    pub fn R_make_altraw_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
}
extern "C" {
    pub fn R_make_altcomplex_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
}
extern "C" {
    pub fn R_altrep_inherits(x: SEXP, arg1: R_altrep_class_t) -> Rboolean;
}
pub type R_altrep_UnserializeEX_method_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: SEXP,
        arg2: SEXP,
        arg3: SEXP,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> SEXP,
>;
pub type R_altrep_Unserialize_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>;
pub type R_altrep_Serialized_state_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> SEXP>;
pub type R_altrep_DuplicateEX_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altrep_Duplicate_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altrep_Coerce_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: ::std::os::raw::c_int) -> SEXP>;
pub type R_altrep_Inspect_method_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: SEXP,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: SEXP,
                arg2: ::std::os::raw::c_int,
                arg3: ::std::os::raw::c_int,
                arg4: ::std::os::raw::c_int,
            ),
        >,
    ) -> Rboolean,
>;
pub type R_altrep_Length_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> R_xlen_t>;
pub type R_altvec_Dataptr_method_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> *mut ::std::os::raw::c_void,
>;
pub type R_altvec_Dataptr_or_null_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> *const ::std::os::raw::c_void>;
pub type R_altvec_Extract_subset_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP, arg3: SEXP) -> SEXP>;
pub type R_altinteger_Elt_method_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> ::std::os::raw::c_int,
>;
pub type R_altinteger_Get_region_method_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: SEXP,
        arg2: R_xlen_t,
        arg3: R_xlen_t,
        arg4: *mut ::std::os::raw::c_int,
    ) -> R_xlen_t,
>;
pub type R_altinteger_Is_sorted_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altinteger_No_NA_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altinteger_Sum_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altinteger_Min_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altinteger_Max_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altreal_Elt_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> f64>;
pub type R_altreal_Get_region_method_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t, arg3: R_xlen_t, arg4: *mut f64) -> R_xlen_t,
>;
pub type R_altreal_Is_sorted_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altreal_No_NA_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altreal_Sum_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altreal_Min_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altreal_Max_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altlogical_Elt_method_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> ::std::os::raw::c_int,
>;
pub type R_altlogical_Get_region_method_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: SEXP,
        arg2: R_xlen_t,
        arg3: R_xlen_t,
        arg4: *mut ::std::os::raw::c_int,
    ) -> R_xlen_t,
>;
pub type R_altlogical_Is_sorted_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altlogical_No_NA_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altlogical_Sum_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altraw_Elt_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> Rbyte>;
pub type R_altraw_Get_region_method_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t, arg3: R_xlen_t, arg4: *mut Rbyte) -> R_xlen_t,
>;
pub type R_altcomplex_Elt_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> Rcomplex>;
pub type R_altcomplex_Get_region_method_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: SEXP,
        arg2: R_xlen_t,
        arg3: R_xlen_t,
        arg4: *mut Rcomplex,
    ) -> R_xlen_t,
>;
pub type R_altstring_Elt_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> SEXP>;
pub type R_altstring_Set_elt_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t, arg3: SEXP)>;
pub type R_altstring_Is_sorted_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altstring_No_NA_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
extern "C" {
    pub fn R_set_altrep_UnserializeEX_method(
        cls: R_altrep_class_t,
        fun: R_altrep_UnserializeEX_method_t,
    );
}
extern "C" {
    pub fn R_set_altrep_Unserialize_method(
        cls: R_altrep_class_t,
        fun: R_altrep_Unserialize_method_t,
    );
}
extern "C" {
    pub fn R_set_altrep_Serialized_state_method(
        cls: R_altrep_class_t,
        fun: R_altrep_Serialized_state_method_t,
    );
}
extern "C" {
    pub fn R_set_altrep_DuplicateEX_method(
        cls: R_altrep_class_t,
        fun: R_altrep_DuplicateEX_method_t,
    );
}
extern "C" {
    pub fn R_set_altrep_Duplicate_method(cls: R_altrep_class_t, fun: R_altrep_Duplicate_method_t);
}
extern "C" {
    pub fn R_set_altrep_Coerce_method(cls: R_altrep_class_t, fun: R_altrep_Coerce_method_t);
}
extern "C" {
    pub fn R_set_altrep_Inspect_method(cls: R_altrep_class_t, fun: R_altrep_Inspect_method_t);
}
extern "C" {
    pub fn R_set_altrep_Length_method(cls: R_altrep_class_t, fun: R_altrep_Length_method_t);
}
extern "C" {
    pub fn R_set_altvec_Dataptr_method(cls: R_altrep_class_t, fun: R_altvec_Dataptr_method_t);
}
extern "C" {
    pub fn R_set_altvec_Dataptr_or_null_method(
        cls: R_altrep_class_t,
        fun: R_altvec_Dataptr_or_null_method_t,
    );
}
extern "C" {
    pub fn R_set_altvec_Extract_subset_method(
        cls: R_altrep_class_t,
        fun: R_altvec_Extract_subset_method_t,
    );
}
extern "C" {
    pub fn R_set_altinteger_Elt_method(cls: R_altrep_class_t, fun: R_altinteger_Elt_method_t);
}
extern "C" {
    pub fn R_set_altinteger_Get_region_method(
        cls: R_altrep_class_t,
        fun: R_altinteger_Get_region_method_t,
    );
}
extern "C" {
    pub fn R_set_altinteger_Is_sorted_method(
        cls: R_altrep_class_t,
        fun: R_altinteger_Is_sorted_method_t,
    );
}
extern "C" {
    pub fn R_set_altinteger_No_NA_method(cls: R_altrep_class_t, fun: R_altinteger_No_NA_method_t);
}
extern "C" {
    pub fn R_set_altinteger_Sum_method(cls: R_altrep_class_t, fun: R_altinteger_Sum_method_t);
}
extern "C" {
    pub fn R_set_altinteger_Min_method(cls: R_altrep_class_t, fun: R_altinteger_Min_method_t);
}
extern "C" {
    pub fn R_set_altinteger_Max_method(cls: R_altrep_class_t, fun: R_altinteger_Max_method_t);
}
extern "C" {
    pub fn R_set_altreal_Elt_method(cls: R_altrep_class_t, fun: R_altreal_Elt_method_t);
}
extern "C" {
    pub fn R_set_altreal_Get_region_method(
        cls: R_altrep_class_t,
        fun: R_altreal_Get_region_method_t,
    );
}
extern "C" {
    pub fn R_set_altreal_Is_sorted_method(cls: R_altrep_class_t, fun: R_altreal_Is_sorted_method_t);
}
extern "C" {
    pub fn R_set_altreal_No_NA_method(cls: R_altrep_class_t, fun: R_altreal_No_NA_method_t);
}
extern "C" {
    pub fn R_set_altreal_Sum_method(cls: R_altrep_class_t, fun: R_altreal_Sum_method_t);
}
extern "C" {
    pub fn R_set_altreal_Min_method(cls: R_altrep_class_t, fun: R_altreal_Min_method_t);
}
extern "C" {
    pub fn R_set_altreal_Max_method(cls: R_altrep_class_t, fun: R_altreal_Max_method_t);
}
extern "C" {
    pub fn R_set_altlogical_Elt_method(cls: R_altrep_class_t, fun: R_altlogical_Elt_method_t);
}
extern "C" {
    pub fn R_set_altlogical_Get_region_method(
        cls: R_altrep_class_t,
        fun: R_altlogical_Get_region_method_t,
    );
}
extern "C" {
    pub fn R_set_altlogical_Is_sorted_method(
        cls: R_altrep_class_t,
        fun: R_altlogical_Is_sorted_method_t,
    );
}
extern "C" {
    pub fn R_set_altlogical_No_NA_method(cls: R_altrep_class_t, fun: R_altlogical_No_NA_method_t);
}
extern "C" {
    pub fn R_set_altlogical_Sum_method(cls: R_altrep_class_t, fun: R_altlogical_Sum_method_t);
}
extern "C" {
    pub fn R_set_altraw_Elt_method(cls: R_altrep_class_t, fun: R_altraw_Elt_method_t);
}
extern "C" {
    pub fn R_set_altraw_Get_region_method(cls: R_altrep_class_t, fun: R_altraw_Get_region_method_t);
}
extern "C" {
    pub fn R_set_altcomplex_Elt_method(cls: R_altrep_class_t, fun: R_altcomplex_Elt_method_t);
}
extern "C" {
    pub fn R_set_altcomplex_Get_region_method(
        cls: R_altrep_class_t,
        fun: R_altcomplex_Get_region_method_t,
    );
}
extern "C" {
    pub fn R_set_altstring_Elt_method(cls: R_altrep_class_t, fun: R_altstring_Elt_method_t);
}
extern "C" {
    pub fn R_set_altstring_Set_elt_method(cls: R_altrep_class_t, fun: R_altstring_Set_elt_method_t);
}
extern "C" {
    pub fn R_set_altstring_Is_sorted_method(
        cls: R_altrep_class_t,
        fun: R_altstring_Is_sorted_method_t,
    );
}
extern "C" {
    pub fn R_set_altstring_No_NA_method(cls: R_altrep_class_t, fun: R_altstring_No_NA_method_t);
}
extern "C" {
    pub fn R_GE_getVersion() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_GE_checkVersionOrDie(version: ::std::os::raw::c_int);
}
pub const GEUnit_GE_DEVICE: GEUnit = 0;
pub const GEUnit_GE_NDC: GEUnit = 1;
pub const GEUnit_GE_INCHES: GEUnit = 2;
pub const GEUnit_GE_CM: GEUnit = 3;
pub type GEUnit = u32;
pub const GEevent_GE_InitState: GEevent = 0;
pub const GEevent_GE_FinaliseState: GEevent = 1;
pub const GEevent_GE_SaveState: GEevent = 2;
pub const GEevent_GE_RestoreState: GEevent = 6;
pub const GEevent_GE_CopyState: GEevent = 3;
pub const GEevent_GE_SaveSnapshotState: GEevent = 4;
pub const GEevent_GE_RestoreSnapshotState: GEevent = 5;
pub const GEevent_GE_CheckPlot: GEevent = 7;
pub const GEevent_GE_ScalePS: GEevent = 8;
pub type GEevent = u32;
pub const R_GE_lineend_GE_ROUND_CAP: R_GE_lineend = 1;
pub const R_GE_lineend_GE_BUTT_CAP: R_GE_lineend = 2;
pub const R_GE_lineend_GE_SQUARE_CAP: R_GE_lineend = 3;
pub type R_GE_lineend = u32;
pub const R_GE_linejoin_GE_ROUND_JOIN: R_GE_linejoin = 1;
pub const R_GE_linejoin_GE_MITRE_JOIN: R_GE_linejoin = 2;
pub const R_GE_linejoin_GE_BEVEL_JOIN: R_GE_linejoin = 3;
pub type R_GE_linejoin = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct R_GE_gcontext {
    pub col: ::std::os::raw::c_int,
    pub fill: ::std::os::raw::c_int,
    pub gamma: f64,
    pub lwd: f64,
    pub lty: ::std::os::raw::c_int,
    pub lend: R_GE_lineend,
    pub ljoin: R_GE_linejoin,
    pub lmitre: f64,
    pub cex: f64,
    pub ps: f64,
    pub lineheight: f64,
    pub fontface: ::std::os::raw::c_int,
    pub fontfamily: [::std::os::raw::c_char; 201usize],
}
#[test]
fn bindgen_test_layout_R_GE_gcontext() {
    assert_eq!(
        ::std::mem::size_of::<R_GE_gcontext>(),
        280usize,
        concat!("Size of: ", stringify!(R_GE_gcontext))
    );
    assert_eq!(
        ::std::mem::align_of::<R_GE_gcontext>(),
        8usize,
        concat!("Alignment of ", stringify!(R_GE_gcontext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_GE_gcontext>())).col as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(col)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_GE_gcontext>())).fill as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(fill)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_GE_gcontext>())).gamma as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(gamma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_GE_gcontext>())).lwd as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(lwd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_GE_gcontext>())).lty as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(lty)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_GE_gcontext>())).lend as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(lend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_GE_gcontext>())).ljoin as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(ljoin)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_GE_gcontext>())).lmitre as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(lmitre)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_GE_gcontext>())).cex as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(cex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_GE_gcontext>())).ps as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(ps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_GE_gcontext>())).lineheight as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(lineheight)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_GE_gcontext>())).fontface as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(fontface)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<R_GE_gcontext>())).fontfamily as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(fontfamily)
        )
    );
}
pub type pGEcontext = *mut R_GE_gcontext;
pub type DevDesc = _DevDesc;
pub type pDevDesc = *mut DevDesc;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _DevDesc {
    #[doc = " Device physical characteristics"]
    pub left: f64,
    pub right: f64,
    pub bottom: f64,
    pub top: f64,
    pub clipLeft: f64,
    pub clipRight: f64,
    pub clipBottom: f64,
    pub clipTop: f64,
    pub xCharOffset: f64,
    pub yCharOffset: f64,
    pub yLineBias: f64,
    pub ipr: [f64; 2usize],
    pub cra: [f64; 2usize],
    pub gamma: f64,
    #[doc = " Device capabilities"]
    pub canClip: Rboolean,
    pub canChangeGamma: Rboolean,
    pub canHAdj: ::std::os::raw::c_int,
    #[doc = " Device initial settings"]
    pub startps: f64,
    pub startcol: ::std::os::raw::c_int,
    pub startfill: ::std::os::raw::c_int,
    pub startlty: ::std::os::raw::c_int,
    pub startfont: ::std::os::raw::c_int,
    pub startgamma: f64,
    #[doc = " Device specific information"]
    pub deviceSpecific: *mut ::std::os::raw::c_void,
    #[doc = " Device display list"]
    pub displayListOn: Rboolean,
    #[doc = " Event handling entries"]
    pub canGenMouseDown: Rboolean,
    pub canGenMouseMove: Rboolean,
    pub canGenMouseUp: Rboolean,
    pub canGenKeybd: Rboolean,
    pub canGenIdle: Rboolean,
    pub gettingEvent: Rboolean,
    pub activate: ::std::option::Option<unsafe extern "C" fn(arg1: pDevDesc)>,
    pub circle: ::std::option::Option<
        unsafe extern "C" fn(x: f64, y: f64, r: f64, gc: pGEcontext, dd: pDevDesc),
    >,
    pub clip: ::std::option::Option<
        unsafe extern "C" fn(x0: f64, x1: f64, y0: f64, y1: f64, dd: pDevDesc),
    >,
    pub close: ::std::option::Option<unsafe extern "C" fn(dd: pDevDesc)>,
    pub deactivate: ::std::option::Option<unsafe extern "C" fn(arg1: pDevDesc)>,
    pub locator: ::std::option::Option<
        unsafe extern "C" fn(x: *mut f64, y: *mut f64, dd: pDevDesc) -> Rboolean,
    >,
    pub line: ::std::option::Option<
        unsafe extern "C" fn(x1: f64, y1: f64, x2: f64, y2: f64, gc: pGEcontext, dd: pDevDesc),
    >,
    pub metricInfo: ::std::option::Option<
        unsafe extern "C" fn(
            c: ::std::os::raw::c_int,
            gc: pGEcontext,
            ascent: *mut f64,
            descent: *mut f64,
            width: *mut f64,
            dd: pDevDesc,
        ),
    >,
    pub mode:
        ::std::option::Option<unsafe extern "C" fn(mode: ::std::os::raw::c_int, dd: pDevDesc)>,
    pub newPage: ::std::option::Option<unsafe extern "C" fn(gc: pGEcontext, dd: pDevDesc)>,
    pub polygon: ::std::option::Option<
        unsafe extern "C" fn(
            n: ::std::os::raw::c_int,
            x: *mut f64,
            y: *mut f64,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub polyline: ::std::option::Option<
        unsafe extern "C" fn(
            n: ::std::os::raw::c_int,
            x: *mut f64,
            y: *mut f64,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub rect: ::std::option::Option<
        unsafe extern "C" fn(x0: f64, y0: f64, x1: f64, y1: f64, gc: pGEcontext, dd: pDevDesc),
    >,
    pub path: ::std::option::Option<
        unsafe extern "C" fn(
            x: *mut f64,
            y: *mut f64,
            npoly: ::std::os::raw::c_int,
            nper: *mut ::std::os::raw::c_int,
            winding: Rboolean,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub raster: ::std::option::Option<
        unsafe extern "C" fn(
            raster: *mut ::std::os::raw::c_uint,
            w: ::std::os::raw::c_int,
            h: ::std::os::raw::c_int,
            x: f64,
            y: f64,
            width: f64,
            height: f64,
            rot: f64,
            interpolate: Rboolean,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub cap: ::std::option::Option<unsafe extern "C" fn(dd: pDevDesc) -> SEXP>,
    pub size: ::std::option::Option<
        unsafe extern "C" fn(
            left: *mut f64,
            right: *mut f64,
            bottom: *mut f64,
            top: *mut f64,
            dd: pDevDesc,
        ),
    >,
    pub strWidth: ::std::option::Option<
        unsafe extern "C" fn(
            str: *const ::std::os::raw::c_char,
            gc: pGEcontext,
            dd: pDevDesc,
        ) -> f64,
    >,
    pub text: ::std::option::Option<
        unsafe extern "C" fn(
            x: f64,
            y: f64,
            str: *const ::std::os::raw::c_char,
            rot: f64,
            hadj: f64,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub onExit: ::std::option::Option<unsafe extern "C" fn(dd: pDevDesc)>,
    pub getEvent: ::std::option::Option<
        unsafe extern "C" fn(arg1: SEXP, arg2: *const ::std::os::raw::c_char) -> SEXP,
    >,
    pub newFrameConfirm: ::std::option::Option<unsafe extern "C" fn(dd: pDevDesc) -> Rboolean>,
    pub hasTextUTF8: Rboolean,
    pub textUTF8: ::std::option::Option<
        unsafe extern "C" fn(
            x: f64,
            y: f64,
            str: *const ::std::os::raw::c_char,
            rot: f64,
            hadj: f64,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub strWidthUTF8: ::std::option::Option<
        unsafe extern "C" fn(
            str: *const ::std::os::raw::c_char,
            gc: pGEcontext,
            dd: pDevDesc,
        ) -> f64,
    >,
    pub wantSymbolUTF8: Rboolean,
    pub useRotatedTextInContour: Rboolean,
    pub eventEnv: SEXP,
    pub eventHelper:
        ::std::option::Option<unsafe extern "C" fn(dd: pDevDesc, code: ::std::os::raw::c_int)>,
    pub holdflush: ::std::option::Option<
        unsafe extern "C" fn(dd: pDevDesc, level: ::std::os::raw::c_int) -> ::std::os::raw::c_int,
    >,
    pub haveTransparency: ::std::os::raw::c_int,
    pub haveTransparentBg: ::std::os::raw::c_int,
    pub haveRaster: ::std::os::raw::c_int,
    pub haveCapture: ::std::os::raw::c_int,
    pub haveLocator: ::std::os::raw::c_int,
    pub reserved: [::std::os::raw::c_char; 64usize],
}
#[test]
fn bindgen_test_layout__DevDesc() {
    assert_eq!(
        ::std::mem::size_of::<_DevDesc>(),
        536usize,
        concat!("Size of: ", stringify!(_DevDesc))
    );
    assert_eq!(
        ::std::mem::align_of::<_DevDesc>(),
        8usize,
        concat!("Alignment of ", stringify!(_DevDesc))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).left as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(left)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).right as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(right)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).bottom as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(bottom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).top as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(top)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).clipLeft as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(clipLeft)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).clipRight as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(clipRight)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).clipBottom as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(clipBottom)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).clipTop as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(clipTop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).xCharOffset as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(xCharOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).yCharOffset as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(yCharOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).yLineBias as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(yLineBias)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).ipr as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(ipr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).cra as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(cra)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).gamma as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(gamma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).canClip as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(canClip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).canChangeGamma as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(canChangeGamma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).canHAdj as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(canHAdj)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).startps as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(startps)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).startcol as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(startcol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).startfill as *const _ as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(startfill)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).startlty as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(startlty)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).startfont as *const _ as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(startfont)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).startgamma as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(startgamma)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).deviceSpecific as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(deviceSpecific)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).displayListOn as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(displayListOn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).canGenMouseDown as *const _ as usize },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(canGenMouseDown)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).canGenMouseMove as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(canGenMouseMove)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).canGenMouseUp as *const _ as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(canGenMouseUp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).canGenKeybd as *const _ as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(canGenKeybd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).canGenIdle as *const _ as usize },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(canGenIdle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).gettingEvent as *const _ as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(gettingEvent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).activate as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(activate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).circle as *const _ as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(circle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).clip as *const _ as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(clip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).close as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(close)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).deactivate as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(deactivate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).locator as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(locator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).line as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(line)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).metricInfo as *const _ as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(metricInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).mode as *const _ as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(mode)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).newPage as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(newPage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).polygon as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(polygon)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).polyline as *const _ as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(polyline)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).rect as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(rect)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).path as *const _ as usize },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(path)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).raster as *const _ as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(raster)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).cap as *const _ as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(cap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).size as *const _ as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).strWidth as *const _ as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(strWidth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).text as *const _ as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(text)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).onExit as *const _ as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(onExit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).getEvent as *const _ as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(getEvent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).newFrameConfirm as *const _ as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(newFrameConfirm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).hasTextUTF8 as *const _ as usize },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(hasTextUTF8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).textUTF8 as *const _ as usize },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(textUTF8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).strWidthUTF8 as *const _ as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(strWidthUTF8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).wantSymbolUTF8 as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(wantSymbolUTF8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_DevDesc>())).useRotatedTextInContour as *const _ as usize
        },
        420usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(useRotatedTextInContour)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).eventEnv as *const _ as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(eventEnv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).eventHelper as *const _ as usize },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(eventHelper)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).holdflush as *const _ as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(holdflush)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).haveTransparency as *const _ as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(haveTransparency)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).haveTransparentBg as *const _ as usize },
        452usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(haveTransparentBg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).haveRaster as *const _ as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(haveRaster)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).haveCapture as *const _ as usize },
        460usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(haveCapture)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).haveLocator as *const _ as usize },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(haveLocator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_DevDesc>())).reserved as *const _ as usize },
        468usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(reserved)
        )
    );
}
extern "C" {
    pub fn Rf_ndevNumber(arg1: pDevDesc) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_NumDevices() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_CheckDeviceAvailable();
}
extern "C" {
    pub fn R_CheckDeviceAvailableBool() -> Rboolean;
}
extern "C" {
    pub fn Rf_curDevice() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_nextDevice(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_prevDevice(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_selectDevice(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_killDevice(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn Rf_NoDevices() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_NewFrameConfirm(arg1: pDevDesc);
}
pub const R_KeyName_knUNKNOWN: R_KeyName = -1;
pub const R_KeyName_knLEFT: R_KeyName = 0;
pub const R_KeyName_knUP: R_KeyName = 1;
pub const R_KeyName_knRIGHT: R_KeyName = 2;
pub const R_KeyName_knDOWN: R_KeyName = 3;
pub const R_KeyName_knF1: R_KeyName = 4;
pub const R_KeyName_knF2: R_KeyName = 5;
pub const R_KeyName_knF3: R_KeyName = 6;
pub const R_KeyName_knF4: R_KeyName = 7;
pub const R_KeyName_knF5: R_KeyName = 8;
pub const R_KeyName_knF6: R_KeyName = 9;
pub const R_KeyName_knF7: R_KeyName = 10;
pub const R_KeyName_knF8: R_KeyName = 11;
pub const R_KeyName_knF9: R_KeyName = 12;
pub const R_KeyName_knF10: R_KeyName = 13;
pub const R_KeyName_knF11: R_KeyName = 14;
pub const R_KeyName_knF12: R_KeyName = 15;
pub const R_KeyName_knPGUP: R_KeyName = 16;
pub const R_KeyName_knPGDN: R_KeyName = 17;
pub const R_KeyName_knEND: R_KeyName = 18;
pub const R_KeyName_knHOME: R_KeyName = 19;
pub const R_KeyName_knINS: R_KeyName = 20;
pub const R_KeyName_knDEL: R_KeyName = 21;
pub type R_KeyName = i32;
pub const R_MouseEvent_meMouseDown: R_MouseEvent = 0;
pub const R_MouseEvent_meMouseUp: R_MouseEvent = 1;
pub const R_MouseEvent_meMouseMove: R_MouseEvent = 2;
pub type R_MouseEvent = u32;
extern "C" {
    pub fn Rf_doMouseEvent(
        dd: pDevDesc,
        event: R_MouseEvent,
        buttons: ::std::os::raw::c_int,
        x: f64,
        y: f64,
    );
}
extern "C" {
    pub fn Rf_doKeybd(dd: pDevDesc, rkey: R_KeyName, keyname: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn Rf_doIdle(dd: pDevDesc);
}
extern "C" {
    pub fn Rf_doesIdle(dd: pDevDesc) -> Rboolean;
}
extern "C" {
    pub static mut R_interrupts_suspended: Rboolean;
}
extern "C" {
    pub static mut R_interrupts_pending: ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_onintr();
}
extern "C" {
    pub static mut mbcslocale: Rboolean;
}
extern "C" {
    pub fn Rf_AdobeSymbol2utf8(
        out: *mut ::std::os::raw::c_char,
        in_: *const ::std::os::raw::c_char,
        nwork: size_t,
        usePUA: Rboolean,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn Rf_utf8toAdobeSymbol(
        out: *mut ::std::os::raw::c_char,
        in_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_utf8Toutf8NoPUA(in_: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_utf8ToLatin1AdobeSymbol2utf8(
        in_: *const ::std::os::raw::c_char,
        usePUA: Rboolean,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_ucstoutf8(s: *mut ::std::os::raw::c_char, c: ::std::os::raw::c_uint) -> size_t;
}
pub type GEDevDesc = _GEDevDesc;
pub type GEcallback = ::std::option::Option<
    unsafe extern "C" fn(arg1: GEevent, arg2: *mut GEDevDesc, arg3: SEXP) -> SEXP,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GESystemDesc {
    pub systemSpecific: *mut ::std::os::raw::c_void,
    pub callback: GEcallback,
}
#[test]
fn bindgen_test_layout_GESystemDesc() {
    assert_eq!(
        ::std::mem::size_of::<GESystemDesc>(),
        16usize,
        concat!("Size of: ", stringify!(GESystemDesc))
    );
    assert_eq!(
        ::std::mem::align_of::<GESystemDesc>(),
        8usize,
        concat!("Alignment of ", stringify!(GESystemDesc))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GESystemDesc>())).systemSpecific as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GESystemDesc),
            "::",
            stringify!(systemSpecific)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<GESystemDesc>())).callback as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GESystemDesc),
            "::",
            stringify!(callback)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GEDevDesc {
    pub dev: pDevDesc,
    pub displayListOn: Rboolean,
    pub displayList: SEXP,
    pub DLlastElt: SEXP,
    pub savedSnapshot: SEXP,
    pub dirty: Rboolean,
    pub recordGraphics: Rboolean,
    pub gesd: [*mut GESystemDesc; 24usize],
    pub ask: Rboolean,
}
#[test]
fn bindgen_test_layout__GEDevDesc() {
    assert_eq!(
        ::std::mem::size_of::<_GEDevDesc>(),
        248usize,
        concat!("Size of: ", stringify!(_GEDevDesc))
    );
    assert_eq!(
        ::std::mem::align_of::<_GEDevDesc>(),
        8usize,
        concat!("Alignment of ", stringify!(_GEDevDesc))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEDevDesc>())).dev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(dev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEDevDesc>())).displayListOn as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(displayListOn)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEDevDesc>())).displayList as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(displayList)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEDevDesc>())).DLlastElt as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(DLlastElt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEDevDesc>())).savedSnapshot as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(savedSnapshot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEDevDesc>())).dirty as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(dirty)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEDevDesc>())).recordGraphics as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(recordGraphics)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEDevDesc>())).gesd as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(gesd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_GEDevDesc>())).ask as *const _ as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(ask)
        )
    );
}
pub type pGEDevDesc = *mut GEDevDesc;
extern "C" {
    pub fn Rf_desc2GEDesc(dd: pDevDesc) -> pGEDevDesc;
}
extern "C" {
    pub fn GEdeviceNumber(arg1: pGEDevDesc) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GEgetDevice(arg1: ::std::os::raw::c_int) -> pGEDevDesc;
}
extern "C" {
    pub fn GEaddDevice(arg1: pGEDevDesc);
}
extern "C" {
    pub fn GEaddDevice2(arg1: pGEDevDesc, arg2: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn GEaddDevice2f(
        arg1: pGEDevDesc,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn GEkillDevice(arg1: pGEDevDesc);
}
extern "C" {
    pub fn GEcreateDevDesc(dev: pDevDesc) -> pGEDevDesc;
}
extern "C" {
    pub fn GEdestroyDevDesc(dd: pGEDevDesc);
}
extern "C" {
    pub fn GEsystemState(
        dd: pGEDevDesc,
        index: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn GEregisterWithDevice(dd: pGEDevDesc);
}
extern "C" {
    pub fn GEregisterSystem(callback: GEcallback, systemRegisterIndex: *mut ::std::os::raw::c_int);
}
extern "C" {
    pub fn GEunregisterSystem(registerIndex: ::std::os::raw::c_int);
}
extern "C" {
    pub fn GEhandleEvent(event: GEevent, dev: pDevDesc, data: SEXP) -> SEXP;
}
extern "C" {
    pub fn GEfromDeviceX(value: f64, to: GEUnit, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEtoDeviceX(value: f64, from: GEUnit, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEfromDeviceY(value: f64, to: GEUnit, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEtoDeviceY(value: f64, from: GEUnit, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEfromDeviceWidth(value: f64, to: GEUnit, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEtoDeviceWidth(value: f64, from: GEUnit, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEfromDeviceHeight(value: f64, to: GEUnit, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEtoDeviceHeight(value: f64, from: GEUnit, dd: pGEDevDesc) -> f64;
}
pub type rcolor = ::std::os::raw::c_uint;
extern "C" {
    pub fn Rf_RGBpar(arg1: SEXP, arg2: ::std::os::raw::c_int) -> rcolor;
}
extern "C" {
    pub fn Rf_RGBpar3(arg1: SEXP, arg2: ::std::os::raw::c_int, arg3: rcolor) -> rcolor;
}
extern "C" {
    pub fn Rf_col2name(col: rcolor) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_GE_str2col(s: *const ::std::os::raw::c_char) -> rcolor;
}
extern "C" {
    pub fn GE_LENDpar(value: SEXP, ind: ::std::os::raw::c_int) -> R_GE_lineend;
}
extern "C" {
    pub fn GE_LENDget(lend: R_GE_lineend) -> SEXP;
}
extern "C" {
    pub fn GE_LJOINpar(value: SEXP, ind: ::std::os::raw::c_int) -> R_GE_linejoin;
}
extern "C" {
    pub fn GE_LJOINget(ljoin: R_GE_linejoin) -> SEXP;
}
extern "C" {
    pub fn GESetClip(x1: f64, y1: f64, x2: f64, y2: f64, dd: pGEDevDesc);
}
extern "C" {
    pub fn GENewPage(gc: pGEcontext, dd: pGEDevDesc);
}
extern "C" {
    pub fn GELine(x1: f64, y1: f64, x2: f64, y2: f64, gc: pGEcontext, dd: pGEDevDesc);
}
extern "C" {
    pub fn GEPolyline(
        n: ::std::os::raw::c_int,
        x: *mut f64,
        y: *mut f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEPolygon(
        n: ::std::os::raw::c_int,
        x: *mut f64,
        y: *mut f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEXspline(
        n: ::std::os::raw::c_int,
        x: *mut f64,
        y: *mut f64,
        s: *mut f64,
        open: Rboolean,
        repEnds: Rboolean,
        draw: Rboolean,
        gc: pGEcontext,
        dd: pGEDevDesc,
    ) -> SEXP;
}
extern "C" {
    pub fn GECircle(x: f64, y: f64, radius: f64, gc: pGEcontext, dd: pGEDevDesc);
}
extern "C" {
    pub fn GERect(x0: f64, y0: f64, x1: f64, y1: f64, gc: pGEcontext, dd: pGEDevDesc);
}
extern "C" {
    pub fn GEPath(
        x: *mut f64,
        y: *mut f64,
        npoly: ::std::os::raw::c_int,
        nper: *mut ::std::os::raw::c_int,
        winding: Rboolean,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GERaster(
        raster: *mut ::std::os::raw::c_uint,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        x: f64,
        y: f64,
        width: f64,
        height: f64,
        angle: f64,
        interpolate: Rboolean,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GECap(dd: pGEDevDesc) -> SEXP;
}
extern "C" {
    pub fn GEText(
        x: f64,
        y: f64,
        str: *const ::std::os::raw::c_char,
        enc: cetype_t,
        xc: f64,
        yc: f64,
        rot: f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEMode(mode: ::std::os::raw::c_int, dd: pGEDevDesc);
}
extern "C" {
    pub fn GESymbol(
        x: f64,
        y: f64,
        pch: ::std::os::raw::c_int,
        size: f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEPretty(lo: *mut f64, up: *mut f64, ndiv: *mut ::std::os::raw::c_int);
}
extern "C" {
    pub fn GEMetricInfo(
        c: ::std::os::raw::c_int,
        gc: pGEcontext,
        ascent: *mut f64,
        descent: *mut f64,
        width: *mut f64,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEStrWidth(
        str: *const ::std::os::raw::c_char,
        enc: cetype_t,
        gc: pGEcontext,
        dd: pGEDevDesc,
    ) -> f64;
}
extern "C" {
    pub fn GEStrHeight(
        str: *const ::std::os::raw::c_char,
        enc: cetype_t,
        gc: pGEcontext,
        dd: pGEDevDesc,
    ) -> f64;
}
extern "C" {
    pub fn GEStrMetric(
        str: *const ::std::os::raw::c_char,
        enc: cetype_t,
        gc: pGEcontext,
        ascent: *mut f64,
        descent: *mut f64,
        width: *mut f64,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEstring_to_pch(pch: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GE_LTYpar(arg1: SEXP, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn GE_LTYget(arg1: ::std::os::raw::c_uint) -> SEXP;
}
extern "C" {
    pub fn R_GE_rasterScale(
        sraster: *mut ::std::os::raw::c_uint,
        sw: ::std::os::raw::c_int,
        sh: ::std::os::raw::c_int,
        draster: *mut ::std::os::raw::c_uint,
        dw: ::std::os::raw::c_int,
        dh: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn R_GE_rasterInterpolate(
        sraster: *mut ::std::os::raw::c_uint,
        sw: ::std::os::raw::c_int,
        sh: ::std::os::raw::c_int,
        draster: *mut ::std::os::raw::c_uint,
        dw: ::std::os::raw::c_int,
        dh: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn R_GE_rasterRotatedSize(
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        angle: f64,
        wnew: *mut ::std::os::raw::c_int,
        hnew: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn R_GE_rasterRotatedOffset(
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        angle: f64,
        botleft: ::std::os::raw::c_int,
        xoff: *mut f64,
        yoff: *mut f64,
    );
}
extern "C" {
    pub fn R_GE_rasterResizeForRotation(
        sraster: *mut ::std::os::raw::c_uint,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        newRaster: *mut ::std::os::raw::c_uint,
        wnew: ::std::os::raw::c_int,
        hnew: ::std::os::raw::c_int,
        gc: pGEcontext,
    );
}
extern "C" {
    pub fn R_GE_rasterRotate(
        sraster: *mut ::std::os::raw::c_uint,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        angle: f64,
        draster: *mut ::std::os::raw::c_uint,
        gc: pGEcontext,
        perPixelAlpha: Rboolean,
    );
}
extern "C" {
    pub fn GEExpressionWidth(expr: SEXP, gc: pGEcontext, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEExpressionHeight(expr: SEXP, gc: pGEcontext, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEExpressionMetric(
        expr: SEXP,
        gc: pGEcontext,
        ascent: *mut f64,
        descent: *mut f64,
        width: *mut f64,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEMathText(
        x: f64,
        y: f64,
        expr: SEXP,
        xc: f64,
        yc: f64,
        rot: f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEcontourLines(
        x: *mut f64,
        nx: ::std::os::raw::c_int,
        y: *mut f64,
        ny: ::std::os::raw::c_int,
        z: *mut f64,
        levels: *mut f64,
        nl: ::std::os::raw::c_int,
    ) -> SEXP;
}
extern "C" {
    pub fn R_GE_VStrWidth(
        s: *const ::std::os::raw::c_char,
        enc: cetype_t,
        gc: pGEcontext,
        dd: pGEDevDesc,
    ) -> f64;
}
extern "C" {
    pub fn R_GE_VStrHeight(
        s: *const ::std::os::raw::c_char,
        enc: cetype_t,
        gc: pGEcontext,
        dd: pGEDevDesc,
    ) -> f64;
}
extern "C" {
    pub fn R_GE_VText(
        x: f64,
        y: f64,
        s: *const ::std::os::raw::c_char,
        enc: cetype_t,
        x_justify: f64,
        y_justify: f64,
        rotation: f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEcurrentDevice() -> pGEDevDesc;
}
extern "C" {
    pub fn GEdeviceDirty(dd: pGEDevDesc) -> Rboolean;
}
extern "C" {
    pub fn GEdirtyDevice(dd: pGEDevDesc);
}
extern "C" {
    pub fn GEcheckState(dd: pGEDevDesc) -> Rboolean;
}
extern "C" {
    pub fn GErecording(call: SEXP, dd: pGEDevDesc) -> Rboolean;
}
extern "C" {
    pub fn GErecordGraphicOperation(op: SEXP, args: SEXP, dd: pGEDevDesc);
}
extern "C" {
    pub fn GEinitDisplayList(dd: pGEDevDesc);
}
extern "C" {
    pub fn GEplayDisplayList(dd: pGEDevDesc);
}
extern "C" {
    pub fn GEcopyDisplayList(fromDevice: ::std::os::raw::c_int);
}
extern "C" {
    pub fn GEcreateSnapshot(dd: pGEDevDesc) -> SEXP;
}
extern "C" {
    pub fn GEplaySnapshot(snapshot: SEXP, dd: pGEDevDesc);
}
extern "C" {
    pub fn GEonExit();
}
extern "C" {
    pub fn GEnullDevice();
}
extern "C" {
    pub fn Rf_CreateAtVector(
        arg1: *mut f64,
        arg2: *mut f64,
        arg3: ::std::os::raw::c_int,
        arg4: Rboolean,
    ) -> SEXP;
}
extern "C" {
    pub fn Rf_GAxisPars(
        min: *mut f64,
        max: *mut f64,
        n: *mut ::std::os::raw::c_int,
        log: Rboolean,
        axis: ::std::os::raw::c_int,
    );
}
pub type __builtin_va_list = *mut ::std::os::raw::c_char;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lconv {
    pub _address: u8,
}
