% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify.R
\name{simplify_geoms}
\alias{simplify_geoms}
\alias{simplify_vw_geoms}
\alias{simplify_vw_preserve_geoms}
\title{Simplify Geometry}
\usage{
simplify_geoms(x, epsilon)

simplify_vw_geoms(x, epsilon)

simplify_vw_preserve_geoms(x, epsilon)
}
\arguments{
\item{x}{an object of class of \code{rsgeo}}

\item{epsilon}{a tolerance parameter. Cannot be equal to or less than 0.}
}
\value{
an object of class \code{rsgeo}
}
\description{
Simplifies LineStrings, Polygons, and their Multi- counterparts.
}
\details{
Simplify functions use the Ramer–Douglas–Peucker algorithm. Functions with \code{vw} use
the Visvalingam-Whyatt algorithm.

For more see \href{https://docs.rs/geo/latest/geo/index.html#simplification}{\code{geo} docs}.
}
\examples{
x <- geom_linestring(1:100, runif(100, 5, 10))

simplify_geoms(x, 3)
simplify_vw_geoms(x, 2)
simplify_vw_preserve_geoms(x, 100)
}
