% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast.R
\name{cast_geoms}
\alias{cast_geoms}
\title{Cast geometries to another type}
\usage{
cast_geoms(x, to)
}
\arguments{
\item{x}{an object of class \code{rsgeo}}

\item{to}{a character scalar of the target geometry type. Must be one of
\code{"point"}, \code{"multipoint"}, \code{"polygon"}, \code{"multipolygon"}, \code{"linestring"},
or \code{"multilinestring"}.}
}
\value{
An object of class \code{rsgeo}
}
\description{
Cast geometries to another type
}
\details{
The below conversions are made available. The left hand column indicates
the originating vector class and the right hand column indicates the
class that it will can be cast to.

Note that correctness of conversions will not be checked or verified. If you
cast an \code{rs_MULTIPOINT} to an \code{rs_POLYGON}, the validity of the polygon
cannot be guaranteed.

Conversions from an \code{rs_POLYGON} into an \code{rs_LINESTRING} will result in only
the exterior ring of the polygon ignoring any interior rings if there are any.\tabular{ll}{
   From \tab To \cr
   \code{rs_POINT} \tab \code{rs_MULTIPOINT} \cr
   \code{rs_MULTIPOINT} \tab \code{rs_POLYGON}, \code{rs_MULTIPOLYGON}, \code{rs_LINESTRING}, \code{rs_MULTILINESTRING} \cr
   \code{rs_POLYGON} \tab \code{rs_MULTIPOINT}, \code{rs_MULTIPOLYGON}, \code{rs_LINESTRING}, \code{rs_MULTILINESTRING} \cr
   \code{rs_MULTIPOLYGON} \tab \code{rs_MULTIPOINT}, \code{rs_MULTILINESTRING} \cr
   \code{rs_LINESTRING} \tab \code{rs_MULTIPOINT}, \code{rs_MULTILINESTRING}, \code{rs_POLYGON} \cr
   \code{rs_MULTILINESTRING} \tab \code{rs_MULTIPOINT}, \code{rs_MULTIPOLYGON} \cr
}
}
\examples{
ply <- geom_polygon(c(0, 1, 1, 0, 0), c(0, 0, 1, 1, 0))
cast_geoms(ply, "linestring")
cast_geoms(ply, "multipoint")
}
