% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restartApp.R
\name{restartApp}
\alias{restartApp}
\title{Restart an Application}
\usage{
restartApp(appName, account = NULL, server = NULL, quiet = FALSE)
}
\arguments{
\item{appName}{Name of application to restart}

\item{account}{Account name. If a single account is registered on the system
then this parameter can be omitted.}

\item{server}{Server name. Required only if you use the same account name on
multiple servers (see \code{\link[=servers]{servers()}})}

\item{quiet}{Request that no status information be printed to the console
during the operation.}
}
\description{
Restart an application currently running on a remote server.

Supported servers: ShinyApps servers
}
\note{
This function works only for ShinyApps servers.
}
\examples{
\dontrun{

# restart an application
restartApp("myapp")
}
}
\seealso{
\code{\link[=applications]{applications()}}, \code{\link[=deployApp]{deployApp()}}, and
\code{\link[=terminateApp]{terminateApp()}}
}
