% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/records.R, R/rtoi.R
\name{get_dir}
\alias{get_dir}
\alias{get_dir,records-method}
\alias{get_dir,records}
\alias{get_order,records-method}
\alias{get_dir,rtoi-method}
\alias{get_dir,rtoi}
\title{Get the file path of a \code{records} or an \code{rtoi}}
\usage{
get_dir(x)

\S4method{get_dir}{records}(x)

\S4method{get_order}{records}(x)

\S4method{get_dir}{rtoi}(x)
}
\arguments{
\item{x}{.}
}
\value{
the file path in the records
}
\description{
Get the file path of a \code{records} or an \code{rtoi}
}
\examples{
\dontrun{
# load example rtoi
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

navarre <- read_rtoi(file.path(tempdir(),"Navarre"))

# get the path of the
get_dir(navarre)

# get the records
rcds <- records(navarre)

# gets the relative path to store records data
get_dir(rcds)
}
}
