% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specVar.R
\name{specVar}
\alias{specVar}
\title{specVar}
\usage{
specVar(img, pixel.res)
}
\arguments{
\item{img}{Object of class \emph{RasterLayer}.}

\item{pixel.res}{Spatial resolution (unit depends on the spatial projection).}
}
\value{
A \emph{list}.
}
\description{
{Tool to support the selection of adequate satellite spatial resolution. Evaluates
how the spectral variability within a pixel change with the change in spatial resolution.}
}
\details{
{Given a raster object (\emph{img}), the function determines how degrading its spatial resolution impacts
our ability to perceive the complexity of the landscape. For the pixel resolution given by \emph{pixel.res}, The
function resamples \emph{img} and estimates the Mean Absolute Percentage Error (MAPE) for each pixel. The MAPE is
estimated as \eqn{100 / n * sum(abs(O - A / O)} where \emph{O} are the original value in \emph{img}, \emph{A} the
aggregated value in the aggregated image and \emph{n} the number of non-NA pixels in the original image The
output of the function consists of:
\itemize{
 \item{\emph{mape} - MAPE raster.}
 \item{\emph{plot} - Histogram of \emph{mape}.}}}
}
\examples{
\dontrun{

 require(raster)

 # read raster data
 r <- raster(system.file('extdata', '2013-07-16_ndvi.tif', package="rsMove"))

 # apply function
 s.var <- specVar(r, 60)

}
}
\seealso{
\code{\link{tMoveRes}} \code{\link{sMoveRes}}
}
