##' Estimated coefficients
##'
##' S3 methods extracting estimated coefficients for objects generated by
##' \code{rrpack}.
##'
##' @name rrpack-coef
##'
##' @param object Object generated by \code{rrpack}.
##' @param ... Other argumnts for future usage.
##' @return A numeric matrix.
##' @importFrom stats coef
NULL

##' @rdname rrpack-coef
##' @export
coef.mrrr <- function(object, ...)
{
    object$coef
}

##' @rdname rrpack-coef
##' @export
coef.cv.mrrr <- function(object, ...)
{
    object$fit$coef
}

##' @rdname rrpack-coef
##' @export
coef.r4 <- function(object, ...)
{
    object$coef
}

##' @rdname rrpack-coef
##' @export
coef.rrr <- function(object, ...)
{
    object$coef
}

##' @rdname rrpack-coef
##' @export
coef.rrr.fit <- function(object, ...)
{
    object$coef
}

##' @rdname rrpack-coef
##' @export
coef.cv.rrr <- function(object, ...)
{
    object$coef
}

##' @rdname rrpack-coef
##' @export
coef.srrr <- function(object, ...)
{
    object$coef
}

##' @rdname rrpack-coef
##' @export
coef.sofar <- function(object, ...)
{
  tcrossprod(object$U%*%diag(object$D,nrow=object$rank, ncol = object$rank),object$V)
}

##' @rdname rrpack-coef
##' @export
coef.rssvd <- function(object, ...)
{
  tcrossprod(object$U%*%diag(object$D,nrow=object$rank, ncol = object$rank),object$V)
}
