/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.lang.ParserBase;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ParserQueryBase
extends ParserBase {
    private Stack<Query> stack = new Stack();
    protected Query query;
    private UpdateRequest request = null;
    private boolean b;
    private List<Var> variables = null;
    private List<Binding> values = null;
    private int currentColumn = -1;

    public void setQuery(Query q) {
        this.query = q;
        this.setPrologue(q);
    }

    public Query getQuery() {
        return this.query;
    }

    protected UpdateRequest getUpdateRequest() {
        return this.request;
    }

    public void setUpdateRequest(UpdateRequest request) {
        this.request = request;
        this.setPrologue(request);
    }

    protected void startUpdateOperation() {
    }

    protected void finishUpdateOperation() {
    }

    protected void startUpdateRequest() {
    }

    protected void finishUpdateRequest() {
    }

    protected void startDataInsert(int line, int col) {
        this.b = this.getBNodesAreVariables();
        this.setBNodesAreVariables(false);
    }

    protected void finishDataInsert(int line, int col) {
        this.setBNodesAreVariables(this.b);
    }

    protected void startDataDelete(int line, int col) {
        this.b = this.getBNodesAreVariables();
        this.setBNodesAreVariables(false);
    }

    protected void finishDataDelete(int line, int col) {
        this.setBNodesAreVariables(this.b);
    }

    protected void emitUpdate(Update update2) {
        this.request.add(update2);
    }

    protected void startSubSelect(int line, int col) {
        Query subQuery;
        this.stack.push(this.query);
        this.query = subQuery = new Query(this.getPrologue());
    }

    protected Query endSubSelect(int line, int column) {
        Query subQuery = this.query;
        if (!subQuery.isSelectType()) {
            ParserQueryBase.throwParseException("Subquery not a SELECT query", line, column);
        }
        this.query = this.stack.pop();
        return subQuery;
    }

    protected void startBinding(int line, int col) {
        this.variables = new ArrayList<Var>();
        this.values = new ArrayList<Binding>();
    }

    private Binding currentValueRow() {
        return this.values.get(this.values.size() - 1);
    }

    protected void emitBindingVariable(Var v, int line, int col) {
        this.variables.add(v);
    }

    protected void startBindingValueRow(int line, int col) {
        this.values.add(new BindingMap());
        this.currentColumn = -1;
    }

    protected void emitBindingValue(Node n, int line, int col) {
        ++this.currentColumn;
        if (this.currentColumn >= this.variables.size()) {
            return;
        }
        Var v = this.variables.get(this.currentColumn);
        if (n != null) {
            this.currentValueRow().add(v, n);
        }
    }

    protected void finishBindingValueRow(int line, int col) {
        if (this.variables.size() != this.currentValueRow().size()) {
            String msg = String.format("Mismatch: %d variables but %d values", this.variables.size(), this.currentValueRow().size());
            msg = QueryParseException.formatMessage(msg, line, col);
            throw new QueryParseException(msg, line, col);
        }
    }

    protected void finishBinding(int line, int col) {
        this.getQuery().setBindings(this.variables, this.values);
    }
}

