% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yank-assign.R, R/yank.R
\name{rray_yank<-}
\alias{rray_yank<-}
\alias{[[<-.vctrs_rray}
\alias{rray_yank_assign}
\alias{rray_yank}
\alias{[[.vctrs_rray}
\title{Get or set elements of an array \emph{by position}}
\usage{
rray_yank(x, i) <- value

\method{[[}{vctrs_rray}(x, i, ...) <- value

rray_yank_assign(x, i, value)

rray_yank(x, i)

\method{[[}{vctrs_rray}(x, i, ...)
}
\arguments{
\item{x}{A vector, matrix, array or rray.}

\item{i}{One of the following:
\itemize{
\item An integer vector specifying the positions of the elements to yank.
\item A 1D logical vector of either length 1 or \code{rray_elems(x)}.
\item A logical with the exact same dimensions as \code{x}.
}}

\item{value}{A 1D value to be assigned to the location yanked by \code{i}. It will
be cast to the type of \code{rray_yank(x, i)}.}

\item{...}{Not used. An error is thrown if extra arguments are supplied here.}
}
\value{
A 1D vector of elements yanked out of \code{x}.
}
\description{
\itemize{
\item \code{rray_yank()} gets and sets elements from an array \emph{by position}. It is the
complement to \code{\link[=rray_extract]{rray_extract()}}, which gets and sets elements \emph{by index}.
\item For rrays, \code{[[} is powered by \code{rray_yank()}, and allows you to
select multiple elements by position with the syntax: \code{x[[i]]}.
\item There are three assignment variations that all work essentially the same.
They ensures that \code{value} has the same inner type as \code{x}, and \code{value} must be
1D.
\itemize{
\item \code{rray_yank(x, i) <- value}
\item \code{x[[i]] <- value}
\item \code{rray_yank_assign(x, i, value)}
}
}
}
\details{
\code{rray_yank()} is meant as a replacement for the traditional behavior of
\code{x[i]}, which extracts multiple elements by their position, and returns a
1D vector. rray is much stricter, and for rrays \code{x[i]} would return the
\code{i} rows of \code{x}, without dropping any dimensions. Separating this special
behavior of extracting by position into a new function is less surprising,
and allows \code{[} to be more consistent and stable.

\code{rray_yank()} never keeps dimension names. For >1D objects, this would not
be well defined to begin with, so the decision was made to keep this behavior
for 1D objects as well. Think of \code{rray_yank()} as a way to rip out the inner
elements of \code{x}. The dimension names and outer type are not a part of
this information.
}
\section{The Double Bracket \code{[[}}{


\code{rray_yank()} powers \code{[[} for rray objects. It works a bit differently from
base R. As with \code{[}, base R allows \code{[[} to perform two roles. It can extract
\emph{one} element by position with \code{x[[i]]}, or \emph{one} element by index with
\code{x[[i, j, ...]]}. This felt too flexible, so with rray objects \code{[[} is
directly powered by \code{rray_yank()}, meaning it can only do \code{x[[i]]}. However,
multiple values of \code{i} are allowed, rather than just 1, meaning that
\code{x[[c(3, 5)]]} will extract the 3rd and 5th positions in \code{x} and return
them as a 1D array.

Notably this means that the index extraction behavior of \code{x[[i, j, ...]]}
is missing with \code{[[} for rrays. If you want that behavior,
see \code{\link[=rray_extract]{rray_extract()}}.
}

\examples{
x <- rray(10:17, c(2, 2, 2))

# Resulting dimension is always 1D, and is a base R array
rray_yank(x, 1:3)

# Subsetting with a logical is possible if it is either
# length 1 or the length of `x`
rray_yank(x, FALSE)
rray_yank(x, rep(c(TRUE, FALSE), times = rray_elems(x) / 2))

# You can assign a 1D vector to these yanked selections
# Length 1 values are recycled as required
rray_yank(x, c(1, 3, 5)) <- 9

# `rray_yank()` powers `[[` as well
# Notably, you can yank multiple values in `[[`
x[[c(1, 3, 5)]] <- NA

# Logicals with the same dim as `x` can also be used as a yank indexer
# This comes in handy as a way to remove NA values
x[[is.na(x)]] <- 0

}
\seealso{
Other rray subsetters: \code{\link{rray_extract<-}},
  \code{\link{rray_slice<-}}, \code{\link{rray_subset<-}}
}
\concept{rray subsetters}
