% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rray.R
\name{rray_elems}
\alias{rray_elems}
\title{Compute the number of elements in an array}
\usage{
rray_elems(x)
}
\arguments{
\item{x}{A vector, matrix, array or rray.}
}
\value{
A single integer. The number of elements in \code{x}.
}
\description{
\code{rray_elems()} computes the number of individual elements in an array. It
generally computes the same thing as \code{length()}, but has a more predictable
name.
}
\examples{
rray_elems(1:5)

rray_elems(matrix(1, 2, 2))

# It is different from `vec_size()`,
# which only returns the number of
# observations
library(vctrs)
vec_size(matrix(1, 2, 2))

}
