% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{rray-compare}
\alias{rray-compare}
\alias{>.vctrs_rray}
\alias{rray_greater}
\alias{>=.vctrs_rray}
\alias{rray_greater_equal}
\alias{<.vctrs_rray}
\alias{rray_lesser}
\alias{<=.vctrs_rray}
\alias{rray_lesser_equal}
\alias{==.vctrs_rray}
\alias{rray_equal}
\alias{!=.vctrs_rray}
\alias{rray_not_equal}
\title{Compare arrays}
\usage{
\method{>}{vctrs_rray}(e1, e2)

rray_greater(x, y)

\method{>=}{vctrs_rray}(e1, e2)

rray_greater_equal(x, y)

\method{<}{vctrs_rray}(e1, e2)

rray_lesser(x, y)

\method{<=}{vctrs_rray}(e1, e2)

rray_lesser_equal(x, y)

\method{==}{vctrs_rray}(e1, e2)

rray_equal(x, y)

\method{!=}{vctrs_rray}(e1, e2)

rray_not_equal(x, y)
}
\arguments{
\item{e1, e2}{Generally, the same as \code{x} and \code{y}. See Details.}

\item{x, y}{Two vectors, matrices, arrays, or rrays.}
}
\value{
The value of the comparison, with dimensions identical to the common
dimensions of the inputs.
}
\description{
These operators compare multiple arrays together, with broadcasting. The
underlying functions powering the comparison operators are also exported
for use with base R objects.
}
\details{
The comparison operators themselves rely on R's dispatching rules to
dispatch to the correct rray comparison operator. When comparing rrays with
base R matrices and arrays, this generally works fine. However, if you
compare classed objects like \code{factor("x") > rray(1)} then a fall through
method is used and a warning is thrown. There is nothing we can do about
this. See \code{?groupGeneric} for more information on this.
}
\examples{
x <- rray(1:12, c(2, 2, 3))
y <- matrix(1:2)

# True except in first 2 positions
x > y

# All true
x >= y

# False everywhere
x < y

# False except in the first 2 positions
x <= y

}
