% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsummary.R
\name{rsummary}
\alias{rsummary}
\title{Compute usable summary of columns of remote table.}
\usage{
rsummary(db, tableName, ..., countUniqueNum = FALSE, quartiles = FALSE,
  cols = NULL)
}
\arguments{
\item{db}{database connection.}

\item{tableName}{name of table.}

\item{...}{force additional arguments to be bound by name.}

\item{countUniqueNum}{logical, if TRUE include unique non-NA counts for numeric cols.}

\item{quartiles}{logical, if TRUE add Q1 (25\%), median (50\%), Q3 (75\%) quartiles.}

\item{cols}{if not NULL set of columns to restrict to.}
}
\value{
data.frame summary of columns.
}
\description{
Compute per-column summaries and return as a \code{data.frame}.  Warning: can be an expensive operation.
}
\details{
For numeric columns includes \code{NaN} in \code{nna} count (as is typcial for \code{R}, e.g.,
\code{is.na(NaN)}).
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  d <- data.frame(p= c(TRUE, FALSE, NA),
                  s= NA,
                  w= 1:3,
                  x= c(NA,2,3),
                  y= factor(c(3,5,NA)),
                  z= c('a',NA,'a'),
                  stringsAsFactors=FALSE)
  db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  RSQLite::initExtension(db)
  dbi_copy_to(db, "dRemote", d,
              overwrite = TRUE, temporary = TRUE)
  print(rsummary(db, "dRemote"))
  DBI::dbDisconnect(db)
}

}
