% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AssessmentItem.R
\docType{methods}
\name{createQtiTask-methods}
\alias{createQtiTask-methods}
\alias{createQtiTask}
\alias{createQtiTask,AssessmentItem-method}
\alias{createQtiTask,AssessmentItem}
\title{Create XML or zip file for question specification}
\usage{
createQtiTask(object, dir = ".", verification = FALSE, zip = FALSE)

\S4method{createQtiTask}{AssessmentItem}(object, dir = ".", verification = FALSE, zip = FALSE)
}
\arguments{
\item{object}{An instance of the S4 object (\link{SingleChoice}, \link{MultipleChoice},
\link{Essay}, \link{Entry}, \link{Ordering}, \link{OneInRowTable}, \link{OneInColTable},
\link{MultipleChoiceTable}, \link{DirectedPair}).}

\item{dir}{A character value, optional; a folder to store xml file; working
directory is used by default.}

\item{verification}{A boolean value, optional; to check validity of xml file.
Default is \code{FALSE}.}

\item{zip}{A boolean value, optional; the \code{TRUE} value allows to create a
zip archive with the manifest and task files inside. Default is \code{FALSE}.}
}
\value{
A path to xml or zip file.
}
\description{
Create XML or zip file for question specification
}
\examples{
essay <- new("Essay", prompt = "Test task", title = "Essay")
\dontrun{
# creates folder with XML (side effect)
createQtiTask(essay, "result")
# creates folder with zip (side effect)
createQtiTask(essay, "result", zip = TRUE)
}
}
