% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section_builder.R
\name{test4opal}
\alias{test4opal}
\title{Create a test for LMS OPAL}
\usage{
test4opal(
  content,
  identifier = "test_identifier",
  title = "Test Title",
  time_limit = 90L,
  max_attempts = 1L,
  files = NULL,
  calculator = NULL,
  academic_grading = FALSE,
  grade_label = c(en = "Grade", de = "Note"),
  table_label = c(en = "Grade", de = "Note"),
  navigation_mode = "nonlinear",
  submission_mode = "individual",
  allow_comment = TRUE,
  rebuild_variables = TRUE,
  show_test_time = TRUE,
  mark_items = TRUE,
  keep_responses = FALSE,
  contributor = list(),
  description = "",
  rights = Sys.getenv("RQTI_RIGHTS"),
  version = "0.0.9"
)
}
\arguments{
\item{content}{A list containing \link{AssessmentSection} objects.}

\item{identifier}{A character value indicating the identifier of the test
file. Default is 'test_identifier'.}

\item{title}{A character value, optional, representing the file title.
Default is 'Test Title'.}

\item{time_limit}{An integer value, optional, controlling the time given to a
candidate for the test in minutes. Default is 90 minutes.}

\item{max_attempts}{An integer value, optional, indicating the maximum number
of attempts allowed for the candidate. Default is 1.}

\item{files}{A character vector, optional; paths to files that will be
accessible to the candidate during the test/exam.}

\item{calculator}{A character, optional; determines whether to show a
calculator to the candidate. Possible values:
\itemize{
\item 'simple'
\item 'scientific'.
Default is \code{NULL}.
}}

\item{academic_grading}{A boolean, optional; enables to show to candidate at
the end of the testing a grade according to 5-point academic grade system
as a feedback; Default is \code{FALSE}.}

\item{grade_label}{A character value, optional; a short message that shows
with a grade in the final feedback; for multilingual use, it can be a named
vector with two-letter ISO language codes as names (e.g., c(en="Grade",
de="Note")); during test creation, it takes the value for the language of
the operating system; c(en="Grade", de="Note")is default.}

\item{table_label}{A character value, optional; a concise message to display
as the column title of the grading table in the final feedback; for
multilingual use, it can be a named vector with two-letter ISO language
codes as names (e.g., c(en="Grade", de="Note")); during test creation, it
takes the value for the language of the operating system; c(en="Grade",
de="Note")is default.}

\item{navigation_mode}{A character value, optional, determining the general
paths that the candidate may have during the exam. Two mode options are
possible:
- 'linear': Candidate is not allowed to return to previous questions.
- 'nonlinear': Candidate is free to navigate; used by default.}

\item{submission_mode}{A character value, optional, determining when the
candidate's responses are submitted for response processing. One of two
mode options is possible:
- 'individual': Submit candidates' responses on an item-by-item basis; used by default.
- 'simultaneous': Candidates' responses are submitted all together by the end of the test.}

\item{allow_comment}{A boolean, optional, enabling the candidate to leave
comments in each question. Default is \code{TRUE.}}

\item{rebuild_variables}{A boolean, optional, enabling the recalculation of
variables and reshuffling the order of choices for each item-attempt.
Default is \code{TRUE}.}

\item{show_test_time}{A boolean, optional, determining whether to show
candidate elapsed processing time without a time limit. Default is \code{TRUE}.}

\item{mark_items}{A boolean, optional, determining whether to allow candidate
marking of questions. Default is \code{TRUE}.}

\item{keep_responses}{A boolean, optional, determining whether to save the
candidate's answers from the previous attempt. Default is \code{FALSE}.}

\item{contributor}{A list of objects \link{QtiContributor}-type that holds
metadata information about the authors.}

\item{description}{A character string providing a textual description of the
content of this learning object.}

\item{rights}{A character string describing the intellectual property rights
and conditions of use for this learning object. By default it takes value
from environment variable 'RQTI_RIGHTS'.}

\item{version}{A character string representing the edition/version of this
learning object.}
}
\value{
An \link{AssessmentTestOpal} object
}
\description{
Create an AssessmentTestOpal \code{rqti}-object.
}
\examples{
sc <- new("SingleChoice", prompt = "Question", choices = c("A", "B", "C"))
es <- new("Essay", prompt = "Question")
s <- section(c(sc, es), title = "Section with nonrandomized tasks")
t <- test4opal(s, title = "Example of the Exam", academic_grading = TRUE,
show_test_time = FALSE)
}
\seealso{
\code{\link[=test]{test()}}, \code{\link[=section]{section()}},
\link{AssessmentTestOpal}, \link{AssessmentSection}
}
