% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{coef.rq.pen.seq.cv}
\alias{coef.rq.pen.seq.cv}
\title{Returns coefficients from a rq.pen.seq.cv object.}
\usage{
\method{coef}{rq.pen.seq.cv}(object, septau = TRUE, cvmin = TRUE, useDefaults = TRUE, tau = NULL, ...)
}
\arguments{
\item{object}{An rq.pen.seq.cv object.}

\item{septau}{Whether tuning parameter should be optimized separately for each quantile.}

\item{cvmin}{If TRUE then minimum error is used, if FALSE then one standard error rule is used.}

\item{useDefaults}{Whether the default results are used. Set to FALSE if you you want to specify specific models and lambda values.}

\item{tau}{Quantiles of interest.}

\item{...}{Additional parameters sent to coef.rq.pen.seq()}
}
\value{
Returns coefficients
}
\description{
Returns coefficients from a rq.pen.seq.cv object.
}
\examples{
 \dontrun{
 set.seed(1)
 x <- matrix(rnorm(800),nrow=100)
 y <- 1 + x[,1] - 3*x[,5] + rnorm(100)
 lassoModels <- rq.pen.cv(x,y,tau=seq(.1,.9,.1))
 coefficients(lassoModels,septau=FALSE)
 coefficients(lassoModels,cvmin=FALSE)
}
}
\author{
Ben Sherwood, \email{ben.sherwood@ku.edu}
}
