% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{test_prevalence_fit}
\alias{test_prevalence_fit}
\title{Test simulated prevalence fit.}
\usage{
test_prevalence_fit(object)
}
\arguments{
\item{object}{A \code{prevalence} object.}
}
\value{
P-value from a chi-squared test of difference between prevalence
  prediction and counted prevalence at the index date.
}
\description{
Calculates a Chi squared test between predicted yearly contributions to
prevalence, and the observed values obtained from the registry, indicating
whether the simulated prevalence values are accurate.
}
\examples{
data(prevsim)

\dontrun{

obj <- prevalence(Surv(time, status) ~ age(age) + sex(sex) + entry(entrydate) + event(eventdate),
                  data=prevsim, num_years_to_estimate = c(5, 10), population_size=1e6,
                  start = "2005-09-01",
                  num_reg_years = 8, cure = 5)

test_prevalence_fit(obj)
}
}
\seealso{
Other prevalence functions: \code{\link{prevalence}}
}
\concept{prevalence functions}
