% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_data.R
\name{format_market_data}
\alias{format_market_data}
\title{Format bid and ask market data with HTML}
\usage{
format_market_data(data)
}
\arguments{
\item{data}{'PredictIt' market data, of class \code{data.frame} or
\code{tibble}, as returned by
\code{\link[rpredictit:all_markets]{all_markets()}} or
\code{\link[rpredictit:tweet_markets]{tweet_markets()}}.}
}
\value{
A \code{\link[=tibble]{tibble}} containing bid and ask data formatted
  with HTML tags and user-friendly column names.
}
\description{
Wrapper function to apply HTML formatting to 'PredictIt' market
  data. Can be displayed in a \code{shiny} app, or standalone in an
  \code{htmlwidget} (e.g. \code{\link[DT:datatable]{datatable}}).
}
\examples{
data <- all_markets()
format_market_data(data)

}
