##' rpostgisLT
##'
##' The `rpostgisLT` package develops the integration of R and PostGIS
##' for managing movement trajectories. The focus is on streamlining
##' the workflow for biologists to store and process animal
##' trajectories in PostGIS and analyze them in R, thus utilizing the
##' strengths of both software. The package relies on `ltraj` objects
##' from the R package `adehabitatLT`, and provides the analogous
##' `pgtraj` data structure in PostGIS, with all functions to create
##' and manage `pgtraj` data, and convert from and to both format
##' (`pgtraj` in PostGIS, `ltraj` in R). For a list of documented
##' functions, use \code{library(help = "rpostgisLT")}
##'
##' @title Integration of ltraj (adehabitatLT) and pgtraj (PostGIS).
##' @name rpostgisLT
##' @docType package
##' @import rpostgis
##' @import RPostgreSQL
##' @import DBI
##' @import adehabitatLT
##' @author Balázs Dukai \email{balazs.dukai@@gmail.com}
NULL
