% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plosword.R
\name{plosword}
\alias{plosword}
\title{Search results on a keyword over all fields in PLoS Journals.}
\usage{
plosword(terms, vis = FALSE, ...)
}
\arguments{
\item{terms}{search terms (character)}

\item{vis}{visualize results in bar plot or not (TRUE or FALSE)}

\item{...}{Optional additional curl options (debugging tools mostly)}
}
\value{
Number of search results (vis = FALSE), or number of search in a table
   and a histogram of results (vis = TRUE).
}
\description{
Search results on a keyword over all fields in PLoS Journals.
}
\examples{
\dontrun{
plosword('Helianthus')
out <- plosword(list('monkey','replication','design','sunflower','whale'),
   vis = TRUE)
out[[1]] # results in a data frame
out[[2]] # results in a bar plot

# Pass in curl options
plosword('Helianthus', config=verbose())
}
}

