% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{is_sample_stats}
\alias{is_sample_stats}
\title{Test if elements in sample column are statistics}
\usage{
is_sample_stats(x)
}
\arguments{
\item{x}{Vector of sample values from an rplexos query}
}
\description{
In stochastic simulations, PLEXOS will return sample results and their statistics together. This function
makes it easy to separate them with a filter.
}
\examples{
\dontrun{db <- plexos_open()}
\dontrun{res <- query_month(db, "Generator", "Generation")}
\dontrun{res \%>\% filter(sample_stats(sample))    # To obtain statistics}
\dontrun{res \%>\% filter(!sample_stats(sample))   # To obtain sample results}
}

