% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{push_conn}
\alias{push_conn}
\alias{pop_conn}
\alias{swap_conn}
\alias{rotate_stack}
\alias{show_conn_stack}
\title{Multiple PostgreSQL connections}
\usage{
push_conn()

pop_conn()

swap_conn()

rotate_stack(n = 1L)

show_conn_stack()
}
\arguments{
\item{n}{number of shifts}
}
\description{
Manage multiple connections on a stack
}
\details{
These functions allow you to store multiple connections on a stack. They are
only used for their side-effects. \code{\link{rpg}} stores an active connection
pointer internally. This pointer can be moved onto the stack and manipulated.
Once on the stack, the pointer is no longer active. You must use
\code{swap_conn} or \code{pop_conn} to reactive a pushed connection, or call
\code{\link{connect}} to create a new active connection.

\code{push_conn} pushes the current connection onto the connection stack
leaving the active connection null.

\code{pop_conn} pops a connection off the stack and makes it active. Whatever
connection was active when \code{pop_conn} is called will be disconnected and
cleared. Use \code{swap_conn} to preserve the active connection.

\code{swap_conn} swaps the active connection with the connection on the top
of the stack. If the stack is empty, the connection is swapped with a null
connection.

\code{rotate_stack} moves the bottom of the stack to the top.

\code{show_conn_stack} returns a data frame with information about the
connections on the stack.
}
\examples{
\dontrun{
# make some databases
dbs = paste0("rpgdb", 1:3)
lapply(paste("createdb", dbs), system)

# connect
connect(dbname = dbs[1]); push_conn()
connect(dbname = dbs[2]); push_conn()
connect(dbname = dbs[3]); push_conn()

show_conn_stack()
rotate_stack()
show_conn_stack()
rotate_stack(2)
show_conn_stack()
pop_conn()
show_conn_stack()
get_conn_info("dbname")
swap_conn()
show_conn_stack()
get_conn_info("dbname")
pop_conn()
show_conn_stack()
pop_conn()
show_conn_stack()
disconnect()
connect()
lapply(paste("dropdb", dbs), system)}

}
